/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.userutil;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageHeaders {
    private static Logger logger = LogManager.getLogger(MessageHeaders.class);
    private Map<String, List<String>> delegate;

    public MessageHeaders(Map<String, List<String>> delegate) {
        this.delegate = delegate;
    }

    @Deprecated
    public String get(String key) {
        logger.error("The get(key) method for retrieving Http headers is deprecated and will soon be removed. Please use getHeader(key) or getHeaderList(key) instead. The caller was trying to retrieve the key: " + key);
        return this.getHeader(key);
    }

    public String getHeader(String key) {
        List<String> list = this.delegate.get(key);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public List<String> getHeaderList(String key) {
        List<String> list = this.delegate.get(key);
        if (CollectionUtils.isNotEmpty(list)) {
            return Collections.unmodifiableList(list);
        }
        return null;
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    public boolean contains(String key) {
        return this.delegate.keySet().contains(key);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

