/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.util.ChannelDependencyException;
import com.mirth.connect.util.ChannelDependencyGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class ChannelDependencyUtil {
    public static ChannelDependencyGraph getDependencyGraph(Set<ChannelDependency> dependencies) throws ChannelDependencyException {
        return new ChannelDependencyGraph(new HashSet<ChannelDependency>(CollectionUtils.emptyIfNull(dependencies)));
    }

    public static OrderedChannels getOrderedChannels(Set<ChannelDependency> dependencies, Set<String> channelIds) throws ChannelDependencyException {
        return ChannelDependencyUtil.getOrderedChannels(channelIds, ChannelDependencyUtil.getDependencyGraph(dependencies));
    }

    public static OrderedChannels getOrderedChannels(Set<String> channelIds, ChannelDependencyGraph graph) {
        HashSet<String> unorderedIds = new HashSet<String>(channelIds);
        ArrayList<Set<String>> orderedIds = new ArrayList<Set<String>>();
        for (Set set : graph.getOrderedElements()) {
            set.retainAll(channelIds);
            if (set.isEmpty()) continue;
            orderedIds.add(set);
            unorderedIds.removeAll(set);
        }
        return new OrderedChannels(unorderedIds, orderedIds);
    }

    public static class OrderedChannels {
        private Set<String> unorderedIds;
        private List<Set<String>> orderedIds;

        public OrderedChannels(Set<String> unorderedIds, List<Set<String>> orderedIds) {
            this.unorderedIds = unorderedIds;
            this.orderedIds = orderedIds;
        }

        public Set<String> getUnorderedIds() {
            return this.unorderedIds;
        }

        public List<Set<String>> getOrderedIds() {
            return this.orderedIds;
        }
    }
}

