/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.model.Parameter;
import com.mirth.connect.model.Parameters;
import com.mirth.connect.model.codetemplates.CodeTemplateFunctionDefinition;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;

public class CodeTemplateUtil {
    private static Pattern COMMENT_PATTERN = Pattern.compile("^/\\*{2}([\\s\\S](?!\\*/))*[\\s\\S]?\\*/(\r\n|\r|\n)*");

    public static CodeTemplateDocumentation getDocumentation(String code) {
        String description = null;
        CodeTemplateFunctionDefinition functionDefinition = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            try {
                try {
                    FunctionVisitor visitor = CodeTemplateUtil.parseFunction(code);
                    description = visitor.getDescription();
                    functionDefinition = visitor.getFunctionDefinition();
                }
                catch (Throwable t) {
                    Matcher matcher = COMMENT_PATTERN.matcher(code);
                    if (matcher.find()) {
                        description = matcher.group().replaceAll("^\\s*/\\*+\\s*|\\s*\\*+/\\s*$|(\r\n|\r|\n)\\s*@[\\s\\S]*", "").trim();
                        code = StringUtils.substring((String)code, (int)matcher.end());
                        FunctionVisitor visitor = CodeTemplateUtil.parseFunction(code);
                        functionDefinition = visitor.getFunctionDefinition();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new CodeTemplateDocumentation(description, functionDefinition);
    }

    private static FunctionVisitor parseFunction(String code) throws IOException {
        FunctionVisitor visitor = new FunctionVisitor();
        CompilerEnvirons env = new CompilerEnvirons();
        env.setRecordingLocalJsDocComments(true);
        env.setAllowSharpComments(true);
        env.setRecordingComments(true);
        new Parser(env).parse((Reader)new StringReader(code), null, 1).visitAll((NodeVisitor)visitor);
        return visitor;
    }

    public static String updateCode(String code) {
        if (StringUtils.isNotBlank((CharSequence)code)) {
            code = StringUtils.trim((String)code);
            int endIndex = 0;
            Matcher matcher = COMMENT_PATTERN.matcher(code);
            if (matcher.find()) {
                endIndex = matcher.end();
            }
            CodeTemplateDocumentation documentation = CodeTemplateUtil.getDocumentation(code);
            String description = documentation.getDescription();
            CodeTemplateFunctionDefinition functionDefinition = documentation.getFunctionDefinition();
            if (StringUtils.isBlank((CharSequence)description)) {
                description = "Modify the description here. Modify the function name and parameters as needed. One function per template is recommended; create a new code template for each new function.";
            }
            StringBuilder builder = new StringBuilder("/**");
            for (String descriptionLine : description.split("\r\n|\r|\n")) {
                builder.append("\n\t").append(WordUtils.wrap((String)descriptionLine, (int)100, (String)"\n\t", (boolean)false));
            }
            if (functionDefinition != null) {
                builder.append('\n');
                if (CollectionUtils.isNotEmpty(functionDefinition.getParameters())) {
                    for (Parameter parameter : functionDefinition.getParameters()) {
                        StringBuilder parameterBuilder = new StringBuilder("\n\t@param {");
                        parameterBuilder.append(StringUtils.defaultString((String)parameter.getType(), (String)"Any"));
                        parameterBuilder.append("} ").append(parameter.getName()).append(" - ").append(StringUtils.trimToEmpty((String)parameter.getDescription()));
                        builder.append(WordUtils.wrap((String)parameterBuilder.toString(), (int)100, (String)"\n\t\t", (boolean)false));
                    }
                }
                StringBuilder returnBuilder = new StringBuilder("\n\t@return {").append(StringUtils.defaultString((String)functionDefinition.getReturnType(), (String)"Any")).append("} ").append(StringUtils.trimToEmpty((String)functionDefinition.getReturnDescription()));
                builder.append(WordUtils.wrap((String)returnBuilder.toString(), (int)100, (String)"\n\t\t", (boolean)false));
            }
            builder.append("\n*/\n");
            return builder.toString() + code.substring(endIndex);
        }
        return code;
    }

    public static String stripDocumentation(String code) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)code) && (matcher = COMMENT_PATTERN.matcher(code = StringUtils.trim((String)code))).find()) {
            return StringUtils.trim((String)code.substring(matcher.end()));
        }
        return code;
    }

    private static class FunctionVisitor
    implements NodeVisitor {
        private static Pattern DOCUMENTATION_PATTERN = Pattern.compile("/\\*{2,}(?<desc>([^\r\n]|(\r\n|\r|\n)(?!\\*/|\\s*@))+)|(?<anno>(\r\n|\r|\n)\\s*@([^\r\n]|(\r\n|\r|\n)(?!\\*/|\\s*@))+)");
        private static Pattern ANNOTATION_PARAM_PATTERN = Pattern.compile("@param(\\s*\\{(?<type>[^\\}]*)\\})?\\s*(?<name>\\w+)\\s*(?:-\\s*)?(?<desc>[\\s\\S]*)");
        private static Pattern ANNOTATION_RETURN_PATTERN = Pattern.compile("@returns?(\\s*\\{(?<type>[^\\}]*)\\})?\\s*(?<desc>[\\s\\S]*)");
        private Comment commentNode;
        private boolean found;
        private String description;
        private CodeTemplateFunctionDefinition functionDefinition;

        private FunctionVisitor() {
        }

        public String getDescription() {
            return this.description;
        }

        public CodeTemplateFunctionDefinition getFunctionDefinition() {
            return this.functionDefinition;
        }

        public boolean visit(AstNode node) {
            if (node instanceof AstRoot) {
                return true;
            }
            if (this.commentNode == null) {
                Comment comment = null;
                comment = node instanceof Comment ? (Comment)node : node.getJsDocNode();
                if (comment != null) {
                    Matcher matcher = DOCUMENTATION_PATTERN.matcher(comment.getValue());
                    while (matcher.find()) {
                        String desc = matcher.group("desc");
                        if (!StringUtils.isNotBlank((CharSequence)desc)) continue;
                        this.description = this.convertDesc(desc);
                    }
                    this.commentNode = comment;
                }
            }
            if (!this.found && node instanceof FunctionNode) {
                FunctionNode functionNode = (FunctionNode)node;
                this.functionDefinition = new CodeTemplateFunctionDefinition(functionNode.getFunctionName().getIdentifier());
                LinkedHashMap<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
                for (AstNode param : functionNode.getParams()) {
                    if (!(param instanceof Name)) continue;
                    String paramName = ((Name)param).getIdentifier();
                    parameterMap.put(paramName, new Parameter(paramName));
                }
                Comment comment = null;
                comment = this.commentNode != null ? this.commentNode : functionNode.getJsDocNode();
                if (comment != null) {
                    Matcher matcher = DOCUMENTATION_PATTERN.matcher(comment.getValue());
                    while (matcher.find()) {
                        Matcher annotationMatcher;
                        String annotation = this.convertDesc(matcher.group("anno"));
                        if (StringUtils.startsWithIgnoreCase((CharSequence)annotation, (CharSequence)"@param")) {
                            Parameter parameter;
                            annotationMatcher = ANNOTATION_PARAM_PATTERN.matcher(annotation);
                            if (!annotationMatcher.find() || (parameter = (Parameter)parameterMap.get(annotationMatcher.group("name"))) == null) continue;
                            parameter.setType(StringUtils.trimToEmpty((String)annotationMatcher.group("type")));
                            parameter.setDescription(this.convertDesc(annotationMatcher.group("desc")));
                            continue;
                        }
                        if (!StringUtils.startsWithIgnoreCase((CharSequence)annotation, (CharSequence)"@return") || !(annotationMatcher = ANNOTATION_RETURN_PATTERN.matcher(annotation)).find()) continue;
                        this.functionDefinition.setReturnType(StringUtils.trimToEmpty((String)annotationMatcher.group("type")));
                        this.functionDefinition.setReturnDescription(this.convertDesc(annotationMatcher.group("desc")));
                    }
                }
                this.functionDefinition.setParameters(new Parameters(parameterMap.values()));
                this.found = true;
            }
            return false;
        }

        private String convertDesc(String desc) {
            return StringUtils.trimToEmpty((String)desc).replaceAll("\\s*\\*+/\\s*$", "").replaceAll("[ \t\\x0B\f]*(\r\n|\r|\n)[ \t\\x0B\f]*", "\n").replaceAll("(?<=\\S)\n(?=\\S)", " ").replaceAll("\n{2,}", "\n\n");
        }
    }

    public static class CodeTemplateDocumentation {
        private String description;
        private CodeTemplateFunctionDefinition functionDefinition;

        public CodeTemplateDocumentation(String description, CodeTemplateFunctionDefinition functionDefinition) {
            this.description = description;
            this.functionDefinition = functionDefinition;
        }

        public String getDescription() {
            return this.description;
        }

        public CodeTemplateFunctionDefinition getFunctionDefinition() {
            return this.functionDefinition;
        }
    }
}

