DROP TABLE TEMPLATE

ALTER TABLE CHANNEL_STATISTICS DROP CONSTRAINT CHANNEL_STATS_ID_FK

ALTER TABLE CHANNEL_ALERT DROP CONSTRAINT ALERT_ID_CA_FK

ALTER TABLE ALERT_EMAIL DROP CONSTRAINT ALERT_ID_AE_FK

ALTER TABLE MESSAGE DROP CONSTRAINT CHANNEL_ID_FK

RENAME TABLE CHANNEL_ALERT TO OLD_CHANNEL_ALERT

RENAME TABLE ALERT_EMAIL TO OLD_ALERT_EMAIL

RENAME TABLE ALERT TO OLD_ALERT

RENAME TABLE MESSAGE TO OLD_MESSAGE

RENAME TABLE ATTACHMENT TO OLD_ATTACHMENT

RENAME TABLE CHANNEL_STATISTICS TO OLD_CHANNEL_STATISTICS

RENAME TABLE CHANNEL TO OLD_CHANNEL

RENAME TABLE CODE_TEMPLATE TO OLD_CODE_TEMPLATE

ALTER TABLE OLD_MESSAGE ADD CONSTRAINT CHANNEL_ID_FK FOREIGN KEY(CHANNEL_ID) REFERENCES OLD_CHANNEL(ID) ON DELETE CASCADE

CREATE TABLE CHANNEL (
	ID VARCHAR(36) NOT NULL PRIMARY KEY,
	NAME VARCHAR(40) NOT NULL,
	REVISION INTEGER,
	CHANNEL CLOB
)

CREATE TABLE ALERT (
	ID VARCHAR(36) NOT NULL PRIMARY KEY,
	NAME VARCHAR(255) NOT NULL UNIQUE,
	ALERT CLOB NOT NULL
)

CREATE TABLE CODE_TEMPLATE (
	ID VARCHAR(255) NOT NULL PRIMARY KEY,
	CODE_TEMPLATE CLOB
)

UPDATE SCRIPT SET GROUP_ID = 'Global' WHERE GROUP_ID = 'GLOBAL'

DELETE FROM CONFIGURATION WHERE CATEGORY = 'core' AND NAME = 'server.maxqueuesize'

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'server.queuebuffersize', '1000')

ALTER TABLE PERSON ALTER COLUMN LAST_LOGIN SET DEFAULT NULL