CREATE TABLE SCHEMA_INFO
	(VERSION VARCHAR(40));

CREATE TABLE EVENT
	(ID INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1) NOT NULL PRIMARY KEY,
	DATE_CREATED TIMESTAMP DEFAULT NULL,
	NAME CLOB NOT NULL,
	EVENT_LEVEL VARCHAR(40) NOT NULL,
	OUTCOME VARCHAR(40),
	ATTRIBUTES CLOB,
	USER_ID INTEGER NOT NULL,
	IP_ADDRESS VARCHAR(40),
	SERVER_ID CHARACTER VARYING(36));
	
CREATE TABLE CHANNEL
	(ID VARCHAR(36) NOT NULL PRIMARY KEY,
	NAME VARCHAR(40) NOT NULL,
	REVISION INTEGER,
	CHANNEL CLOB);

CREATE TABLE SCRIPT
	(GROUP_ID VARCHAR(40) NOT NULL,
	ID VARCHAR(40) NOT NULL,
	SCRIPT CLOB);
	
ALTER TABLE SCRIPT ADD PRIMARY KEY (GROUP_ID, ID);
	
CREATE TABLE PERSON
	(ID INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1) NOT NULL PRIMARY KEY,
	USERNAME VARCHAR(40) NOT NULL,
	FIRSTNAME VARCHAR(40),
	LASTNAME VARCHAR(40),
	ORGANIZATION VARCHAR(255),
	INDUSTRY VARCHAR(255),
	EMAIL VARCHAR(255),
	PHONENUMBER VARCHAR(40),
	DESCRIPTION VARCHAR(255),
	LAST_LOGIN TIMESTAMP DEFAULT NULL,
	GRACE_PERIOD_START TIMESTAMP DEFAULT NULL,
	STRIKE_COUNT INTEGER,
	LAST_STRIKE_TIME TIMESTAMP DEFAULT NULL,
	LOGGED_IN SMALLINT NOT NULL,
	ROLE VARCHAR(40),
	COUNTRY VARCHAR(40),
	STATETERRITORY VARCHAR(40),
	USERCONSENT BOOLEAN NOT NULL DEFAULT false
);
	
CREATE TABLE PERSON_PREFERENCE
	(PERSON_ID INTEGER NOT NULL,
	NAME VARCHAR(255) NOT NULL,
	VALUE CLOB,
	CONSTRAINT PERSON_ID_PERSON_PREF_FK FOREIGN KEY(PERSON_ID) REFERENCES PERSON(ID) ON DELETE CASCADE);
	
CREATE INDEX PERSON_PREFERENCE_INDEX1 ON PERSON_PREFERENCE(PERSON_ID);

CREATE TABLE PERSON_PASSWORD
	(PERSON_ID INTEGER NOT NULL,
	PASSWORD VARCHAR(255) NOT NULL,
	PASSWORD_DATE TIMESTAMP DEFAULT NULL,
	CONSTRAINT PERSON_ID_PP_FK FOREIGN KEY(PERSON_ID) REFERENCES PERSON(ID) ON DELETE CASCADE);

CREATE TABLE ALERT (
	ID VARCHAR(36) NOT NULL PRIMARY KEY,
	NAME VARCHAR(255) NOT NULL UNIQUE,
	ALERT CLOB NOT NULL
);

CREATE TABLE CODE_TEMPLATE_LIBRARY
	(ID VARCHAR(255) NOT NULL PRIMARY KEY,
	NAME VARCHAR(255) NOT NULL UNIQUE,
	REVISION INTEGER,
	LIBRARY CLOB);

CREATE TABLE CODE_TEMPLATE
	(ID VARCHAR(255) NOT NULL PRIMARY KEY,
	NAME VARCHAR(255) NOT NULL,
	REVISION INTEGER,
	CODE_TEMPLATE CLOB);
	
CREATE TABLE CONFIGURATION
	(CATEGORY VARCHAR(255) NOT NULL,
	NAME VARCHAR(255) NOT NULL,
	VALUE CLOB);
	
ALTER TABLE CONFIGURATION ADD PRIMARY KEY (CATEGORY, NAME);
	
CREATE TABLE CHANNEL_GROUP
	(ID VARCHAR(255) NOT NULL PRIMARY KEY,
	NAME VARCHAR(255) NOT NULL UNIQUE,
	REVISION INTEGER,
	CHANNEL_GROUP CLOB);
	
CREATE TABLE DEBUGGER_USAGE
    (ID INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1) NOT NULL PRIMARY KEY,
    SERVER_ID VARCHAR(50) NOT NULL,
    DUPP_COUNT INTEGER,
    ATTACH_BATCH_COUNT INTEGER,
    SOURCE_CONNECTOR_COUNT INTEGER,
    SOURCE_FILTER_TRANS_COUNT INTEGER,
    DESTINATION_FILTER_TRANS_COUNT INTEGER,
    DESTINATION_CONNECTOR_COUNT INTEGER,
    RESPONSE_COUNT INTEGER,
    INVOCATION_COUNT INTEGER);	
	
INSERT INTO PERSON (USERNAME, LOGGED_IN) VALUES('admin', 0);

INSERT INTO PERSON_PASSWORD (PERSON_ID, PASSWORD) VALUES(1, 'b8cA3mDkavInMc2JBYa6/C3EGxDp7ppqh7FsoXx0x8+3LWK3Ed3ELg==');

INSERT INTO SCHEMA_INFO (VERSION) VALUES ('4.6.0');

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'stats.enabled', '1');

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'server.resetglobalvariables', '1');

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'smtp.timeout', '5000');

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'smtp.auth', '0');

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'smtp.secure', '0');

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'server.queuebuffersize', '1000');
