-- MySQL Migration script for Lookup Table Management System

-- Create LOOKUP_GROUP table
CREATE TABLE LOOKUP_GROUP (
    ID INTEGER NOT NULL AUTO_INCREMENT,
    NAME VARCHAR(255) NOT NULL,
    DESCRIPTION TEXT,
    VERSION VARCHAR(50),
    CACHE_SIZE INTEGER DEFAULT 1000,
    CACHE_POLICY VARCHAR(50) DEFAULT 'LRU',
    CREATED_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UPDATED_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (ID)
) ENGINE=InnoDB;

CREATE UNIQUE INDEX IDX_LOOKUP_GROUP_NAME ON LOOKUP_GROUP (NAME);

-- Create LOOKUP_AUDIT table
CREATE TABLE LOOKUP_AUDIT (
    ID BIGINT NOT NULL AUTO_INCREMENT,
    GROUP_ID INTEGER NOT NULL,
    TABLE_NAME VARCHAR(255) NOT NULL,
    KEY_VALUE VARCHAR(255) NOT NULL,
    ACTION VARCHAR(50) NOT NULL,
    OLD_VALUE TEXT,
    NEW_VALUE TEXT,
    USER_ID VARCHAR(255),
    AUDIT_TIMESTAMP TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID),
    FOREIGN KEY (GROUP_ID) REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE INDEX IDX_LOOKUP_AUDIT_GROUP ON LOOKUP_AUDIT (GROUP_ID);
CREATE INDEX IDX_LOOKUP_AUDIT_KEY ON LOOKUP_AUDIT (TABLE_NAME, KEY_VALUE);

-- Optional statistics table
CREATE TABLE LOOKUP_STATISTICS (
    GROUP_ID INTEGER NOT NULL,
    TOTAL_LOOKUPS BIGINT DEFAULT 0,
    CACHE_HITS BIGINT DEFAULT 0,
    LAST_ACCESSED TIMESTAMP NULL,
    RESET_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (GROUP_ID),
    FOREIGN KEY (GROUP_ID) REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
) ENGINE=InnoDB;