/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.xml.util;

import de.odysseus.staxon.event.SimpleXMLEventFactory;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;

class PrettyXMLWhitespaceHandler {
    static final XMLEventFactory EVENT_FACTORY = new SimpleXMLEventFactory();
    private static final int MAX_DEPTH = 64;
    private final Characters newline;
    private final Characters[] indent;
    private final WhitespaceWriter writer;
    private int depth = 0;
    private boolean text = false;
    private boolean leaf = false;

    PrettyXMLWhitespaceHandler(final XMLStreamWriter writer, String indentation, String newline) {
        this(indentation, newline, new WhitespaceWriter(){

            @Override
            public void add(Characters event) throws XMLStreamException {
                writer.writeCharacters(event.getData());
            }
        });
    }

    PrettyXMLWhitespaceHandler(final XMLEventWriter writer, String indentation, String newline) {
        this(indentation, newline, new WhitespaceWriter(){

            @Override
            public void add(Characters event) throws XMLStreamException {
                writer.add(event);
            }
        });
    }

    private PrettyXMLWhitespaceHandler(String indentation, String newline, WhitespaceWriter writer) {
        this.newline = EVENT_FACTORY.createSpace(newline);
        this.indent = new Characters[64];
        this.writer = writer;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.indent.length; ++i) {
            this.indent[i] = EVENT_FACTORY.createSpace(builder.toString());
            builder.append(indentation);
        }
    }

    private void preStructure() throws XMLStreamException {
        if (this.text) {
            this.text = false;
        } else if (this.depth > 0) {
            this.writer.add(this.newline);
            this.writer.add(this.indent[this.depth]);
        }
    }

    private void postComment_PI() throws XMLStreamException {
        this.leaf = false;
        if (this.depth == 0) {
            this.writer.add(this.newline);
        }
    }

    void preStartDocument() throws XMLStreamException {
        this.preStructure();
    }

    void postStartDocument() throws XMLStreamException {
        this.postComment_PI();
    }

    void preComment() throws XMLStreamException {
        this.preStructure();
    }

    void postComment() throws XMLStreamException {
        this.postComment_PI();
    }

    void preProcessingInstruction() throws XMLStreamException {
        this.preStructure();
    }

    void postProcessingInstruction() throws XMLStreamException {
        this.postComment_PI();
    }

    void preStartElement() throws XMLStreamException {
        this.preStructure();
    }

    void postStartElement() throws XMLStreamException {
        ++this.depth;
        this.leaf = true;
    }

    void preEndElement() throws XMLStreamException {
        --this.depth;
        if (this.text) {
            this.text = false;
        } else if (!this.leaf) {
            this.writer.add(this.newline);
            if (this.depth > 0) {
                this.writer.add(this.indent[this.depth]);
            }
        }
    }

    void postEndElement() throws XMLStreamException {
        this.leaf = false;
        if (this.depth == 0) {
            this.writer.add(this.newline);
        }
    }

    void preEmptyELement() throws XMLStreamException {
        this.preStructure();
    }

    void postEmptyELement() throws XMLStreamException {
        this.leaf = false;
    }

    void preCharacters() {
        this.text = true;
    }

    void postCharacters() {
    }

    private static abstract class WhitespaceWriter {
        private WhitespaceWriter() {
        }

        abstract void add(Characters var1) throws XMLStreamException;
    }
}

