/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.smtp;

import com.mirth.connect.connectors.smtp.Attachment;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class SmtpDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private DestinationConnectorProperties destinationConnectorProperties;
    private String smtpHost;
    private String smtpPort;
    private boolean overrideLocalBinding;
    private String localAddress;
    private String localPort;
    private String timeout;
    private String encryption;
    private boolean authentication;
    private String username;
    private String password;
    private String to;
    private String from;
    private String cc;
    private String bcc;
    private String replyTo;
    private Map<String, String> headers;
    private String headersVariable;
    private boolean isUseHeadersVariable;
    private String subject;
    private String charsetEncoding;
    private boolean html;
    private String body;
    private List<Attachment> attachments;
    private String attachmentsVariable;
    private boolean isUseAttachmentsVariable;

    public SmtpDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties();
        this.smtpHost = "";
        this.smtpPort = "25";
        this.overrideLocalBinding = false;
        this.localAddress = "0.0.0.0";
        this.localPort = "0";
        this.timeout = "5000";
        this.encryption = "none";
        this.authentication = false;
        this.username = "";
        this.password = "";
        this.to = "";
        this.from = "";
        this.cc = "";
        this.bcc = "";
        this.replyTo = "";
        this.headers = new LinkedHashMap<String, String>();
        this.isUseHeadersVariable = false;
        this.headersVariable = "";
        this.subject = "";
        this.charsetEncoding = "DEFAULT_ENCODING";
        this.html = false;
        this.body = "";
        this.attachments = new ArrayList<Attachment>();
        this.isUseAttachmentsVariable = false;
        this.attachmentsVariable = "";
    }

    public SmtpDispatcherProperties(SmtpDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.smtpHost = props.getSmtpHost();
        this.smtpPort = props.getSmtpPort();
        this.overrideLocalBinding = props.isOverrideLocalBinding();
        this.localAddress = props.getLocalAddress();
        this.localPort = props.getLocalPort();
        this.timeout = props.getTimeout();
        this.encryption = props.getEncryption();
        this.authentication = props.isAuthentication();
        this.username = props.getUsername();
        this.password = props.getPassword();
        this.to = props.getTo();
        this.from = props.getFrom();
        this.cc = props.getCc();
        this.bcc = props.getBcc();
        this.replyTo = props.getReplyTo();
        this.headers = new LinkedHashMap<String, String>(props.getHeadersMap());
        this.isUseHeadersVariable = props.isUseHeadersVariable();
        this.headersVariable = props.getHeadersVariable();
        this.subject = props.getSubject();
        this.charsetEncoding = props.getCharsetEncoding();
        this.html = props.isHtml();
        this.body = props.getBody();
        this.attachments = new ArrayList<Attachment>();
        for (Attachment attachment : props.getAttachmentsList()) {
            this.attachments.add(new Attachment(attachment));
        }
        this.isUseAttachmentsVariable = props.isUseAttachmentsVariable();
        this.attachmentsVariable = props.getAttachmentsVariable();
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public boolean isOverrideLocalBinding() {
        return this.overrideLocalBinding;
    }

    public void setOverrideLocalBinding(boolean overrideLocalBinding) {
        this.overrideLocalBinding = overrideLocalBinding;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(String localPort) {
        this.localPort = localPort;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    public boolean isAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(boolean authentication) {
        this.authentication = authentication;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public Map<String, String> getHeadersMap() {
        return this.headers;
    }

    public void setHeadersMap(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean isUseHeadersVariable() {
        return this.isUseHeadersVariable;
    }

    public void setUseHeadersVariable(boolean isUseHeadersVariable) {
        this.isUseHeadersVariable = isUseHeadersVariable;
    }

    public String getHeadersVariable() {
        return this.headersVariable;
    }

    public void setHeadersVariable(String variableName) {
        this.headersVariable = variableName;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = charsetEncoding;
    }

    public boolean isHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<Attachment> getAttachmentsList() {
        return this.attachments;
    }

    public void setAttachmentsList(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public String getAttachmentsVariable() {
        return this.attachmentsVariable;
    }

    public void setAttachmentsVariable(String attachmentsVariable) {
        this.attachmentsVariable = attachmentsVariable;
    }

    public boolean isUseAttachmentsVariable() {
        return this.isUseAttachmentsVariable;
    }

    public void setUseAttachmentsVariable(boolean isUseAttachmentsVariable) {
        this.isUseAttachmentsVariable = isUseAttachmentsVariable;
    }

    public String getProtocol() {
        return "SMTP";
    }

    public String getName() {
        return "SMTP Sender";
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("HOST: ");
        builder.append(this.smtpHost + ":" + this.smtpPort);
        builder.append(newLine);
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            builder.append("USERNAME: ");
            builder.append(this.username);
            builder.append(newLine);
        }
        builder.append("TO: ");
        builder.append(this.to);
        builder.append(newLine);
        builder.append("FROM: ");
        builder.append(this.from);
        builder.append(newLine);
        builder.append("CC: ");
        builder.append(this.cc);
        builder.append(newLine);
        builder.append("SUBJECT: ");
        builder.append(this.subject);
        builder.append(newLine);
        builder.append(newLine);
        builder.append("[HEADERS]");
        if (this.isUseHeadersVariable()) {
            builder.append(newLine);
            builder.append("Using variable '" + this.getHeadersVariable() + "'");
        } else {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                builder.append(newLine);
                builder.append(header.getKey() + ": " + header.getValue());
            }
        }
        builder.append(newLine);
        builder.append(newLine);
        builder.append("[ATTACHMENTS]");
        if (this.isUseAttachmentsVariable()) {
            builder.append(newLine);
            builder.append("Using variable '" + this.getAttachmentsVariable() + "'");
        } else {
            for (Attachment attachment : this.attachments) {
                builder.append(newLine);
                builder.append(attachment.getName());
                builder.append(" (");
                builder.append(attachment.getMimeType());
                builder.append(")");
            }
        }
        builder.append(newLine);
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.body);
        return builder.toString();
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public ConnectorProperties clone() {
        return new SmtpDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return false;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
    }

    public void migrate3_2_0(DonkeyElement element) {
        element.addChildElementIfNotExists("overrideLocalBinding", "false");
        element.addChildElementIfNotExists("localAddress", "0.0.0.0");
        element.addChildElementIfNotExists("localPort", "0");
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("overrideLocalBinding", this.overrideLocalBinding);
        purgedProperties.put("timeout", PurgeUtil.getNumericValue((String)this.timeout));
        purgedProperties.put("encryption", this.encryption);
        purgedProperties.put("authentication", this.authentication);
        purgedProperties.put("headerChars", this.headers.size());
        purgedProperties.put("charsetEncoding", this.charsetEncoding);
        purgedProperties.put("html", this.html);
        purgedProperties.put("bodyLines", PurgeUtil.countLines((String)this.body));
        purgedProperties.put("attachmentCount", this.attachments.size());
        return purgedProperties;
    }
}

