/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.commons.encryption;

import com.mirth.commons.encryption.EncryptionException;
import com.mirth.commons.encryption.Encryptor;
import com.mirth.commons.encryption.Output;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class KeyEncryptor
extends Encryptor {
    public static final String ALGORITHM_PARAM = "alg=";
    public static final String CHARSET_PARAM = "cs=";
    public static final String IV_PARAM = "iv=";
    public static final String HEADER_INDICATOR = "{alg=";
    private Key key;
    private String algorithm;
    private String charset = "UTF-8";
    private String fallbackAlgorithm;
    private String fallbackCharset = "UTF-8";
    private ObjectPool<SecureRandom> randomPool;
    private KeyedObjectPool<String, Cipher> cipherPool;

    public KeyEncryptor() {
        GenericObjectPoolConfig randomConfig = new GenericObjectPoolConfig();
        randomConfig.setMaxTotal(-1);
        randomConfig.setBlockWhenExhausted(false);
        this.randomPool = new GenericObjectPool((PooledObjectFactory)new SecureRandomFactory(), randomConfig);
        GenericKeyedObjectPoolConfig cipherConfig = new GenericKeyedObjectPoolConfig();
        cipherConfig.setMaxTotal(-1);
        cipherConfig.setMaxTotalPerKey(-1);
        cipherConfig.setBlockWhenExhausted(false);
        this.cipherPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new CipherFactory(), cipherConfig);
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public String getAlgorithm() {
        if (StringUtils.isBlank((CharSequence)this.algorithm) && this.key != null) {
            return this.key.getAlgorithm();
        }
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        if (StringUtils.isNotBlank((CharSequence)charset)) {
            this.charset = charset;
        }
    }

    public String getFallbackAlgorithm() {
        return this.fallbackAlgorithm;
    }

    public void setFallbackAlgorithm(String fallbackAlgorithm) {
        this.fallbackAlgorithm = fallbackAlgorithm;
    }

    public String getFallbackCharset() {
        return this.fallbackCharset;
    }

    public void setFallbackCharset(String fallbackCharset) {
        if (StringUtils.isNotBlank((CharSequence)fallbackCharset)) {
            this.fallbackCharset = fallbackCharset;
        }
    }

    @Override
    public synchronized void initialize() throws EncryptionException {
        if (!this.isInitialized()) {
            this.setInitialized(true);
        }
    }

    @Override
    public String encrypt(String message) throws EncryptionException {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            EncryptionResult result = this.doEncrypt(message.getBytes(this.getCharset()), true);
            StringBuilder builder = this.buildHeader(result.iv);
            builder.append((String)result.ciphertext);
            return builder.toString();
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public Encryptor.EncryptedData encrypt(byte[] data) throws EncryptionException {
        if (data == null) {
            return new Encryptor.EncryptedData(null, null);
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            EncryptionResult result = this.doEncrypt(data, false);
            String header = this.buildHeader(result.iv).toString();
            return new Encryptor.EncryptedData(header, (byte[])result.ciphertext);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncryptionResult doEncrypt(byte[] message, boolean formatCipherText) throws Exception {
        EncryptionResult encryptionResult;
        SecureRandom borrowedRandom;
        block7: {
            String algorithm = this.getAlgorithm();
            Cipher borrowedCipher = null;
            borrowedRandom = null;
            try {
                SecureRandom random;
                Cipher cipher = borrowedCipher = this.borrowCipher(algorithm);
                if (cipher == null) {
                    cipher = this.createCipher(algorithm);
                }
                if ((random = (borrowedRandom = this.borrowRandom())) == null) {
                    random = this.createRandom();
                }
                byte[] iv = new byte[cipher.getBlockSize()];
                random.nextBytes(iv);
                AlgorithmParameterSpec parameterSpec = StringUtils.contains((CharSequence)algorithm, (CharSequence)"GCM") ? new GCMParameterSpec(128, iv) : new IvParameterSpec(iv);
                cipher.init(1, this.key, parameterSpec);
                byte[] encrypted = cipher.doFinal(message);
                encryptionResult = new EncryptionResult(iv, encrypted, formatCipherText);
                if (borrowedCipher == null) break block7;
            }
            catch (Throwable throwable) {
                if (borrowedCipher != null) {
                    this.cipherPool.returnObject((Object)algorithm, (Object)borrowedCipher);
                }
                if (borrowedRandom != null) {
                    this.randomPool.returnObject(borrowedRandom);
                }
                throw throwable;
            }
            this.cipherPool.returnObject((Object)algorithm, (Object)borrowedCipher);
        }
        if (borrowedRandom != null) {
            this.randomPool.returnObject((Object)borrowedRandom);
        }
        return encryptionResult;
    }

    @Override
    public String decrypt(String message) throws EncryptionException {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            HeaderExtractionResult result = this.extractHeader(message);
            if (result.iv != null) {
                return new String(this.doDecrypt(this.unformat(StringUtils.substring((String)message, (int)result.startIndex)), result.algorithm, result.iv), result.charset);
            }
            return new String(this.doDecrypt(this.unformat(message), result.algorithm, null), result.charset);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] decrypt(String header, byte[] data) throws EncryptionException {
        if (data == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            HeaderExtractionResult result = this.extractHeader(header);
            return this.doDecrypt(data, result.algorithm, result.iv);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doDecrypt(byte[] message, String algorithm, byte[] iv) throws Exception {
        Cipher borrowedCipher = null;
        try {
            Cipher cipher = borrowedCipher = this.borrowCipher(algorithm);
            if (cipher == null) {
                cipher = this.createCipher(algorithm);
            }
            if (iv == null) {
                iv = new byte[cipher.getBlockSize()];
            }
            AlgorithmParameterSpec parameterSpec = StringUtils.contains((CharSequence)algorithm, (CharSequence)"GCM") ? new GCMParameterSpec(128, iv) : new IvParameterSpec(iv);
            cipher.init(2, this.key, parameterSpec);
            byte[] byArray = cipher.doFinal(message);
            return byArray;
        }
        finally {
            if (borrowedCipher != null) {
                this.cipherPool.returnObject((Object)algorithm, (Object)borrowedCipher);
            }
        }
    }

    private StringBuilder buildHeader(String iv) {
        StringBuilder builder = new StringBuilder("{");
        builder.append(ALGORITHM_PARAM).append(this.getAlgorithm()).append(',');
        builder.append(CHARSET_PARAM).append(this.getCharset()).append(',');
        builder.append(IV_PARAM).append(iv).append('}');
        return builder;
    }

    private HeaderExtractionResult extractHeader(String message) throws Exception {
        String algorithm = StringUtils.defaultString((String)this.getFallbackAlgorithm(), (String)this.getAlgorithm());
        String charset = StringUtils.defaultString((String)this.getFallbackCharset(), (String)this.getCharset());
        byte[] iv = null;
        int startIndex = 0;
        if (message != null && message.length() > 0 && message.charAt(0) == '{') {
            startIndex = 1;
            int endIndex = StringUtils.indexOf((CharSequence)message, (CharSequence)ALGORITHM_PARAM, (int)1);
            boolean found = false;
            if (startIndex == endIndex && (endIndex = StringUtils.indexOf((CharSequence)message, (int)44, (int)(startIndex += ALGORITHM_PARAM.length()))) != -1) {
                algorithm = message.substring(startIndex, endIndex);
                found = true;
                startIndex = endIndex + 1;
            }
            if (found) {
                found = false;
                endIndex = StringUtils.indexOf((CharSequence)message, (CharSequence)CHARSET_PARAM, (int)startIndex);
                if (startIndex == endIndex && (endIndex = StringUtils.indexOf((CharSequence)message, (int)44, (int)(startIndex += CHARSET_PARAM.length()))) != -1) {
                    charset = message.substring(startIndex, endIndex);
                    found = true;
                    startIndex = endIndex + 1;
                }
            }
            if (found) {
                found = false;
                endIndex = StringUtils.indexOf((CharSequence)message, (CharSequence)IV_PARAM, (int)startIndex);
                if (startIndex == endIndex && (endIndex = StringUtils.indexOf((CharSequence)message, (int)125, (int)(startIndex += IV_PARAM.length()))) != -1) {
                    iv = this.unformat(message.substring(startIndex, endIndex));
                    found = true;
                    startIndex = endIndex + 1;
                }
            }
            if (!found) {
                throw new Exception("Encryption header information is malformed.");
            }
        }
        return new HeaderExtractionResult(startIndex, algorithm, charset, iv);
    }

    private String format(byte[] data, boolean chunked) throws UnsupportedEncodingException {
        if (this.getFormat() == Output.HEXADECIMAL) {
            return Hex.encodeHexString((byte[])data);
        }
        if (chunked) {
            return new String(Base64.encodeBase64Chunked((byte[])data), this.getCharset());
        }
        return Base64.encodeBase64String((byte[])data);
    }

    private byte[] unformat(String data) throws UnsupportedEncodingException, DecoderException {
        if (this.getFormat() == Output.HEXADECIMAL) {
            return Hex.decodeHex((char[])data.toCharArray());
        }
        return Base64.decodeBase64((String)data);
    }

    private SecureRandom createRandom() {
        return new SecureRandom();
    }

    private SecureRandom borrowRandom() {
        try {
            return (SecureRandom)this.randomPool.borrowObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Cipher createCipher(String algorithm) throws Exception {
        return Cipher.getInstance(algorithm, this.getProvider());
    }

    private Cipher borrowCipher(String algorithm) {
        try {
            return (Cipher)this.cipherPool.borrowObject((Object)algorithm);
        }
        catch (Exception e) {
            return null;
        }
    }

    private class SecureRandomFactory
    extends BasePooledObjectFactory<SecureRandom> {
        private SecureRandomFactory() {
        }

        public SecureRandom create() throws Exception {
            return KeyEncryptor.this.createRandom();
        }

        public PooledObject<SecureRandom> wrap(SecureRandom random) {
            return new DefaultPooledObject((Object)random);
        }
    }

    private class CipherFactory
    extends BaseKeyedPooledObjectFactory<String, Cipher> {
        private CipherFactory() {
        }

        public Cipher create(String algorithm) throws Exception {
            return KeyEncryptor.this.createCipher(algorithm);
        }

        public PooledObject<Cipher> wrap(Cipher random) {
            return new DefaultPooledObject((Object)random);
        }
    }

    private class EncryptionResult {
        private String iv;
        private Object ciphertext;

        public EncryptionResult(byte[] iv, byte[] ciphertext, boolean formatCipherText) throws UnsupportedEncodingException {
            this.iv = KeyEncryptor.this.format(iv, false);
            this.ciphertext = formatCipherText ? (Object)KeyEncryptor.this.format(ciphertext, true) : ciphertext;
        }
    }

    private class HeaderExtractionResult {
        private int startIndex;
        private String algorithm;
        private String charset;
        private byte[] iv;

        public HeaderExtractionResult(int startIndex, String algorithm, String charset, byte[] iv) {
            this.startIndex = startIndex;
            this.algorithm = algorithm;
            this.charset = charset;
            this.iv = iv;
        }
    }
}

