/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.commons.encryption.util;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.commons.encryption.KeyEncryptor;
import com.mirth.commons.encryption.Output;
import com.mirth.commons.encryption.PBEEncryptor;
import java.security.Provider;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptionUtil {
    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withArgName((String)"encrypt");
        OptionBuilder.withDescription((String)"encrypt the string");
        Option encryptOption = OptionBuilder.create((String)"e");
        OptionBuilder.withArgName((String)"decrypt");
        OptionBuilder.withDescription((String)"decrypt the string");
        Option decryptOption = OptionBuilder.create((String)"d");
        OptionBuilder.withArgName((String)"algorithm");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the algorithm to use");
        Option algorithmOption = OptionBuilder.create((String)"a");
        OptionBuilder.withArgName((String)"format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the format to use");
        Option formatOption = OptionBuilder.create((String)"f");
        OptionBuilder.withArgName((String)"text");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the text to hash");
        Option textOption = OptionBuilder.create((String)"t");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the password to use (PBE)");
        Option passwordOption = OptionBuilder.create((String)"p");
        Option helpOption = new Option("h", "print this message");
        options.addOption(encryptOption);
        options.addOption(decryptOption);
        options.addOption(algorithmOption);
        options.addOption(formatOption);
        options.addOption(textOption);
        options.addOption(passwordOption);
        options.addOption(helpOption);
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(options, args);
            PBEEncryptor encryptor = null;
            if (line.hasOption("t")) {
                encryptor = new PBEEncryptor();
                encryptor.setProvider((Provider)new BouncyCastleProvider());
                if (line.hasOption("p")) {
                    encryptor.setPassword(line.getOptionValue("p"));
                } else {
                    System.err.println("Password not specified.");
                }
                encryptor.setIncludeSalt(true);
                encryptor.setIterations(5000);
                encryptor.setSaltSizeBytes(8);
                if (line.hasOption("a")) {
                    encryptor.setAlgorithm(line.getOptionValue("a"));
                } else {
                    encryptor.setAlgorithm("PBEWithMD5AndDES");
                }
                if (line.hasOption("s")) {
                    encryptor.setIncludeSalt(true);
                }
                if (line.hasOption("S")) {
                    encryptor.setSaltSizeBytes(Integer.parseInt(line.getOptionValue("S")));
                }
                if (line.hasOption("f")) {
                    if (line.getOptionValue("f").equalsIgnoreCase("base64")) {
                        encryptor.setFormat(Output.BASE64);
                    } else if (line.getOptionValue("f").equalsIgnoreCase("hex")) {
                        encryptor.setFormat(Output.HEXADECIMAL);
                    }
                }
                if (line.hasOption("d")) {
                    System.out.println(encryptor.decrypt(line.getOptionValue("t")));
                } else if (line.hasOption("e")) {
                    System.out.println(encryptor.encrypt(line.getOptionValue("t")));
                } else {
                    System.err.println("Mode not specified.");
                }
            } else if (line.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("EncryptionUtil", options);
            } else {
                System.err.println("No input text specified.");
            }
        }
        catch (ParseException e) {
            System.err.println("Parsing failed. " + e.getMessage());
        }
    }

    public static String decryptAndReencrypt(String message, KeyEncryptor encryptor, String oldAlgorithm) throws Exception {
        return (String)EncryptionUtil.doDecryptAndReencrypt(null, (Object)message, encryptor, oldAlgorithm);
    }

    public static String decryptAndReencrypt(String message, Encryptor decryptor, Encryptor encryptor) throws Exception {
        return (String)EncryptionUtil.doDecryptAndReencrypt(null, (Object)message, decryptor, encryptor);
    }

    public static Encryptor.EncryptedData decryptAndReencrypt(String header, byte[] message, KeyEncryptor encryptor, String oldAlgorithm) throws Exception {
        return (Encryptor.EncryptedData)EncryptionUtil.doDecryptAndReencrypt(header, (Object)message, encryptor, oldAlgorithm);
    }

    public static Encryptor.EncryptedData decryptAndReencrypt(String header, byte[] message, Encryptor decryptor, Encryptor encryptor) throws Exception {
        return (Encryptor.EncryptedData)EncryptionUtil.doDecryptAndReencrypt(header, (Object)message, decryptor, encryptor);
    }

    private static Object doDecryptAndReencrypt(String header, Object message, KeyEncryptor encryptor, String oldAlgorithm) throws Exception {
        KeyEncryptor decryptor = new KeyEncryptor();
        decryptor.setProvider(encryptor.getProvider());
        decryptor.setFormat(encryptor.getFormat());
        decryptor.setKey(encryptor.getKey());
        decryptor.setAlgorithm(oldAlgorithm);
        decryptor.setCharset(encryptor.getCharset());
        return EncryptionUtil.doDecryptAndReencrypt(header, message, (Encryptor)decryptor, encryptor);
    }

    private static Object doDecryptAndReencrypt(String header, Object message, Encryptor decryptor, Encryptor encryptor) throws Exception {
        if (message instanceof String) {
            return encryptor.encrypt(decryptor.decrypt((String)message));
        }
        return encryptor.encrypt(decryptor.decrypt(header, (byte[])message));
    }
}

