/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.shared.model;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TimeRangePresets {
    public static final List<String> PRESETS = Collections.unmodifiableList(Arrays.asList("last_1h", "last_3h", "last_6h", "last_12h", "last_24h", "last_2d", "last_7d", "last_14d", "last_30d", "last_60d", "last_90d", "last_180d", "last_365d", "last_730d", "last_1095d"));
    public static final Map<String, Duration> PRESET_TO_DURATION;
    public static final Map<String, String> PRESET_TO_LABEL;

    private TimeRangePresets() {
    }

    public static Map<Integer, Duration> getDefaultRetention() {
        LinkedHashMap<Integer, Duration> linkedHashMap = new LinkedHashMap<Integer, Duration>();
        linkedHashMap.put(1, Duration.ofDays(1L));
        linkedHashMap.put(5, Duration.ofDays(7L));
        linkedHashMap.put(15, Duration.ofDays(30L));
        linkedHashMap.put(60, Duration.ofDays(90L));
        linkedHashMap.put(1440, Duration.ofDays(1095L));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public static Duration toDuration(String string) {
        return PRESET_TO_DURATION.get(string);
    }

    static {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("last_1h", Duration.ofHours(1L));
        hashMap.put("last_3h", Duration.ofHours(3L));
        hashMap.put("last_6h", Duration.ofHours(6L));
        hashMap.put("last_12h", Duration.ofHours(12L));
        hashMap.put("last_24h", Duration.ofDays(1L));
        hashMap.put("last_2d", Duration.ofDays(2L));
        hashMap.put("last_7d", Duration.ofDays(7L));
        hashMap.put("last_14d", Duration.ofDays(14L));
        hashMap.put("last_30d", Duration.ofDays(30L));
        hashMap.put("last_60d", Duration.ofDays(60L));
        hashMap.put("last_90d", Duration.ofDays(90L));
        hashMap.put("last_180d", Duration.ofDays(180L));
        hashMap.put("last_365d", Duration.ofDays(365L));
        hashMap.put("last_730d", Duration.ofDays(730L));
        hashMap.put("last_1095d", Duration.ofDays(1095L));
        PRESET_TO_DURATION = Collections.unmodifiableMap(hashMap);
        hashMap = new LinkedHashMap();
        hashMap.put("last_1h", "Last 1 Hour");
        hashMap.put("last_3h", "Last 3 Hours");
        hashMap.put("last_6h", "Last 6 Hours");
        hashMap.put("last_12h", "Last 12 Hours");
        hashMap.put("last_24h", "Last 24 Hours");
        hashMap.put("last_2d", "Last 2 Days");
        hashMap.put("last_7d", "Last 7 Days");
        hashMap.put("last_14d", "Last 14 Days");
        hashMap.put("last_30d", "Last Month");
        hashMap.put("last_60d", "Last 2 Months");
        hashMap.put("last_90d", "Last 3 Months");
        hashMap.put("last_180d", "Last 6 Months");
        hashMap.put("last_365d", "Last 1 Year");
        hashMap.put("last_730d", "Last 2 Years");
        hashMap.put("last_1095d", "Last 3 Years");
        PRESET_TO_LABEL = Collections.unmodifiableMap(hashMap);
    }
}

