/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.connectors.tcp.DefaultTcpConfiguration;
import com.mirth.connect.connectors.tcp.SocketUtil;
import com.mirth.connect.connectors.tcp.StateAwareSocketInterface;
import com.mirth.connect.connectors.tcp.TcpConfiguration;
import com.mirth.connect.connectors.tcp.TcpReceiverProperties;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ConnectorCountEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.StreamHandler;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReceiver;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.donkey.server.message.batch.BatchStreamReader;
import com.mirth.connect.donkey.server.message.batch.ResponseHandler;
import com.mirth.connect.donkey.server.message.batch.SimpleResponseHandler;
import com.mirth.connect.donkey.util.ThreadUtils;
import com.mirth.connect.model.transmission.StreamHandlerException;
import com.mirth.connect.model.transmission.batch.DefaultBatchStreamReader;
import com.mirth.connect.plugins.BasicModeProvider;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.plugins.TransmissionModeProvider;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.CharsetUtils;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.TcpUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TcpReceiver
extends SourceConnector {
    private static final int DEFAULT_BACKLOG = 256;
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    protected TcpReceiverProperties connectorProperties;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private TcpConfiguration configuration = null;
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private Socket recoveryResponseSocket;
    private Thread thread;
    private ExecutorService executor;
    private Set<Future<Throwable>> results = new HashSet<Future<Throwable>>();
    private Set<TcpReader> clientReaders = new HashSet<TcpReader>();
    private AtomicBoolean disposing;
    private int maxConnections;
    private int timeout;
    private int bufferSize;
    private int reconnectInterval;
    private TransmissionModeProvider transmissionModeProvider;
    private DataTypeServerPlugin dataTypeServerPlugin;

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (TcpReceiverProperties)this.getConnectorProperties();
        if (this.connectorProperties.isDataTypeBinary() && this.isProcessBatch()) {
            throw new ConnectorTaskException("Batch processing is not supported for binary data.");
        }
        String configurationClass = this.getConfigurationClass();
        try {
            this.configuration = (TcpConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Throwable t) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultTcpConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        this.maxConnections = NumberUtils.toInt((String)this.connectorProperties.getMaxConnections());
        this.timeout = NumberUtils.toInt((String)this.connectorProperties.getReceiveTimeout());
        this.bufferSize = NumberUtils.toInt((String)this.connectorProperties.getBufferSize());
        this.reconnectInterval = NumberUtils.toInt((String)this.connectorProperties.getReconnectInterval());
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        String pluginPointName = this.connectorProperties.getTransmissionModeProperties().getPluginPointName();
        this.transmissionModeProvider = pluginPointName.equals("Basic") ? new BasicModeProvider() : (TransmissionModeProvider)extensionController.getTransmissionModeProviders().get(pluginPointName);
        if (this.transmissionModeProvider == null) {
            throw new ConnectorTaskException("Unable to find transmission mode plugin: " + pluginPointName);
        }
        this.dataTypeServerPlugin = (DataTypeServerPlugin)extensionController.getDataTypePlugins().get(this.getInboundDataType().getType());
        if (this.dataTypeServerPlugin == null) {
            throw new ConnectorTaskException("Unable to find data type plugin: " + this.getInboundDataType().getType());
        }
        this.disposing = new AtomicBoolean(false);
        this.eventController.dispatchEvent((Event)new ConnectorCountEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE, null, Integer.valueOf(this.maxConnections)));
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
        this.disposing.set(false);
        this.results.clear();
        this.clientReaders.clear();
        this.executor = this.connectorProperties.isServerMode() ? new ThreadPoolExecutor(0, this.maxConnections, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()) : Executors.newSingleThreadExecutor();
        if (this.connectorProperties.isServerMode()) {
            try {
                this.createServerSocket();
            }
            catch (IOException e) {
                throw new ConnectorTaskException("Failed to create server socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
        }
        this.thread = new Thread("TCP Receiver Server Acceptor Thread on " + this.getChannel().getName() + " (" + this.getChannelId() + ")"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                do {
                    Socket socket = null;
                    if (TcpReceiver.this.connectorProperties.isServerMode()) {
                        try {
                            TcpReceiver.this.logger.debug("Waiting for new client socket (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").");
                            socket = TcpReceiver.this.serverSocket.accept();
                            TcpReceiver.this.logger.trace("Accepted new socket: " + socket.getRemoteSocketAddress().toString() + " -> " + String.valueOf(socket.getLocalSocketAddress()));
                        }
                        catch (InterruptedIOException e) {
                            TcpReceiver.this.logger.debug("Interruption during server socket accept operation (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").", (Throwable)e);
                        }
                        catch (Exception e) {
                            TcpReceiver.this.logger.debug("Error accepting new socket (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").", (Throwable)e);
                        }
                    } else {
                        try {
                            TcpReceiver.this.logger.debug("Initiating for new client socket (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").");
                            socket = TcpReceiver.this.connectorProperties.isOverrideLocalBinding() ? SocketUtil.createSocket(TcpReceiver.this.configuration, TcpReceiver.this.getLocalAddress(), TcpReceiver.this.getLocalPort()) : SocketUtil.createSocket(TcpReceiver.this.configuration);
                            TcpReceiver.this.clientSocket = socket;
                            SocketUtil.connectSocket(socket, TcpReceiver.this.getRemoteAddress(), TcpReceiver.this.getRemotePort(), TcpReceiver.this.timeout);
                        }
                        catch (Exception e) {
                            TcpReceiver.this.logger.error("Error initiating new socket (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").", (Throwable)e);
                            TcpReceiver.this.closeSocketQuietly(socket);
                            socket = null;
                            TcpReceiver.this.clientSocket = null;
                        }
                    }
                    try {
                        ThreadUtils.checkInterruptedStatus();
                        if (socket != null) {
                            Set<TcpReader> e = TcpReceiver.this.clientReaders;
                            synchronized (e) {
                                TcpReader reader = null;
                                try {
                                    if (TcpReceiver.this.disposing.get()) {
                                        return;
                                    }
                                    reader = new TcpReader(socket);
                                    TcpReceiver.this.clientReaders.add(reader);
                                    TcpReceiver.this.results.add(TcpReceiver.this.executor.submit(reader));
                                }
                                catch (SocketException | RejectedExecutionException e2) {
                                    if (e2 instanceof RejectedExecutionException) {
                                        TcpReceiver.this.logger.debug("Executor rejected new task (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").", (Throwable)e2);
                                    } else {
                                        TcpReceiver.this.logger.debug("Error initializing socket (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").", (Throwable)e2);
                                    }
                                    TcpReceiver.this.clientReaders.remove(reader);
                                    TcpReceiver.this.closeSocketQuietly(socket);
                                }
                            }
                        }
                        if (TcpReceiver.this.connectorProperties.isServerMode()) {
                            TcpReceiver.this.cleanup(false, false, true);
                            continue;
                        }
                        TcpReceiver.this.cleanup(true, false, true);
                        String info = "Client socket finished, waiting " + TcpReceiver.this.connectorProperties.getReconnectInterval() + " ms...";
                        TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.INFO, info));
                        1.sleep(TcpReceiver.this.reconnectInterval);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                } while (TcpReceiver.this.getCurrentState() == DeployedState.STARTED);
            }
        };
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop() throws ConnectorTaskException {
        ConnectorTaskException firstCause;
        block41: {
            firstCause = null;
            Set<TcpReader> set = this.clientReaders;
            synchronized (set) {
                this.disposing.set(true);
                if (this.executor != null) {
                    this.executor.shutdown();
                }
            }
            if (this.connectorProperties.isServerMode()) {
                if (this.serverSocket != null) {
                    try {
                        this.logger.debug("Closing server socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").");
                        this.serverSocket.close();
                    }
                    catch (IOException e) {
                        firstCause = new ConnectorTaskException("Error closing server socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
                    }
                }
            } else {
                try {
                    SocketUtil.closeSocket(this.clientSocket);
                }
                catch (IOException e) {
                    firstCause = new ConnectorTaskException("Error closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
                }
                finally {
                    this.clientSocket = null;
                }
            }
            try {
                this.disposeThread(false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConnectorTaskException("Thread join operation interrupted (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
            Set<TcpReader> e = this.clientReaders;
            synchronized (e) {
                for (TcpReader reader : this.clientReaders) {
                    try {
                        TcpReader tcpReader = reader;
                        synchronized (tcpReader) {
                            reader.setCanRead(false);
                            if (reader.isReading()) {
                                reader.getSocket().close();
                            }
                        }
                    }
                    catch (IOException e2) {
                        if (firstCause != null) continue;
                        firstCause = new ConnectorTaskException("Error closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e2);
                    }
                }
                this.clientReaders.clear();
            }
            try {
                this.cleanup(true, false, false);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new ConnectorTaskException("Client thread disposal interrupted (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e2);
            }
            e = this.clientReaders;
            synchronized (e) {
                for (TcpReader reader : this.clientReaders) {
                    block40: {
                        try {
                            reader.getSocket().close();
                        }
                        catch (IOException e3) {
                            if (firstCause != null) break block40;
                            firstCause = new ConnectorTaskException("Error closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e3);
                        }
                    }
                    try {
                        SocketUtil.closeSocket(reader.getResponseSocket());
                    }
                    catch (IOException e4) {
                        if (firstCause != null) continue;
                        firstCause = new ConnectorTaskException("Error closing response socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e4);
                    }
                }
                this.clientReaders.clear();
            }
            try {
                SocketUtil.closeSocket(this.recoveryResponseSocket);
            }
            catch (IOException e3) {
                if (firstCause != null) break block41;
                firstCause = new ConnectorTaskException("Error closing response socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e3);
            }
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHalt() throws ConnectorTaskException {
        Set<TcpReader> set;
        ConnectorTaskException firstCause;
        block35: {
            block34: {
                block32: {
                    firstCause = null;
                    set = this.clientReaders;
                    synchronized (set) {
                        this.disposing.set(true);
                        this.executor.shutdownNow();
                    }
                    if (this.connectorProperties.isServerMode()) {
                        if (this.serverSocket != null) {
                            try {
                                this.logger.debug("Closing server socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").");
                                this.serverSocket.close();
                            }
                            catch (IOException e) {
                                firstCause = new ConnectorTaskException("Error closing server socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
                            }
                        }
                    } else {
                        try {
                            SocketUtil.closeSocket(this.clientSocket);
                        }
                        catch (IOException e) {
                            firstCause = new ConnectorTaskException("Error closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
                        }
                        finally {
                            this.clientSocket = null;
                        }
                    }
                    try {
                        this.disposeThread(true);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (firstCause != null) break block32;
                        firstCause = new ConnectorTaskException("Thread join operation interrupted (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
                    }
                }
                Set<TcpReader> e = this.clientReaders;
                synchronized (e) {
                    for (TcpReader reader : this.clientReaders) {
                        block33: {
                            try {
                                reader.getSocket().close();
                            }
                            catch (IOException e2) {
                                if (firstCause != null) break block33;
                                this.logger.debug("Error closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e2);
                                firstCause = new ConnectorTaskException("Error closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e2);
                            }
                        }
                        try {
                            SocketUtil.closeSocket(reader.getResponseSocket());
                        }
                        catch (IOException e3) {
                            if (firstCause != null) continue;
                            this.logger.debug("Error closing response socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e3);
                            firstCause = new ConnectorTaskException("Error closing response socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e3);
                        }
                    }
                }
                try {
                    SocketUtil.closeSocket(this.recoveryResponseSocket);
                }
                catch (IOException e2) {
                    if (firstCause != null) break block34;
                    firstCause = new ConnectorTaskException("Error closing response socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e2);
                }
            }
            try {
                this.cleanup(false, true, false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (firstCause != null) break block35;
                firstCause = new ConnectorTaskException("Client thread disposal interrupted (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
        }
        set = this.clientReaders;
        synchronized (set) {
            this.clientReaders.clear();
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        block9: {
            try {
                if (dispatchResult.getSelectedResponse() == null) break block9;
                if (this.connectorProperties.getRespondOnNewConnection() == 1 || this.connectorProperties.getRespondOnNewConnection() == 2) {
                    DefaultBatchStreamReader batchStreamReader = new DefaultBatchStreamReader(null);
                    StreamHandler streamHandler = this.transmissionModeProvider.getStreamHandler(null, null, (BatchStreamReader)batchStreamReader, this.connectorProperties.getTransmissionModeProperties());
                    try {
                        dispatchResult.setAttemptedResponse(true);
                        this.recoveryResponseSocket = this.createResponseSocket();
                        this.connectResponseSocket(this.recoveryResponseSocket, streamHandler);
                        this.sendResponse(dispatchResult.getSelectedResponse().getMessage(), this.recoveryResponseSocket, streamHandler, true);
                        break block9;
                    }
                    catch (IOException e) {
                        dispatchResult.setResponseError(ErrorMessageBuilder.buildErrorMessage((String)this.connectorProperties.getName(), (String)"Error sending response.", (Throwable)e));
                        break block9;
                    }
                    finally {
                        this.closeSocketQuietly(this.recoveryResponseSocket);
                        this.recoveryResponseSocket = null;
                    }
                }
                dispatchResult.setResponseError("Cannot respond on original connection during message recovery. In order to send a response, enable \"Respond on New Connection\" in Tcp Listener settings.");
            }
            finally {
                this.finishDispatch(dispatchResult);
            }
        }
    }

    protected String getConfigurationClass() {
        return this.configurationController.getProperty(this.connectorProperties.getProtocol(), "tcpConfigurationClass");
    }

    private void createServerSocket() throws IOException {
        int backlog = 256;
        String host = this.getLocalAddress();
        int port = this.getLocalPort();
        InetAddress hostAddress = InetAddress.getByName(host);
        int bindAttempts = 0;
        boolean success = false;
        while (!success) {
            try {
                ++bindAttempts;
                this.serverSocket = this.configuration.createServerSocket(port, backlog, hostAddress);
                success = true;
            }
            catch (BindException e) {
                if (bindAttempts >= 10) {
                    throw e;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private Socket createResponseSocket() throws IOException {
        this.logger.debug("Creating response socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").");
        return SocketUtil.createResponseSocket(this.configuration);
    }

    private void connectResponseSocket(Socket responseSocket, StreamHandler streamHandler) throws IOException {
        String channelId = this.getChannelId();
        String channelName = this.getChannel().getName();
        int responsePort = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getResponsePort(), channelId, channelName));
        SocketUtil.connectSocket(responseSocket, this.replacer.replaceValues(this.connectorProperties.getResponseAddress(), channelId, channelName), responsePort, this.timeout);
        this.initSocket(responseSocket);
        BufferedOutputStream bos = new BufferedOutputStream(responseSocket.getOutputStream(), this.bufferSize);
        streamHandler.setOutputStream((OutputStream)bos);
    }

    private void sendResponse(String response, Socket responseSocket, StreamHandler streamHandler, boolean newConnection) throws IOException {
        try {
            if (responseSocket == null || streamHandler == null) {
                throw new IOException((responseSocket == null ? "Response socket" : "Stream handler") + " is null.");
            }
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.INFO, "Sending response to " + (newConnection ? SocketUtil.getInetAddress(responseSocket) : SocketUtil.getLocalAddress(responseSocket)) + "... "));
            streamHandler.write(this.getBytes(response));
        }
        catch (IOException e) {
            if (responseSocket != null && responseSocket instanceof StateAwareSocketInterface && ((StateAwareSocketInterface)((Object)responseSocket)).remoteSideHasClosed()) {
                e = new IOException("Remote socket has closed.");
            }
            this.logger.error("Error sending response (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.FAILURE, "Error sending response to " + (newConnection ? SocketUtil.getInetAddress(responseSocket) : SocketUtil.getLocalAddress(responseSocket)) + ": " + e.getMessage() + " "));
            throw e;
        }
    }

    private boolean checkSocket(Socket socket) throws IOException {
        return !this.connectorProperties.isKeepConnectionOpen() || socket.isClosed() || socket instanceof StateAwareSocketInterface && ((StateAwareSocketInterface)((Object)socket)).remoteSideHasClosed();
    }

    private void closeSocketQuietly(Socket socket) {
        try {
            if (socket != null) {
                this.logger.trace("Closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").");
                SocketUtil.closeSocket(socket);
            }
        }
        catch (IOException e) {
            this.logger.debug("Error closing client socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", (Throwable)e);
        }
    }

    private void disposeThread(boolean interrupt) throws InterruptedException {
        if (this.thread != null && this.thread.isAlive()) {
            if (interrupt) {
                this.logger.trace("Interrupting thread (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").");
                this.thread.interrupt();
            }
            this.logger.trace("Joining thread (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").");
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
    }

    private void cleanup(boolean block, boolean interrupt, boolean remove) throws InterruptedException {
        Iterator<Future<Throwable>> it = this.results.iterator();
        while (it.hasNext()) {
            Future<Throwable> result;
            block6: {
                result = it.next();
                if (interrupt) {
                    result.cancel(true);
                }
                if (block) {
                    Throwable t = null;
                    try {
                        t = result.get();
                        if (t != null) {
                            this.logger.debug("Client socket thread returned unsuccessfully (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").", t);
                        }
                    }
                    catch (Exception e) {
                        this.logger.debug("Error retrieving client socket thread result for " + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ".", (Throwable)e);
                        Throwable cause = t instanceof ExecutionException ? t.getCause() : t;
                        if (!(cause instanceof InterruptedException)) break block6;
                        Thread.currentThread().interrupt();
                        if (interrupt) break block6;
                        throw (InterruptedException)cause;
                    }
                }
            }
            if (!remove || !result.isDone()) continue;
            it.remove();
        }
    }

    private String getLocalAddress() {
        return TcpUtil.getFixedHost((String)this.replacer.replaceValues(this.connectorProperties.getListenerConnectorProperties().getHost(), this.getChannelId(), this.getChannel().getName()));
    }

    private int getLocalPort() {
        return NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getListenerConnectorProperties().getPort(), this.getChannelId(), this.getChannel().getName()));
    }

    private String getRemoteAddress() {
        return TcpUtil.getFixedHost((String)this.replacer.replaceValues(this.connectorProperties.getRemoteAddress(), this.getChannelId(), this.getChannel().getName()));
    }

    private int getRemotePort() {
        return NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRemotePort(), this.getChannelId(), this.getChannel().getName()));
    }

    private void initSocket(Socket socket) throws SocketException {
        this.logger.debug("Initializing socket (" + this.connectorProperties.getName() + " \"Source\" on channel " + this.getChannelId() + ").");
        socket.setReceiveBufferSize(this.bufferSize);
        socket.setSendBufferSize(this.bufferSize);
        socket.setSoTimeout(this.timeout);
        socket.setKeepAlive(this.connectorProperties.isKeepConnectionOpen());
        socket.setReuseAddress(true);
        socket.setTcpNoDelay(true);
    }

    private byte[] getBytes(String str) throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{};
        if (str != null) {
            bytes = this.connectorProperties.isDataTypeBinary() ? Base64.decodeBase64((String)str) : str.getBytes(CharsetUtils.getEncoding((String)this.connectorProperties.getCharsetEncoding()));
        }
        return bytes;
    }

    protected class TcpReader
    implements Callable<Throwable>,
    BatchMessageReceiver {
        private Socket socket = null;
        private Socket responseSocket = null;
        private AtomicBoolean reading = null;
        private AtomicBoolean canRead = null;
        private StreamHandler streamHandler = null;

        public TcpReader(Socket socket) throws SocketException {
            this.socket = socket;
            TcpReceiver.this.initSocket(socket);
            this.reading = new AtomicBoolean(false);
            this.canRead = new AtomicBoolean(true);
        }

        public Socket getSocket() {
            return this.socket;
        }

        public Socket getResponseSocket() {
            return this.responseSocket;
        }

        public boolean isReading() {
            return this.reading.get();
        }

        public void setCanRead(boolean canRead) {
            this.canRead.set(canRead);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Throwable call() {
            Exception t = null;
            boolean done = false;
            TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectorCountEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.CONNECTED, SocketUtil.getLocalAddress(this.socket) + " -> " + SocketUtil.getInetAddress(this.socket), Boolean.valueOf(true)));
            String originalThreadName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName("TCP Receiver Thread on " + TcpReceiver.this.getChannel().getName() + " (" + TcpReceiver.this.getChannelId() + ") < " + originalThreadName);
                while (!done && TcpReceiver.this.getCurrentState() == DeployedState.STARTED) {
                    ThreadUtils.checkInterruptedStatus();
                    this.streamHandler = null;
                    try {
                        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                        sourceMap.put("localAddress", this.socket.getLocalAddress().getHostAddress());
                        sourceMap.put("localPort", this.socket.getLocalPort());
                        if (this.socket.getRemoteSocketAddress() instanceof InetSocketAddress) {
                            sourceMap.put("remoteAddress", ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().getHostAddress());
                            sourceMap.put("remotePort", ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getPort());
                        }
                        sourceMap.putAll(TcpReceiver.this.configuration.getSocketInformation(this.socket));
                        OutputStream outputStream = null;
                        if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() != 1) {
                            this.responseSocket = this.socket;
                            outputStream = new BufferedOutputStream(this.responseSocket.getOutputStream(), TcpReceiver.this.bufferSize);
                        } else {
                            outputStream = this.socket.getOutputStream();
                        }
                        boolean canStreamBatch = true;
                        DefaultBatchStreamReader batchStreamReader = null;
                        if (TcpReceiver.this.isProcessBatch()) {
                            batchStreamReader = TcpReceiver.this.dataTypeServerPlugin.getBatchStreamReader(this.socket.getInputStream(), TcpReceiver.this.connectorProperties.getTransmissionModeProperties());
                        }
                        if (batchStreamReader == null) {
                            canStreamBatch = false;
                            batchStreamReader = new DefaultBatchStreamReader(this.socket.getInputStream());
                        }
                        this.streamHandler = TcpReceiver.this.transmissionModeProvider.getStreamHandler(this.socket.getInputStream(), outputStream, (BatchStreamReader)batchStreamReader, TcpReceiver.this.connectorProperties.getTransmissionModeProperties());
                        if (canStreamBatch) {
                            BatchRawMessage rawMessage = new BatchRawMessage((BatchMessageSource)this, sourceMap);
                            try {
                                TcpReceiver.this.dispatchBatchMessage(rawMessage, new TcpResponseHandler(this.responseSocket, this.streamHandler));
                            }
                            catch (BatchMessageException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException) {
                                    throw (IOException)cause;
                                }
                                if (cause instanceof InterruptedException) {
                                    throw (InterruptedException)cause;
                                }
                                done = true;
                                TcpReceiver.this.logger.error("Error processing batch message", (Throwable)e);
                                TcpReceiver.this.eventController.dispatchEvent((Event)new ErrorEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, TcpReceiver.this.getSourceName(), TcpReceiver.this.connectorProperties.getName(), "Error processing batch message", (Throwable)e));
                            }
                        } else if (!done) {
                            ThreadUtils.checkInterruptedStatus();
                            byte[] bytes = null;
                            if (this.canRead()) {
                                TcpReceiver.this.logger.debug("Reading from socket input stream (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ")...");
                                try {
                                    bytes = this.readBytes();
                                }
                                finally {
                                    this.readCompleted();
                                }
                            }
                            if (bytes != null) {
                                block66: {
                                    TcpReceiver.this.logger.debug("Bytes returned from socket, length: " + bytes.length + " (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ")");
                                    TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.RECEIVING, "Message received from " + SocketUtil.getLocalAddress(this.socket) + ", processing... "));
                                    if (TcpReceiver.this.isProcessBatch()) {
                                        try {
                                            BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(this.getStringFromBytes(bytes)), sourceMap);
                                            SimpleResponseHandler responseHandler = new SimpleResponseHandler();
                                            TcpReceiver.this.dispatchBatchMessage(batchRawMessage, (ResponseHandler)responseHandler);
                                            DispatchResult dispatchResult = responseHandler.getResultForResponse();
                                            this.streamHandler.commit(true);
                                            if (dispatchResult == null || dispatchResult.getSelectedResponse() == null) break block66;
                                            try {
                                                if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1) {
                                                    this.responseSocket = TcpReceiver.this.createResponseSocket();
                                                    TcpReceiver.this.connectResponseSocket(this.responseSocket, this.streamHandler);
                                                }
                                                TcpReceiver.this.sendResponse(dispatchResult.getSelectedResponse().getMessage(), this.responseSocket, this.streamHandler, TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1);
                                            }
                                            catch (IOException iOException) {
                                            }
                                            finally {
                                                if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1 || !TcpReceiver.this.connectorProperties.isKeepConnectionOpen()) {
                                                    TcpReceiver.this.closeSocketQuietly(this.responseSocket);
                                                }
                                            }
                                        }
                                        catch (BatchMessageException e) {
                                            this.streamHandler.commit(false);
                                        }
                                    } else {
                                        RawMessage rawMessage = null;
                                        rawMessage = TcpReceiver.this.connectorProperties.isDataTypeBinary() ? new RawMessage(bytes) : new RawMessage(this.getStringFromBytes(bytes));
                                        rawMessage.setSourceMap(sourceMap);
                                        DispatchResult dispatchResult = null;
                                        ThreadUtils.checkInterruptedStatus();
                                        try {
                                            dispatchResult = TcpReceiver.this.dispatchRawMessage(rawMessage);
                                            this.streamHandler.commit(true);
                                            if (dispatchResult.getSelectedResponse() == null) break block66;
                                            dispatchResult.setAttemptedResponse(true);
                                            try {
                                                if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1) {
                                                    this.responseSocket = TcpReceiver.this.createResponseSocket();
                                                    TcpReceiver.this.connectResponseSocket(this.responseSocket, this.streamHandler);
                                                }
                                                TcpReceiver.this.sendResponse(dispatchResult.getSelectedResponse().getMessage(), this.responseSocket, this.streamHandler, TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1);
                                            }
                                            catch (IOException e) {
                                                dispatchResult.setResponseError(ErrorMessageBuilder.buildErrorMessage((String)TcpReceiver.this.connectorProperties.getName(), (String)"Error sending response.", (Throwable)e));
                                            }
                                            finally {
                                                if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1 || !TcpReceiver.this.connectorProperties.isKeepConnectionOpen()) {
                                                    TcpReceiver.this.closeSocketQuietly(this.responseSocket);
                                                }
                                            }
                                        }
                                        catch (ChannelException e) {
                                            this.streamHandler.commit(false);
                                        }
                                        finally {
                                            TcpReceiver.this.finishDispatch(dispatchResult);
                                        }
                                    }
                                }
                                TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectorCountEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.IDLE, SocketUtil.getLocalAddress(this.socket) + " -> " + SocketUtil.getInetAddress(this.socket), (Boolean)null));
                            }
                        }
                        TcpReceiver.this.logger.debug("Done with socket input stream (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").");
                        if (!TcpReceiver.this.checkSocket(this.socket)) continue;
                        done = true;
                    }
                    catch (IOException e) {
                        boolean timeout;
                        boolean bl = timeout = e instanceof SocketTimeoutException || !(e instanceof StreamHandlerException) && e.getCause() != null && e.getCause() instanceof SocketTimeoutException;
                        if (!TcpReceiver.this.connectorProperties.isKeepConnectionOpen() || !timeout) {
                            done = true;
                            if (timeout) {
                                TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.FAILURE, "Timeout waiting for message from " + SocketUtil.getLocalAddress(this.socket) + ". "));
                                continue;
                            }
                            String errorMessage = "Error receiving message (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").";
                            SocketException cause = null;
                            if (e instanceof SocketException) {
                                cause = (SocketException)e;
                            } else if (e.getCause() != null && e.getCause() instanceof SocketException) {
                                cause = (SocketException)e.getCause();
                            }
                            if (cause != null && cause.getMessage() != null && cause.getMessage().contains("Connection reset")) {
                                TcpReceiver.this.logger.warn(errorMessage, (Throwable)e);
                            } else {
                                TcpReceiver.this.logger.error(errorMessage, (Throwable)e);
                            }
                            t = new Exception(errorMessage, e);
                            TcpReceiver.this.eventController.dispatchEvent((Event)new ErrorEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, TcpReceiver.this.getSourceName(), TcpReceiver.this.connectorProperties.getName(), "Error receiving message", (Throwable)e));
                            TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.FAILURE, "Error receiving message from " + SocketUtil.getLocalAddress(this.socket) + ": " + e.getMessage()));
                            continue;
                        }
                        TcpReceiver.this.logger.debug("Timeout reading from socket input stream (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").");
                        TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.INFO, "Timeout waiting for message from " + SocketUtil.getLocalAddress(this.socket) + ". "));
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                TcpReceiver.this.logger.error("Error receiving message (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ").", (Throwable)e);
                TcpReceiver.this.eventController.dispatchEvent((Event)new ErrorEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, TcpReceiver.this.getSourceName(), TcpReceiver.this.connectorProperties.getName(), "Error receiving message", (Throwable)e));
                TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.FAILURE, "Error receiving message from " + SocketUtil.getLocalAddress(this.socket) + ": " + e.getMessage()));
            }
            finally {
                TcpReceiver.this.logger.debug("Done with socket, closing (" + TcpReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + TcpReceiver.this.getChannelId() + ")...");
                TcpReceiver.this.closeSocketQuietly(this.socket);
                if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1) {
                    TcpReceiver.this.closeSocketQuietly(this.responseSocket);
                }
                TcpReceiver.this.eventController.dispatchEvent((Event)new ConnectorCountEvent(TcpReceiver.this.getChannelId(), Integer.valueOf(TcpReceiver.this.getMetaDataId()), TcpReceiver.this.getSourceName(), ConnectionStatusEventType.DISCONNECTED, SocketUtil.getLocalAddress(this.socket) + " -> " + SocketUtil.getInetAddress(this.socket), Boolean.valueOf(false)));
                Set<TcpReader> set = TcpReceiver.this.clientReaders;
                synchronized (set) {
                    TcpReceiver.this.clientReaders.remove(this);
                }
                Thread.currentThread().setName(originalThreadName);
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canRead() {
            TcpReader tcpReader = this;
            synchronized (tcpReader) {
                if (this.canRead.get()) {
                    this.reading.set(true);
                }
            }
            return this.reading.get();
        }

        public byte[] readBytes() throws IOException {
            return this.streamHandler.read();
        }

        public void readCompleted() {
            this.reading.set(false);
        }

        public String getStringFromBytes(byte[] bytes) throws IOException {
            return new String(bytes, CharsetUtils.getEncoding((String)TcpReceiver.this.connectorProperties.getCharsetEncoding()));
        }
    }

    private class TcpResponseHandler
    extends ResponseHandler {
        private Socket responseSocket = null;
        private StreamHandler streamHandler = null;

        public TcpResponseHandler(Socket responseSocket, StreamHandler streamHandler) {
            this.responseSocket = responseSocket;
            this.streamHandler = streamHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void responseProcess(int batchSequenceId, boolean batchComplete) throws IOException {
            if (this.isUseFirstResponse() && batchSequenceId == 1 || !this.isUseFirstResponse() && batchComplete) {
                this.streamHandler.commit(true);
                if (this.dispatchResult.getSelectedResponse() != null) {
                    this.dispatchResult.setAttemptedResponse(true);
                    try {
                        if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1) {
                            this.responseSocket = TcpReceiver.this.createResponseSocket();
                            TcpReceiver.this.connectResponseSocket(this.responseSocket, this.streamHandler);
                        }
                        TcpReceiver.this.sendResponse(this.dispatchResult.getSelectedResponse().getMessage(), this.responseSocket, this.streamHandler, TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1);
                    }
                    catch (IOException e) {
                        this.dispatchResult.setResponseError(ErrorMessageBuilder.buildErrorMessage((String)TcpReceiver.this.connectorProperties.getName(), (String)"Error sending response.", (Throwable)e));
                    }
                    finally {
                        if (TcpReceiver.this.connectorProperties.getRespondOnNewConnection() == 1 || !TcpReceiver.this.connectorProperties.isKeepConnectionOpen()) {
                            TcpReceiver.this.closeSocketQuietly(this.responseSocket);
                        }
                    }
                }
            }
        }

        public void responseError(ChannelException e) {
            try {
                this.streamHandler.commit(false);
            }
            catch (Throwable t) {
                TcpReceiver.this.logger.warn("Error commiting ACK or NACK bytes", t);
            }
        }
    }
}

