/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthPropertiesTable;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.connectors.jms.JmsConnectorProperties;
import com.mirth.connect.connectors.jms.JmsConnectorServletInterface;
import com.mirth.connect.connectors.jms.JmsDispatcherProperties;
import com.mirth.connect.connectors.jms.JmsReceiverProperties;
import com.mirth.connect.connectors.jms.JmsTemplateListModel;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;

public class JmsConnectorPanel
extends ConnectorSettingsPanel {
    protected static final int TYPE_LISTENER = 1;
    protected static final int TYPE_SENDER = 2;
    private static final int PROPERTY_COLUMN_WIDTH = 135;
    private String connectorName;
    private int connectorType;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private JmsTemplateListModel listModel;
    private MirthTextField clientIdField;
    private JLabel clientIdLabel;
    private MirthTextField connectionFactoryClassField;
    private JLabel connectionFactoryClassLabel;
    private MirthTextField connectionFactoryNameField;
    private JLabel connectionFactoryNameLabel;
    private JLabel connectionPropertiesLabel;
    private JScrollPane connectionPropertiesScrollPane;
    private MirthPropertiesTable connectionPropertiesTable;
    private MirthButton deleteButton;
    private MirthButton deleteTemplateButton;
    private MirthTextField destinationNameField;
    private JLabel destinationNameLabel;
    private ButtonGroup destinationTypeButtonGroup;
    private JLabel destinationTypeLabel;
    private MirthRadioButton destinationTypeQueue;
    private MirthRadioButton destinationTypeTopic;
    private MirthCheckBox durableTopicCheckbox;
    private MirthTextField initialContextFactoryField;
    private JLabel initialContextFactoryLabel;
    private MirthButton loadTemplateButton;
    private MirthButton newButton;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private MirthTextField providerUrlField;
    private JLabel providerUrlLabel;
    private MirthButton saveTemplateButton;
    private JList templateList;
    private JScrollPane templateScrollPane;
    private ButtonGroup useJndiButtonGroup;
    private JLabel useJndiLabel;
    private MirthRadioButton useJndiNo;
    private MirthRadioButton useJndiYes;
    private MirthTextField usernameField;
    private JLabel usernameLabel;

    public JmsConnectorPanel() {
        this.initComponents();
        this.connectionPropertiesTable.setNewButton((JButton)this.newButton);
        this.connectionPropertiesTable.setDeleteButton((JButton)this.deleteButton);
        this.connectionPropertiesTable.getPropertyColumn().setMinWidth(135);
        this.connectionPropertiesTable.getPropertyColumn().setMaxWidth(135);
        this.templateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object templateName = JmsConnectorPanel.this.templateList.getSelectedValue();
                if (templateName == null) {
                    JmsConnectorPanel.this.loadTemplateButton.setEnabled(false);
                    JmsConnectorPanel.this.deleteTemplateButton.setEnabled(false);
                } else {
                    JmsConnectorPanel.this.loadTemplateButton.setEnabled(true);
                    JmsConnectorPanel.this.deleteTemplateButton.setEnabled(!JmsConnectorPanel.this.listModel.isPredefinedTemplate(templateName.toString()));
                }
            }
        });
        this.templateList.setCellRenderer(new TemplateListCellRenderer());
    }

    public synchronized void init(int connectorType, String connectorName) {
        this.connectorType = connectorType;
        this.connectorName = connectorName;
        this.listModel = JmsTemplateListModel.getInstance();
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public ConnectorProperties getDefaults() {
        return null;
    }

    public ConnectorProperties getProperties() {
        Object properties = this.connectorType == 1 ? new JmsReceiverProperties() : new JmsDispatcherProperties();
        properties.setUseJndi(this.useJndiYes.isSelected());
        properties.setJndiProviderUrl(this.providerUrlField.getText());
        properties.setJndiInitialContextFactory(this.initialContextFactoryField.getText());
        properties.setJndiConnectionFactoryName(this.connectionFactoryNameField.getText());
        properties.setConnectionFactoryClass(this.connectionFactoryClassField.getText());
        properties.setConnectionProperties(this.connectionPropertiesTable.getProperties());
        properties.setTopic(this.destinationTypeTopic.isSelected());
        if (this.connectorType == 1) {
            properties.setDurableTopic(this.durableTopicCheckbox.isSelected());
        }
        properties.setDestinationName(this.destinationNameField.getText());
        properties.setClientId(this.clientIdField.getText());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(this.passwordField.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        this.refreshTemplates();
        JmsConnectorProperties jmsConnectorProperties = (JmsConnectorProperties)properties;
        if (jmsConnectorProperties.isUseJndi()) {
            this.useJndiYes.setSelected(true);
            this.useJndiNo.setSelected(false);
            this.useJndiYesActionPerformed(null);
        } else {
            this.useJndiYes.setSelected(false);
            this.useJndiNo.setSelected(true);
            this.useJndiNoActionPerformed(null);
        }
        this.providerUrlField.setText(jmsConnectorProperties.getJndiProviderUrl());
        this.initialContextFactoryField.setText(jmsConnectorProperties.getJndiInitialContextFactory());
        this.connectionFactoryNameField.setText(jmsConnectorProperties.getJndiConnectionFactoryName());
        this.connectionFactoryClassField.setText(jmsConnectorProperties.getConnectionFactoryClass());
        this.connectionPropertiesTable.setProperties(jmsConnectorProperties.getConnectionProperties());
        if (jmsConnectorProperties.isTopic()) {
            this.destinationTypeQueue.setSelected(false);
            this.destinationTypeTopic.setSelected(true);
            this.destinationTypeTopicActionPerformed(null);
        } else {
            this.destinationTypeQueue.setSelected(true);
            this.destinationTypeTopic.setSelected(false);
            this.destinationTypeQueueActionPerformed(null);
        }
        if (this.connectorType == 1) {
            this.durableTopicCheckbox.setSelected(((JmsReceiverProperties)jmsConnectorProperties).isDurableTopic());
        } else {
            this.durableTopicCheckbox.setVisible(false);
        }
        this.destinationNameField.setText(jmsConnectorProperties.getDestinationName());
        this.clientIdField.setText(jmsConnectorProperties.getClientId());
        this.usernameField.setText(jmsConnectorProperties.getUsername());
        this.passwordField.setText(jmsConnectorProperties.getPassword());
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        boolean valid = true;
        JmsConnectorProperties jmsConnectorProperties = (JmsConnectorProperties)properties;
        if (jmsConnectorProperties.isUseJndi()) {
            if (jmsConnectorProperties.getJndiProviderUrl().length() == 0) {
                valid = false;
                if (highlight) {
                    this.providerUrlField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (jmsConnectorProperties.getJndiInitialContextFactory().length() == 0) {
                valid = false;
                if (highlight) {
                    this.initialContextFactoryField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (jmsConnectorProperties.getJndiConnectionFactoryName().length() == 0) {
                valid = false;
                if (highlight) {
                    this.connectionFactoryNameField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        } else {
            if (jmsConnectorProperties.getConnectionFactoryClass().length() == 0) {
                valid = false;
                if (highlight) {
                    this.connectionFactoryClassField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (this.connectorType == 1 && jmsConnectorProperties.isTopic() && ((JmsReceiverProperties)jmsConnectorProperties).isDurableTopic() && jmsConnectorProperties.getClientId().isEmpty()) {
                valid = false;
                if (highlight) {
                    this.clientIdField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (jmsConnectorProperties.getDestinationName().length() == 0) {
            valid = false;
            if (highlight) {
                this.destinationNameField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.providerUrlField.setBackground(null);
        this.initialContextFactoryField.setBackground(null);
        this.connectionFactoryNameField.setBackground(null);
        this.connectionFactoryClassField.setBackground(null);
        this.clientIdField.setBackground(null);
        this.destinationNameField.setBackground(null);
    }

    private void refreshTemplates() {
        LinkedHashMap result = null;
        try {
            result = ((JmsConnectorServletInterface)this.parent.mirthClient.getServlet(JmsConnectorServletInterface.class)).getTemplates();
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)this.parent, (Throwable)e);
        }
        if (result != null && result instanceof Map) {
            Map templates = result;
            for (Map.Entry templateEntry : templates.entrySet()) {
                this.listModel.putTemplate((String)templateEntry.getKey(), (JmsConnectorProperties)templateEntry.getValue());
            }
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                String templateName = this.listModel.getElementAt(i).toString();
                if (templates.containsKey(templateName) || this.listModel.isPredefinedTemplate(templateName)) continue;
                this.listModel.deleteTemplate(templateName);
            }
        }
        this.templateList.setModel(this.listModel);
    }

    private void initComponents() {
        this.useJndiButtonGroup = new ButtonGroup();
        this.destinationTypeButtonGroup = new ButtonGroup();
        this.usernameField = new MirthTextField();
        this.destinationNameField = new MirthTextField();
        this.useJndiYes = new MirthRadioButton();
        this.providerUrlField = new MirthTextField();
        this.useJndiNo = new MirthRadioButton();
        this.initialContextFactoryField = new MirthTextField();
        this.connectionFactoryNameField = new MirthTextField();
        this.durableTopicCheckbox = new MirthCheckBox();
        this.passwordLabel = new JLabel();
        this.destinationTypeLabel = new JLabel();
        this.destinationTypeQueue = new MirthRadioButton();
        this.destinationNameLabel = new JLabel();
        this.destinationTypeTopic = new MirthRadioButton();
        this.connectionFactoryClassField = new MirthTextField();
        this.usernameLabel = new JLabel();
        this.connectionFactoryClassLabel = new JLabel();
        this.connectionFactoryNameLabel = new JLabel();
        this.providerUrlLabel = new JLabel();
        this.initialContextFactoryLabel = new JLabel();
        this.useJndiLabel = new JLabel();
        this.connectionPropertiesLabel = new JLabel();
        this.connectionPropertiesScrollPane = new JScrollPane();
        this.connectionPropertiesTable = new MirthPropertiesTable();
        this.newButton = new MirthButton();
        this.deleteButton = new MirthButton();
        this.passwordField = new JPasswordField();
        this.clientIdLabel = new JLabel();
        this.clientIdField = new MirthTextField();
        this.templateScrollPane = new JScrollPane();
        this.templateList = new JList();
        this.loadTemplateButton = new MirthButton();
        this.saveTemplateButton = new MirthButton();
        this.deleteTemplateButton = new MirthButton();
        this.setBackground(new Color(255, 255, 255));
        this.usernameField.setToolTipText("The username for accessing the queue or topic.");
        this.destinationNameField.setToolTipText("The name of the queue or topic.");
        this.useJndiYes.setBackground(new Color(255, 255, 255));
        this.useJndiButtonGroup.add((AbstractButton)this.useJndiYes);
        this.useJndiYes.setText("Yes");
        this.useJndiYes.setToolTipText("<html>Select Yes to use JNDI to look up a connection factory to connect to the queue or topic.<br/>Select No to specify a connection factory class without using JNDI.</html>");
        this.useJndiYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsConnectorPanel.this.useJndiYesActionPerformed(evt);
            }
        });
        this.providerUrlField.setToolTipText("If using JNDI, enter the URL of the JNDI provider here.");
        this.useJndiNo.setBackground(new Color(255, 255, 255));
        this.useJndiButtonGroup.add((AbstractButton)this.useJndiNo);
        this.useJndiNo.setText("No");
        this.useJndiNo.setToolTipText("<html>Select Yes to use JNDI to look up a connection factory to connect to the queue or topic.<br/>Select No to specify a connection factory class without using JNDI.</html>");
        this.useJndiNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsConnectorPanel.this.useJndiNoActionPerformed(evt);
            }
        });
        this.initialContextFactoryField.setToolTipText("If using JNDI, enter the full Java classname of the JNDI Initial Context Factory class here.");
        this.connectionFactoryNameField.setToolTipText("If using JNDI, enter the JNDI name of the connection factory here.");
        this.durableTopicCheckbox.setBackground(new Color(255, 255, 255));
        this.durableTopicCheckbox.setText("Durable");
        this.durableTopicCheckbox.setToolTipText("<html>When connecting to a topic, if this box is checked, all messages published to the topic will be read,<br/>regardless of whether or not a connection to the broker is active.<br/>If not checked, only messages published while a connection is active will be read.</html>");
        this.passwordLabel.setText("Password:");
        this.destinationTypeLabel.setText("Destination Type:");
        this.destinationTypeQueue.setBackground(new Color(255, 255, 255));
        this.destinationTypeButtonGroup.add((AbstractButton)this.destinationTypeQueue);
        this.destinationTypeQueue.setText("Queue");
        this.destinationTypeQueue.setToolTipText("If not using JNDI, specify whether the destination is a queue or a topic.");
        this.destinationTypeQueue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsConnectorPanel.this.destinationTypeQueueActionPerformed(evt);
            }
        });
        this.destinationNameLabel.setText("Destination Name:");
        this.destinationTypeTopic.setBackground(new Color(255, 255, 255));
        this.destinationTypeButtonGroup.add((AbstractButton)this.destinationTypeTopic);
        this.destinationTypeTopic.setText("Topic");
        this.destinationTypeTopic.setToolTipText("If not using JNDI, specify whether the destination is a queue or a topic.");
        this.destinationTypeTopic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsConnectorPanel.this.destinationTypeTopicActionPerformed(evt);
            }
        });
        this.connectionFactoryClassField.setToolTipText("If using the generic JMS provider and not using JNDI, enter the full Java classname of the JMS connection factory here.");
        this.usernameLabel.setText("Username:");
        this.connectionFactoryClassLabel.setText("Connection Factory Class:");
        this.connectionFactoryNameLabel.setHorizontalAlignment(4);
        this.connectionFactoryNameLabel.setText("Connection Factory Name:");
        this.providerUrlLabel.setText("Provider URL:");
        this.initialContextFactoryLabel.setText("Initial Context Factory:");
        this.useJndiLabel.setText("Use JNDI:");
        this.connectionPropertiesLabel.setText("Connection Properties:");
        this.connectionPropertiesScrollPane.setViewportView((Component)this.connectionPropertiesTable);
        this.newButton.setText("New");
        this.newButton.setToolTipText("<html>Adds a new row to end of the list.<br>Double click the Property and Value cells to enter their values.</html>");
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Deletes the currently selected row from the list.");
        this.passwordField.setToolTipText("The password for accessing the queue or topic.");
        this.clientIdLabel.setText("Client ID:");
        this.clientIdField.setToolTipText("The JMS client ID to use when connecting to the JMS broker.");
        this.templateScrollPane.setBorder(null);
        this.templateList.setBorder(BorderFactory.createTitledBorder(null, "Connection Templates", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 0)));
        this.templateList.setSelectionMode(0);
        this.templateScrollPane.setViewportView(this.templateList);
        this.loadTemplateButton.setText("Load");
        this.loadTemplateButton.setToolTipText("<html>Populates connection information using the selected connection template.</html>");
        this.loadTemplateButton.setEnabled(false);
        this.loadTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsConnectorPanel.this.loadTemplateButtonActionPerformed(evt);
            }
        });
        this.saveTemplateButton.setText("Save");
        this.saveTemplateButton.setToolTipText("<html>Saves the current connection information as a new connection template.</html>");
        this.saveTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsConnectorPanel.this.saveTemplateButtonActionPerformed(evt);
            }
        });
        this.deleteTemplateButton.setText("Delete");
        this.deleteTemplateButton.setToolTipText("<html>Deletes the selected connection template.</html>");
        this.deleteTemplateButton.setEnabled(false);
        this.deleteTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JmsConnectorPanel.this.deleteTemplateButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionFactoryNameLabel, GroupLayout.Alignment.TRAILING, -2, 150, -2).addComponent(this.providerUrlLabel, GroupLayout.Alignment.TRAILING).addComponent(this.usernameLabel, GroupLayout.Alignment.TRAILING).addComponent(this.connectionFactoryClassLabel, GroupLayout.Alignment.TRAILING).addComponent(this.connectionPropertiesLabel, GroupLayout.Alignment.TRAILING).addComponent(this.initialContextFactoryLabel, GroupLayout.Alignment.TRAILING).addComponent(this.useJndiLabel, GroupLayout.Alignment.TRAILING).addComponent(this.passwordLabel, GroupLayout.Alignment.TRAILING).addComponent(this.destinationTypeLabel, GroupLayout.Alignment.TRAILING).addComponent(this.clientIdLabel, GroupLayout.Alignment.TRAILING).addComponent(this.destinationNameLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.destinationTypeQueue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.destinationTypeTopic, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.durableTopicCheckbox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.useJndiYes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.useJndiNo, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.connectionPropertiesScrollPane, -1, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.connectionFactoryClassField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.connectionFactoryNameField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.initialContextFactoryField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.providerUrlField, GroupLayout.Alignment.LEADING, -1, 400, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.newButton, -1, -1, Short.MAX_VALUE).addComponent((Component)this.deleteButton, -2, -1, -2)))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateScrollPane, -2, 156, -2).addGroup(layout.createSequentialGroup().addComponent((Component)this.loadTemplateButton, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.saveTemplateButton, -1, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.deleteTemplateButton, -2, 52, -2)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.clientIdField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.usernameField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.passwordField, GroupLayout.Alignment.LEADING).addComponent((Component)this.destinationNameField, GroupLayout.Alignment.LEADING, -2, 240, -2)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useJndiLabel).addComponent((Component)this.useJndiYes, -2, -1, -2).addComponent((Component)this.useJndiNo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.providerUrlLabel).addComponent((Component)this.providerUrlField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialContextFactoryLabel).addComponent((Component)this.initialContextFactoryField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectionFactoryNameLabel).addComponent((Component)this.connectionFactoryNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectionFactoryClassLabel).addComponent((Component)this.connectionFactoryClassField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.newButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.deleteButton, -2, -1, -2)).addComponent(this.connectionPropertiesLabel).addComponent(this.connectionPropertiesScrollPane, -2, 0, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.templateScrollPane, -2, 272, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.loadTemplateButton, -2, -1, -2).addComponent((Component)this.saveTemplateButton, -2, -1, -2).addComponent((Component)this.deleteTemplateButton, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.usernameField, -2, -1, -2).addComponent(this.usernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordField, -2, -1, -2).addComponent(this.passwordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.destinationTypeQueue, -2, -1, -2).addComponent((Component)this.destinationTypeTopic, -2, -1, -2).addComponent((Component)this.durableTopicCheckbox, -2, -1, -2).addComponent(this.destinationTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.destinationNameField, -2, -1, -2).addComponent(this.destinationNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.clientIdField, -2, -1, -2).addComponent(this.clientIdLabel))));
    }

    private void useJndiYesActionPerformed(ActionEvent evt) {
        this.providerUrlLabel.setEnabled(true);
        this.providerUrlField.setEnabled(true);
        this.initialContextFactoryLabel.setEnabled(true);
        this.initialContextFactoryField.setEnabled(true);
        this.connectionFactoryNameLabel.setEnabled(true);
        this.connectionFactoryNameField.setEnabled(true);
        this.connectionFactoryClassLabel.setEnabled(false);
        this.connectionFactoryClassField.setEnabled(false);
        if (this.connectorType == 2) {
            this.destinationTypeLabel.setEnabled(false);
            this.destinationTypeQueue.setEnabled(false);
            this.destinationTypeTopic.setEnabled(false);
            this.durableTopicCheckbox.setEnabled(false);
        }
    }

    private void useJndiNoActionPerformed(ActionEvent evt) {
        this.providerUrlLabel.setEnabled(false);
        this.providerUrlField.setEnabled(false);
        this.initialContextFactoryLabel.setEnabled(false);
        this.initialContextFactoryField.setEnabled(false);
        this.connectionFactoryNameLabel.setEnabled(false);
        this.connectionFactoryNameField.setEnabled(false);
        if (this.connectorType == 2) {
            this.destinationTypeLabel.setEnabled(true);
            this.destinationTypeQueue.setEnabled(true);
            this.destinationTypeTopic.setEnabled(true);
            if (this.destinationTypeTopic.isSelected()) {
                this.durableTopicCheckbox.setEnabled(true);
            }
        }
        this.connectionFactoryClassLabel.setEnabled(true);
        this.connectionFactoryClassField.setEnabled(true);
    }

    private void destinationTypeQueueActionPerformed(ActionEvent evt) {
        this.durableTopicCheckbox.setEnabled(false);
    }

    private void destinationTypeTopicActionPerformed(ActionEvent evt) {
        if (this.useJndiNo.isSelected() || this.connectorType == 1) {
            this.durableTopicCheckbox.setEnabled(true);
        }
    }

    private void loadTemplateButtonActionPerformed(ActionEvent evt) {
        String templateName = this.templateList.getSelectedValue().toString();
        if (this.confirmDialog("Are you sure you want to overwrite the current connection settings with the template: \"" + templateName + "\"?")) {
            JmsConnectorProperties template = this.listModel.getTemplate(templateName);
            if (template == null) {
                this.parent.alertError((Component)this.parent, "The template \"" + templateName + "\" no longer exists on the server.");
            } else {
                if (template.isUseJndi()) {
                    this.useJndiYes.setSelected(true);
                    this.useJndiNo.setSelected(false);
                    this.useJndiYesActionPerformed(null);
                } else {
                    this.useJndiYes.setSelected(false);
                    this.useJndiNo.setSelected(true);
                    this.useJndiNoActionPerformed(null);
                }
                this.providerUrlField.setText(template.getJndiProviderUrl());
                this.initialContextFactoryField.setText(template.getJndiInitialContextFactory());
                this.connectionFactoryNameField.setText(template.getJndiConnectionFactoryName());
                this.connectionFactoryClassField.setText(template.getConnectionFactoryClass());
                this.connectionPropertiesTable.setProperties(template.getConnectionProperties());
            }
        }
    }

    private void saveTemplateButtonActionPerformed(ActionEvent evt) {
        String defaultValue;
        String templateName = null;
        String string = defaultValue = this.templateList.getSelectedValue() == null || this.listModel.isPredefinedTemplate(this.templateList.getSelectedValue().toString()) ? "" : this.templateList.getSelectedValue();
        do {
            String response;
            if ((response = DisplayUtil.showInputDialog((Component)this.parent, (Object)"Enter a name for the connection template:", (String)"Save", (int)3, null, null, (Object)defaultValue)) == null) {
                return;
            }
            templateName = StringUtils.trim((String)response.toString());
            if (templateName.isEmpty()) {
                return;
            }
            if (!this.listModel.isPredefinedTemplate(templateName)) continue;
            this.parent.alertWarning((Component)this.parent, "\"" + templateName + "\" is a reserved template and cannot be overwritten. Please enter a different template name.");
            defaultValue = "";
        } while (this.listModel.isPredefinedTemplate(templateName));
        if (this.listModel.containsTemplate(templateName) && !this.confirmDialog("Are you sure you want to overwrite the existing template named \"" + templateName + "\"?")) {
            return;
        }
        JmsConnectorProperties template = new JmsConnectorProperties();
        template.setUseJndi(this.useJndiYes.isSelected());
        template.setJndiProviderUrl(this.providerUrlField.getText());
        template.setJndiInitialContextFactory(this.initialContextFactoryField.getText());
        template.setJndiConnectionFactoryName(this.connectionFactoryNameField.getText());
        template.setConnectionFactoryClass(this.connectionFactoryClassField.getText());
        template.setConnectionProperties(this.connectionPropertiesTable.getProperties());
        try {
            ((JmsConnectorServletInterface)this.parent.mirthClient.getServlet(JmsConnectorServletInterface.class)).saveTemplate(templateName, template);
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)this.parent, (Throwable)e);
            return;
        }
        this.listModel.putTemplate(templateName, template);
        this.templateList.setSelectedValue(templateName, true);
    }

    private void deleteTemplateButtonActionPerformed(ActionEvent evt) {
        String templateName = this.templateList.getSelectedValue().toString();
        if (this.listModel.isPredefinedTemplate(templateName) || !this.confirmDialog("Are you sure you want to delete the template \"" + templateName + "\"?")) {
            return;
        }
        try {
            ((JmsConnectorServletInterface)this.parent.mirthClient.getServlet(JmsConnectorServletInterface.class)).deleteTemplate(templateName);
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)this.parent, (Throwable)e);
            return;
        }
        int selectedIndex = this.templateList.getSelectedIndex();
        this.listModel.deleteTemplate(templateName);
        if (selectedIndex >= this.listModel.getSize()) {
            selectedIndex = this.listModel.getSize() - 1;
        }
        this.templateList.setSelectedIndex(selectedIndex);
    }

    private boolean confirmDialog(String message) {
        return 0 == JOptionPane.showConfirmDialog((Component)this.parent, message, "Confirm", 0, 2);
    }

    private class TemplateListCellRenderer
    extends DefaultListCellRenderer {
        private TemplateListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && JmsConnectorPanel.this.listModel.isPredefinedTemplate(value.toString())) {
                HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
                attributes.putAll(this.getFont().getAttributes());
                attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                attributes.put(TextAttribute.FOREGROUND, new Color(64, 64, 64));
                this.setFont(new Font(attributes));
            }
            return component;
        }
    }
}

