/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias(value="version")
public enum Version {
    V0("0"),
    V1("1"),
    V2("2"),
    V3("3"),
    V4("4"),
    V5("5"),
    V6("6"),
    V7("7"),
    V8("8"),
    V9("9", "2.2.0"),
    V3_0_0("3.0.0"),
    V3_0_1("3.0.1"),
    V3_0_2("3.0.2"),
    V3_0_3("3.0.3"),
    V3_1_0("3.1.0"),
    V3_1_1("3.1.1"),
    V3_2_0("3.2.0"),
    V3_2_1("3.2.1"),
    V3_2_2("3.2.2"),
    V3_3_0("3.3.0"),
    V3_3_1("3.3.1"),
    V3_3_2("3.3.2"),
    V3_4_0("3.4.0"),
    V3_4_1("3.4.1"),
    V3_4_2("3.4.2"),
    V3_5_0("3.5.0"),
    V3_5_1("3.5.1"),
    V3_5_2("3.5.2"),
    V3_6_0("3.6.0"),
    V3_6_1("3.6.1"),
    V3_6_2("3.6.2"),
    V3_7_0("3.7.0"),
    V3_7_1("3.7.1"),
    V3_8_0("3.8.0"),
    V3_8_1("3.8.1"),
    V3_9_0("3.9.0"),
    v3_9_1("3.9.1"),
    v3_10_0("3.10.0"),
    v3_10_1("3.10.1"),
    v3_11_0("3.11.0"),
    v3_11_1("3.11.1"),
    v3_12_0("3.12.0"),
    v4_0_0("4.0.0"),
    v4_0_1("4.0.1"),
    v4_1_0("4.1.0"),
    v4_1_1("4.1.1"),
    v4_2_0("4.2.0"),
    v4_3_0("4.3.0"),
    v4_4_0("4.4.0"),
    v4_4_1("4.4.1"),
    v4_4_2("4.4.2"),
    v4_5_0("4.5.0"),
    v4_5_1("4.5.1"),
    v4_5_2("4.5.2"),
    v4_5_3("4.5.3"),
    v4_5_4("4.5.4"),
    v4_6_0("4.6.0"),
    v4_6_1("4.6.1");

    private String schemaVersion;
    private String versionString;

    private Version(String schemaVersion) {
        this.schemaVersion = schemaVersion;
        this.versionString = schemaVersion;
    }

    private Version(String schemaVersion, String versionString) {
        this.schemaVersion = schemaVersion;
        this.versionString = versionString;
    }

    public Version getNextVersion() {
        if (this.ordinal() < Version.getLatest().ordinal()) {
            return Version.values()[this.ordinal() + 1];
        }
        return null;
    }

    public String toString() {
        return this.versionString;
    }

    public String toPackageString() {
        return "v" + this.versionString.replaceAll("\\.", "");
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public static Version getApiEarliest() {
        return V3_4_0;
    }

    public static Version getLatest() {
        Version[] allVersions = Version.values();
        return allVersions[allVersions.length - 1];
    }

    public static Version fromString(String value) {
        for (Version version : Version.values()) {
            if (!version.getSchemaVersion().equals(value)) continue;
            return version;
        }
        return null;
    }
}

