/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.providers;

import com.mirth.connect.model.filters.elements.MetaDataSearchOperator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;

@Provider
@Singleton
public class MetaDataSearchParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.getName().equals(MetaDataSearch.class.getName())) {
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    return MetaDataSearch.fromString(value);
                }

                public String toString(T value) {
                    return value != null ? value.toString() : null;
                }
            };
        }
        return null;
    }

    public static class MetaDataSearch {
        private String columnName;
        private MetaDataSearchOperator operator;
        private String value;

        public MetaDataSearch() {
        }

        public MetaDataSearch(String columnName, MetaDataSearchOperator operator, String value) {
            this.columnName = columnName;
            this.operator = operator;
            this.value = value;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public MetaDataSearchOperator getOperator() {
            return this.operator;
        }

        public void setOperator(MetaDataSearchOperator operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static MetaDataSearch fromString(String value) {
            return MetaDataSearch.valueOf(value);
        }

        public static MetaDataSearch valueOf(String value) {
            int spaceIndex;
            if (value != null && (spaceIndex = StringUtils.indexOf((CharSequence)(value = value.replaceAll("^\\s+", "")), (int)32)) > 0) {
                String columnName = StringUtils.trim((String)StringUtils.substring((String)value, (int)0, (int)spaceIndex));
                value = StringUtils.substring((String)value, (int)spaceIndex).replaceAll("^\\s+", "");
                ArrayList<MetaDataSearchOperator> operators = new ArrayList<MetaDataSearchOperator>(Arrays.asList(MetaDataSearchOperator.values()));
                Collections.sort(operators, new Comparator<MetaDataSearchOperator>(){

                    @Override
                    public int compare(MetaDataSearchOperator o1, MetaDataSearchOperator o2) {
                        int diff = o2.toString().length() - o1.toString().length();
                        return diff == 0 ? o2.toString().compareTo(o1.toString()) : diff;
                    }
                });
                MetaDataSearchOperator operator = null;
                for (MetaDataSearchOperator op : operators) {
                    if (!StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)(op.toString() + " "))) continue;
                    operator = op;
                    value = StringUtils.removeStartIgnoreCase((String)value, (String)(op.toString() + " "));
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)columnName) && operator != null) {
                    return new MetaDataSearch(columnName, operator, value);
                }
            }
            return null;
        }

        public String toString() {
            return StringUtils.trim((String)this.columnName) + ' ' + (Object)((Object)this.operator) + ' ' + this.value;
        }
    }
}

