/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.FilterTransformer;
import com.mirth.connect.model.Rule;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="filter")
public class Filter
extends FilterTransformer<Rule> {
    public Filter() {
    }

    public Filter(Filter props) {
        super(props);
    }

    @Override
    public void migrate3_0_1(DonkeyElement filter) {
        for (DonkeyElement rule : filter.getChildElement("rules").getChildElements()) {
            rule.getChildElement("data").removeAttribute("class");
        }
    }

    @Override
    public void migrate3_5_0(DonkeyElement element) {
        DonkeyElement rulesElement = element.removeChild("rules");
        List rules = rulesElement.getChildElements();
        rulesElement = element.addChildElement("elements");
        for (DonkeyElement ruleElement : rules) {
            DonkeyElement newRuleElement;
            String type = ruleElement.getChildElement("type").getTextContent();
            DonkeyElement dataElement = ruleElement.getChildElement("data");
            HashMap<String, DonkeyElement> dataMap = new HashMap<String, DonkeyElement>();
            for (Object entry : dataElement.getChildElements()) {
                List values = entry.getChildElements();
                dataMap.put(((DonkeyElement)values.get(0)).getTextContent(), (DonkeyElement)values.get(1));
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)"Rule Builder")) {
                newRuleElement = rulesElement.addChildElement("com.mirth.connect.plugins.rulebuilder.RuleBuilderRule");
                newRuleElement.addChildElement("field", ((DonkeyElement)dataMap.get("Field")).getTextContent());
                newRuleElement.addChildElement("condition", switch (((DonkeyElement)dataMap.get("Equals")).getTextContent()) {
                    case "0" -> "NOT_EQUAL";
                    case "1" -> "EQUALS";
                    case "2" -> "EXISTS";
                    case "3" -> "NOT_EXIST";
                    case "4" -> "CONTAINS";
                    case "5" -> "NOT_CONTAIN";
                    default -> "EXISTS";
                });
                DonkeyElement values = newRuleElement.addChildElement("values");
                for (DonkeyElement value : ((DonkeyElement)dataMap.get("Values")).getChildElements()) {
                    values.addChildElement("string", value.getTextContent());
                }
            } else if (StringUtils.equals((CharSequence)type, (CharSequence)"External Script")) {
                newRuleElement = rulesElement.addChildElement("com.mirth.connect.plugins.scriptfilerule.ExternalScriptRule");
                newRuleElement.addChildElement("scriptPath", ((DonkeyElement)dataMap.get("Variable")).getTextContent());
            } else {
                newRuleElement = rulesElement.addChildElement("com.mirth.connect.plugins.javascriptrule.JavaScriptRule");
                DonkeyElement script = (DonkeyElement)dataMap.get("Script");
                if (script != null) {
                    newRuleElement.addChildElement("script", script.getTextContent());
                } else {
                    newRuleElement.addChildElement("script", ruleElement.getChildElement("script").getTextContent());
                }
            }
            newRuleElement.addChildElement("sequenceNumber", ruleElement.getChildElement("sequenceNumber").getTextContent());
            newRuleElement.addChildElement("operator", ruleElement.getChildElement("operator").getTextContent());
            DonkeyElement nameElement = ruleElement.getChildElement("name");
            newRuleElement.addChildElement("name", nameElement != null ? nameElement.getTextContent() : "");
        }
    }

    @Override
    public void migrate3_6_0(DonkeyElement element) {
    }

    @Override
    public Filter clone() {
        return new Filter(this);
    }
}

