/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.attachments;

import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;

public enum AttachmentHandlerType {
    NONE("None"),
    IDENTITY("Entire Message"),
    REGEX("Regex"),
    DICOM("DICOM"),
    JAVASCRIPT("JavaScript"),
    CUSTOM("Custom");

    private String type;

    private AttachmentHandlerType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    public AttachmentHandlerProperties getDefaultProperties() {
        AttachmentHandlerProperties properties = new AttachmentHandlerProperties(this.getDefaultClassName(), this.type.toString());
        if (this == REGEX) {
            properties.getProperties().put("regex.pattern0", "");
            properties.getProperties().put("regex.mimetype0", "");
        } else if (this == JAVASCRIPT) {
            properties.getProperties().put("javascript.script", "// Modify the message variable below to create attachments\nreturn message;");
        }
        return properties;
    }

    public String getDefaultClassName() {
        if (this == NONE) {
            return null;
        }
        if (this == IDENTITY) {
            return "com.mirth.connect.server.attachments.identity.IdentityAttachmentHandlerProvider";
        }
        if (this == REGEX) {
            return "com.mirth.connect.server.attachments.regex.RegexAttachmentHandlerProvider";
        }
        if (this == DICOM) {
            return "com.mirth.connect.server.attachments.dicom.DICOMAttachmentHandlerProvider";
        }
        if (this == JAVASCRIPT) {
            return "com.mirth.connect.server.attachments.javascript.JavaScriptAttachmentHandlerProvider";
        }
        if (this == CUSTOM) {
            return "";
        }
        return null;
    }

    public static AttachmentHandlerType fromString(String type) {
        if (type.equals("None")) {
            return NONE;
        }
        if (type.equals("Entire Message")) {
            return IDENTITY;
        }
        if (type.equals("Regex")) {
            return REGEX;
        }
        if (type.equals("DICOM")) {
            return DICOM;
        }
        if (type.equals("JavaScript")) {
            return JAVASCRIPT;
        }
        if (type.equals("Custom")) {
            return CUSTOM;
        }
        return null;
    }
}

