/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.util.ThreadUtils;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.FilenameUtils;
import com.mirth.connect.util.VfsUtils;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageImporter {
    private static final String OPEN_ELEMENT = "<message>";
    private static final String CLOSE_ELEMENT = "</message>";
    private static final String CHARSET = "UTF-8";
    private static final int XML_SCAN_BUFFER_SIZE = 20;
    private ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
    private Logger logger = LogManager.getLogger(this.getClass());

    public MessageImportResult importMessages(String path, Boolean recursive, MessageWriter messageWriter, String baseDir) throws InterruptedException, MessageImportException, MessageImportInvalidPathException {
        int[] result = new int[]{0, 0};
        if (baseDir == null) {
            baseDir = System.getProperty("user.dir");
        }
        try {
            path = FilenameUtils.getAbsolutePath(new File(baseDir), path);
            if (!new File(path).canRead()) {
                throw new MessageImportInvalidPathException("The file/folder was not found or is not readable: " + path);
            }
            FileObject file = VfsUtils.getManager().resolveFile(VfsUtils.pathToUri(path));
            switch (file.getType()) {
                case FOLDER: {
                    for (FileObject child : file.getChildren()) {
                        if (recursive.booleanValue()) {
                            this.importVfsFileRecursive(child, messageWriter, result);
                            continue;
                        }
                        if (child.getType() != FileType.FILE) continue;
                        this.importVfsFile(child, messageWriter, result);
                    }
                    break;
                }
                case FILE: {
                    this.importVfsFile(file, messageWriter, result);
                }
            }
            messageWriter.finishWrite();
        }
        catch (Exception e) {
            throw new MessageImportException(e);
        }
        finally {
            try {
                messageWriter.close();
            }
            catch (Exception e) {
                this.logger.error("Failed to close message writer", (Throwable)e);
            }
        }
        return new MessageImportResult(result[0], result[1]);
    }

    private void importVfsFileRecursive(FileObject file, MessageWriter messageWriter, int[] result) throws InterruptedException, MessageImportException {
        try {
            switch (file.getType()) {
                case FOLDER: {
                    this.logger.debug("Reading folder: " + file.getName().getURI());
                    for (FileObject child : file.getChildren()) {
                        ThreadUtils.checkInterruptedStatus();
                        this.importVfsFileRecursive(child, messageWriter, result);
                    }
                    break;
                }
                case FILE: {
                    this.importVfsFile(file, messageWriter, result);
                }
            }
        }
        catch (FileSystemException e) {
            this.logger.error("An error occurred when accessing: " + file.getName().getURI(), (Throwable)e);
        }
    }

    private void importVfsFile(FileObject file, MessageWriter messageWriter, int[] result) throws InterruptedException, MessageImportException {
        InputStream inputStream = null;
        try {
            inputStream = file.getContent().getInputStream();
            char[] cbuf = new char[20];
            new InputStreamReader(inputStream, CHARSET).read(cbuf);
            if (StringUtils.contains((CharSequence)new String(cbuf), (CharSequence)OPEN_ELEMENT)) {
                this.logger.debug("Importing file: " + file.getName().getURI());
                inputStream.close();
                inputStream = file.getContent().getInputStream();
                this.importMessagesFromInputStream(inputStream, messageWriter, result);
            }
        }
        catch (IOException e) {
            throw new MessageImportException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importMessagesFromInputStream(InputStream inputStream, MessageWriter messageWriter, int[] result) throws IOException, InterruptedException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder serializedMessage = new StringBuilder();
            boolean enteredMessage = true;
            int depth = 0;
            while ((line = reader.readLine()) != null) {
                ThreadUtils.checkInterruptedStatus();
                if (StringUtils.contains((CharSequence)line, (CharSequence)OPEN_ELEMENT)) {
                    ++depth;
                    enteredMessage = true;
                }
                if (!enteredMessage) continue;
                serializedMessage.append(line);
                if (!StringUtils.contains((CharSequence)line, (CharSequence)CLOSE_ELEMENT)) continue;
                if (depth == 1) {
                    Message message = this.serializer.deserialize(serializedMessage.toString(), Message.class);
                    serializedMessage.delete(0, serializedMessage.length());
                    enteredMessage = false;
                    result[0] = result[0] + 1;
                    try {
                        if (messageWriter.write(message)) {
                            result[1] = result[1] + 1;
                        }
                    }
                    catch (MessageWriterException e) {
                        this.logger.error("Failed to write message", (Throwable)e);
                    }
                }
                --depth;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    public static class MessageImportInvalidPathException
    extends Exception {
        public MessageImportInvalidPathException(String message) {
            super(message);
        }
    }

    public static class MessageImportException
    extends Exception {
        public MessageImportException(String message) {
            super(message);
        }

        public MessageImportException(Throwable cause) {
            super(cause);
        }

        public MessageImportException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

