/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.donkey.util.DonkeyElement;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.xmlpull.mxp1.MXParser;

public class MigrationUtil {
    public static String getSerializedObjectVersion(String serializedObject) throws Exception {
        String version = MigrationUtil.getRootNodeAttribute(serializedObject, "version");
        if (version != null) {
            return version;
        }
        DonkeyElement element = new DonkeyElement(serializedObject);
        for (DonkeyElement child : element.getChildElements()) {
            if (!child.getNodeName().equals("version")) continue;
            return child.getTextContent();
        }
        return null;
    }

    private static String getRootNodeAttribute(String serializedObject, String attributeName) throws Exception {
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(serializedObject));
        while (parser.getEventType() != 2) {
            parser.next();
        }
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            if (!parser.getAttributeName(i).equals(attributeName)) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }

    public static int compareVersions(String version1, String version2) {
        return MigrationUtil.compareVersions(version1, version2, 3);
    }

    public static int compareVersions(String version1, String version2, int length) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 != null && version2 == null) {
            return 1;
        }
        if (version1 == null && version2 != null) {
            return -1;
        }
        String[] numbers1 = MigrationUtil.normalizeVersion(version1, length).split("\\.");
        String[] numbers2 = MigrationUtil.normalizeVersion(version2, length).split("\\.");
        for (int i = 0; i < numbers1.length; ++i) {
            if (Integer.valueOf(numbers1[i]) < Integer.valueOf(numbers2[i])) {
                return -1;
            }
            if (Integer.valueOf(numbers1[i]) <= Integer.valueOf(numbers2[i])) continue;
            return 1;
        }
        return 0;
    }

    public static String normalizeVersion(String version, int length) {
        if (version == null) {
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>(Arrays.asList(version.split("\\.")));
        while (numbers.size() < length) {
            numbers.add("0");
        }
        StringBuilder builder = new StringBuilder();
        ListIterator iterator = numbers.listIterator();
        while (iterator.hasNext() && iterator.nextIndex() < length) {
            String number = (String)iterator.next();
            if (iterator.hasNext() && iterator.nextIndex() < length) {
                builder.append(number + ".");
                continue;
            }
            builder.append(number);
        }
        return builder.toString();
    }
}

