/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.segment.AIG;
import ca.uhn.hl7v2.model.v27.segment.AIL;
import ca.uhn.hl7v2.model.v27.segment.AIP;
import ca.uhn.hl7v2.model.v27.segment.AIS;
import ca.uhn.hl7v2.model.v27.segment.OBX;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCR_I16_RESOURCE_DETAIL
extends AbstractGroup {
    public CCR_I16_RESOURCE_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(AIS.class, true, false, true);
            this.add(AIG.class, true, false, true);
            this.add(AIL.class, true, false, true);
            this.add(AIP.class, true, false, true);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCR_I16_RESOURCE_DETAIL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public AIS getAIS() {
        AIS retVal = (AIS)this.getTyped("AIS", AIS.class);
        return retVal;
    }

    public AIG getAIG() {
        AIG retVal = (AIG)this.getTyped("AIG", AIG.class);
        return retVal;
    }

    public AIL getAIL() {
        AIL retVal = (AIL)this.getTyped("AIL", AIL.class);
        return retVal;
    }

    public AIP getAIP() {
        AIP retVal = (AIP)this.getTyped("AIP", AIP.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = (OBX)this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

