/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.EHC_E13_REQUEST;
import ca.uhn.hl7v2.model.v27.segment.CTD;
import ca.uhn.hl7v2.model.v27.segment.ERR;
import ca.uhn.hl7v2.model.v27.segment.IVC;
import ca.uhn.hl7v2.model.v27.segment.MSA;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.PID;
import ca.uhn.hl7v2.model.v27.segment.PSG;
import ca.uhn.hl7v2.model.v27.segment.PSL;
import ca.uhn.hl7v2.model.v27.segment.PSS;
import ca.uhn.hl7v2.model.v27.segment.RFI;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E13
extends AbstractMessage {
    public EHC_E13() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EHC_E13(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(RFI.class, true, false);
            this.add(CTD.class, false, true);
            this.add(IVC.class, true, false);
            this.add(PSS.class, true, false);
            this.add(PSG.class, true, false);
            this.add(PID.class, false, false);
            this.add(PSL.class, false, false);
            this.add(EHC_E13_REQUEST.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E13 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return (UAC)this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", (Structure)structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public RFI getRFI() {
        return (RFI)this.getTyped("RFI", RFI.class);
    }

    public CTD getCTD() {
        return (CTD)this.getTyped("CTD", CTD.class);
    }

    public CTD getCTD(int rep) {
        return (CTD)this.getTyped("CTD", rep, CTD.class);
    }

    public int getCTDReps() {
        return this.getReps("CTD");
    }

    public List<CTD> getCTDAll() throws HL7Exception {
        return this.getAllAsList("CTD", CTD.class);
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", (Structure)structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }

    public IVC getIVC() {
        return (IVC)this.getTyped("IVC", IVC.class);
    }

    public PSS getPSS() {
        return (PSS)this.getTyped("PSS", PSS.class);
    }

    public PSG getPSG() {
        return (PSG)this.getTyped("PSG", PSG.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PSL getPSL() {
        return (PSL)this.getTyped("PSL", PSL.class);
    }

    public EHC_E13_REQUEST getREQUEST() {
        return (EHC_E13_REQUEST)this.getTyped("REQUEST", EHC_E13_REQUEST.class);
    }

    public EHC_E13_REQUEST getREQUEST(int rep) {
        return (EHC_E13_REQUEST)this.getTyped("REQUEST", rep, EHC_E13_REQUEST.class);
    }

    public int getREQUESTReps() {
        return this.getReps("REQUEST");
    }

    public List<EHC_E13_REQUEST> getREQUESTAll() throws HL7Exception {
        return this.getAllAsList("REQUEST", EHC_E13_REQUEST.class);
    }

    public void insertREQUEST(EHC_E13_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("REQUEST", (Structure)structure, rep);
    }

    public EHC_E13_REQUEST insertREQUEST(int rep) throws HL7Exception {
        return (EHC_E13_REQUEST)super.insertRepetition("REQUEST", rep);
    }

    public EHC_E13_REQUEST removeREQUEST(int rep) throws HL7Exception {
        return (EHC_E13_REQUEST)super.removeRepetition("REQUEST", rep);
    }
}

