/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CQ;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.NULLDT;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class INV
extends AbstractSegment {
    public INV(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Substance Identifier");
            this.add(CWE.class, true, 0, 0, new Object[]{this.getMessage()}, "Substance Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Substance Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Inventory Container Identifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Container Carrier Identifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Position on Carrier");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Initial Quantity");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Current Quantity");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Available Quantity");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Consumption Quantity");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity Units");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expiration Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "First Used Date/Time");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "On Board Stability Duration");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Test/Fluid Identifier(s)");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Manufacturer Lot Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Manufacturer Identifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Supplier Identifier");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "On Board Stability Time");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Target Value");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating INV - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getSubstanceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getInv1_SubstanceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getSubstanceStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getInv2_SubstanceStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSubstanceStatusReps() {
        return this.getReps(2);
    }

    public CWE getSubstanceStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getInv2_SubstanceStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getInv2_SubstanceStatusReps() {
        return this.getReps(2);
    }

    public CWE insertSubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertInv2_SubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeSubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeInv2_SubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE getSubstanceType() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getInv3_SubstanceType() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getInventoryContainerIdentifier() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getInv4_InventoryContainerIdentifier() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getContainerCarrierIdentifier() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getInv5_ContainerCarrierIdentifier() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getPositionOnCarrier() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getInv6_PositionOnCarrier() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getInitialQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getInv7_InitialQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getCurrentQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getInv8_CurrentQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getAvailableQuantity() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getInv9_AvailableQuantity() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getConsumptionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getInv10_ConsumptionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getQuantityUnits() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getInv11_QuantityUnits() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getExpirationDateTime() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getInv12_ExpirationDateTime() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getFirstUsedDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getInv13_FirstUsedDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public NULLDT getOnBoardStabilityDuration() {
        NULLDT retVal = (NULLDT)this.getTypedField(14, 0);
        return retVal;
    }

    public NULLDT getInv14_OnBoardStabilityDuration() {
        NULLDT retVal = (NULLDT)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE[] getTestFluidIdentifierS() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getInv15_TestFluidIdentifierS() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public int getTestFluidIdentifierSReps() {
        return this.getReps(15);
    }

    public CWE getTestFluidIdentifierS(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public CWE getInv15_TestFluidIdentifierS(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getInv15_TestFluidIdentifierSReps() {
        return this.getReps(15);
    }

    public CWE insertTestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertInv15_TestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeTestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removeInv15_TestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public ST getManufacturerLotNumber() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getInv16_ManufacturerLotNumber() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getManufacturerIdentifier() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getInv17_ManufacturerIdentifier() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getSupplierIdentifier() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getInv18_SupplierIdentifier() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ getOnBoardStabilityTime() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getInv19_OnBoardStabilityTime() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getTargetValue() {
        CQ retVal = (CQ)this.getTypedField(20, 0);
        return retVal;
    }

    public CQ getInv20_TargetValue() {
        CQ retVal = (CQ)this.getTypedField(20, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new DTM(this.getMessage());
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new NULLDT(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new CQ(this.getMessage());
            }
            case 19: {
                return new CQ(this.getMessage());
            }
        }
        return null;
    }
}

