/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.segment.MFE;
import ca.uhn.hl7v2.model.v28.segment.OM1;
import ca.uhn.hl7v2.model.v28.segment.OM2;
import ca.uhn.hl7v2.model.v28.segment.OM3;
import ca.uhn.hl7v2.model.v28.segment.OM4;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M08_MF_TEST_NUMERIC
extends AbstractGroup {
    public MFN_M08_MF_TEST_NUMERIC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(OM1.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(OM2.class, false, false, false);
            this.add(OM3.class, false, false, false);
            this.add(OM4.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M08_MF_TEST_NUMERIC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MFE getMFE() {
        MFE retVal = (MFE)this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public OM1 getOM1() {
        OM1 retVal = (OM1)this.getTyped("OM1", OM1.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OM2 getOM2() {
        OM2 retVal = (OM2)this.getTyped("OM2", OM2.class);
        return retVal;
    }

    public OM3 getOM3() {
        OM3 retVal = (OM3)this.getTyped("OM3", OM3.class);
        return retVal;
    }

    public OM4 getOM4() {
        OM4 retVal = (OM4)this.getTyped("OM4", OM4.class);
        return retVal;
    }

    public OM4 getOM4(int rep) {
        OM4 retVal = (OM4)this.getTyped("OM4", rep, OM4.class);
        return retVal;
    }

    public int getOM4Reps() {
        return this.getReps("OM4");
    }

    public List<OM4> getOM4All() throws HL7Exception {
        return this.getAllAsList("OM4", OM4.class);
    }

    public void insertOM4(OM4 structure, int rep) throws HL7Exception {
        super.insertRepetition("OM4", (Structure)structure, rep);
    }

    public OM4 insertOM4(int rep) throws HL7Exception {
        return (OM4)super.insertRepetition("OM4", rep);
    }

    public OM4 removeOM4(int rep) throws HL7Exception {
        return (OM4)super.removeRepetition("OM4", rep);
    }
}

