/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.segment.ILT;
import ca.uhn.hl7v2.model.v28.segment.IVT;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M16_MATERIAL_LOCATION
extends AbstractGroup {
    public MFN_M16_MATERIAL_LOCATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IVT.class, true, false, false);
            this.add(ILT.class, false, true, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M16_MATERIAL_LOCATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public IVT getIVT() {
        IVT retVal = (IVT)this.getTyped("IVT", IVT.class);
        return retVal;
    }

    public ILT getILT() {
        ILT retVal = (ILT)this.getTyped("ILT", ILT.class);
        return retVal;
    }

    public ILT getILT(int rep) {
        ILT retVal = (ILT)this.getTyped("ILT", rep, ILT.class);
        return retVal;
    }

    public int getILTReps() {
        return this.getReps("ILT");
    }

    public List<ILT> getILTAll() throws HL7Exception {
        return this.getAllAsList("ILT", ILT.class);
    }

    public void insertILT(ILT structure, int rep) throws HL7Exception {
        super.insertRepetition("ILT", (Structure)structure, rep);
    }

    public ILT insertILT(int rep) throws HL7Exception {
        return (ILT)super.insertRepetition("ILT", rep);
    }

    public ILT removeILT(int rep) throws HL7Exception {
        return (ILT)super.removeRepetition("ILT", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

