/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.ORL_O40_SPECIMEN_SHIPMENT;
import ca.uhn.hl7v2.model.v28.segment.OBR;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORL_O40_OBSERVATION_REQUEST
extends AbstractGroup {
    public ORL_O40_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ORL_O40_SPECIMEN_SHIPMENT.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORL_O40_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ORL_O40_SPECIMEN_SHIPMENT getSPECIMEN_SHIPMENT() {
        ORL_O40_SPECIMEN_SHIPMENT retVal = (ORL_O40_SPECIMEN_SHIPMENT)this.getTyped("SPECIMEN_SHIPMENT", ORL_O40_SPECIMEN_SHIPMENT.class);
        return retVal;
    }

    public ORL_O40_SPECIMEN_SHIPMENT getSPECIMEN_SHIPMENT(int rep) {
        ORL_O40_SPECIMEN_SHIPMENT retVal = (ORL_O40_SPECIMEN_SHIPMENT)this.getTyped("SPECIMEN_SHIPMENT", rep, ORL_O40_SPECIMEN_SHIPMENT.class);
        return retVal;
    }

    public int getSPECIMEN_SHIPMENTReps() {
        return this.getReps("SPECIMEN_SHIPMENT");
    }

    public List<ORL_O40_SPECIMEN_SHIPMENT> getSPECIMEN_SHIPMENTAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_SHIPMENT", ORL_O40_SPECIMEN_SHIPMENT.class);
    }

    public void insertSPECIMEN_SHIPMENT(ORL_O40_SPECIMEN_SHIPMENT structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_SHIPMENT", (Structure)structure, rep);
    }

    public ORL_O40_SPECIMEN_SHIPMENT insertSPECIMEN_SHIPMENT(int rep) throws HL7Exception {
        return (ORL_O40_SPECIMEN_SHIPMENT)super.insertRepetition("SPECIMEN_SHIPMENT", rep);
    }

    public ORL_O40_SPECIMEN_SHIPMENT removeSPECIMEN_SHIPMENT(int rep) throws HL7Exception {
        return (ORL_O40_SPECIMEN_SHIPMENT)super.removeRepetition("SPECIMEN_SHIPMENT", rep);
    }
}

