/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CP;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IPR
extends AbstractSegment {
    public IPR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "IPR Identifier");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Provider Cross Reference Identifier");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Payer Cross Reference Identifier");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "IPR Status");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "IPR Date/Time");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Adjudicated/Paid Amount");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected Payment Date/Time");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "IPR Checksum");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IPR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getIPRIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getIpr1_IPRIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getProviderCrossReferenceIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getIpr2_ProviderCrossReferenceIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getPayerCrossReferenceIdentifier() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getIpr3_PayerCrossReferenceIdentifier() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getIPRStatus() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getIpr4_IPRStatus() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getIPRDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getIpr5_IPRDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public CP getAdjudicatedPaidAmount() {
        CP retVal = (CP)this.getTypedField(6, 0);
        return retVal;
    }

    public CP getIpr6_AdjudicatedPaidAmount() {
        CP retVal = (CP)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getExpectedPaymentDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getIpr7_ExpectedPaymentDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getIPRChecksum() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getIpr8_IPRChecksum() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new CP(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

