/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.ROR_ROR_ORDER;
import ca.uhn.hl7v2.model.v25.group.ROR_ROR_PATIENT;
import ca.uhn.hl7v2.model.v25.segment.QRD;
import ca.uhn.hl7v2.model.v25.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ROR_ROR_DEFINITION
extends AbstractGroup {
    public ROR_ROR_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false, false);
            this.add(QRF.class, false, false, false);
            this.add(ROR_ROR_PATIENT.class, false, false, false);
            this.add(ROR_ROR_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ROR_ROR_DEFINITION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public QRD getQRD() {
        QRD retVal = (QRD)this.getTyped("QRD", QRD.class);
        return retVal;
    }

    public QRF getQRF() {
        QRF retVal = (QRF)this.getTyped("QRF", QRF.class);
        return retVal;
    }

    public ROR_ROR_PATIENT getPATIENT() {
        ROR_ROR_PATIENT retVal = (ROR_ROR_PATIENT)this.getTyped("PATIENT", ROR_ROR_PATIENT.class);
        return retVal;
    }

    public ROR_ROR_ORDER getORDER() {
        ROR_ROR_ORDER retVal = (ROR_ROR_ORDER)this.getTyped("ORDER", ROR_ROR_ORDER.class);
        return retVal;
    }

    public ROR_ROR_ORDER getORDER(int rep) {
        ROR_ROR_ORDER retVal = (ROR_ROR_ORDER)this.getTyped("ORDER", rep, ROR_ROR_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<ROR_ROR_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", ROR_ROR_ORDER.class);
    }

    public void insertORDER(ROR_ROR_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public ROR_ROR_ORDER insertORDER(int rep) throws HL7Exception {
        return (ROR_ROR_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ROR_ROR_ORDER removeORDER(int rep) throws HL7Exception {
        return (ROR_ROR_ORDER)super.removeRepetition("ORDER", rep);
    }
}

