/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DatabaseDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    public static final String NAME = "Database Writer";
    private DestinationConnectorProperties destinationConnectorProperties;
    private String driver;
    private String url;
    private String username;
    private String password;
    private String query;
    private Object[] parameters;
    private boolean useScript;
    public static final String DRIVER_DEFAULT = "Please Select One";

    public DatabaseDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties(false);
        this.driver = DRIVER_DEFAULT;
        this.url = "";
        this.username = "";
        this.password = "";
        this.query = "";
        this.useScript = false;
    }

    public DatabaseDispatcherProperties(DatabaseDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.driver = props.getDriver();
        this.url = props.getUrl();
        this.username = props.getUsername();
        this.password = props.getPassword();
        this.query = props.getQuery();
        this.useScript = props.isUseScript();
    }

    public String getProtocol() {
        return "jdbc";
    }

    public String getName() {
        return NAME;
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("URL: ");
        builder.append(this.url);
        builder.append(newLine);
        builder.append("USERNAME: ");
        builder.append(this.username);
        builder.append(newLine);
        builder.append(newLine);
        builder.append(this.useScript ? "[SCRIPT]" : "[QUERY]");
        builder.append(newLine);
        builder.append(StringUtils.trim((String)this.query));
        for (int i = 0; i < this.parameters.length; ++i) {
            builder.append(newLine);
            builder.append(newLine);
            builder.append("[PARAMETER ");
            builder.append(String.valueOf(i + 1));
            builder.append("]");
            builder.append(newLine);
            builder.append(this.parameters[i]);
        }
        return builder.toString();
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public boolean isUseScript() {
        return this.useScript;
    }

    public void setUseScript(boolean useScript) {
        this.useScript = useScript;
    }

    public ConnectorProperties clone() {
        return new DatabaseDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("driver", this.driver);
        purgedProperties.put("queryLines", PurgeUtil.countLines((String)this.query));
        purgedProperties.put("useScript", this.useScript);
        return purgedProperties;
    }
}

