/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.ORL_O43_PATIENT;
import ca.uhn.hl7v2.model.v281.group.ORL_O43_SPECIMEN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORL_O43_RESPONSE
extends AbstractGroup {
    public ORL_O43_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORL_O43_PATIENT.class, false, false, false);
            this.add(ORL_O43_SPECIMEN.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORL_O43_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public ORL_O43_PATIENT getPATIENT() {
        ORL_O43_PATIENT retVal = (ORL_O43_PATIENT)this.getTyped("PATIENT", ORL_O43_PATIENT.class);
        return retVal;
    }

    public ORL_O43_SPECIMEN getSPECIMEN() {
        ORL_O43_SPECIMEN retVal = (ORL_O43_SPECIMEN)this.getTyped("SPECIMEN", ORL_O43_SPECIMEN.class);
        return retVal;
    }

    public ORL_O43_SPECIMEN getSPECIMEN(int rep) {
        ORL_O43_SPECIMEN retVal = (ORL_O43_SPECIMEN)this.getTyped("SPECIMEN", rep, ORL_O43_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<ORL_O43_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", ORL_O43_SPECIMEN.class);
    }

    public void insertSPECIMEN(ORL_O43_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public ORL_O43_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O43_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORL_O43_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O43_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

