/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EQU
extends AbstractSegment {
    public EQU(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 0, 0, new Object[]{this.getMessage()}, "Equipment Instance Identifier");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Event Date/Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Equipment State");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Local/Remote Control State");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Alert Level");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EQU - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI[] getEquipmentInstanceIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(1, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getEqu1_EquipmentInstanceIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(1, (Type[])new EI[0]);
        return retVal;
    }

    public int getEquipmentInstanceIdentifierReps() {
        return this.getReps(1);
    }

    public EI getEquipmentInstanceIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(1, rep);
        return retVal;
    }

    public EI getEqu1_EquipmentInstanceIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(1, rep);
        return retVal;
    }

    public int getEqu1_EquipmentInstanceIdentifierReps() {
        return this.getReps(1);
    }

    public EI insertEquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(1, rep);
    }

    public EI insertEqu1_EquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(1, rep);
    }

    public EI removeEquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(1, rep);
    }

    public EI removeEqu1_EquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(1, rep);
    }

    public DTM getEventDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getEqu2_EventDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getEquipmentState() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getEqu3_EquipmentState() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getLocalRemoteControlState() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getEqu4_LocalRemoteControlState() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getAlertLevel() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getEqu5_AlertLevel() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

