/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.tool.dcmrcv;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.filecache.FileCache;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.VerificationService;
import org.dcm4che2.tool.dcmrcv.SendStgCmtResult;
import org.dcm4che2.tool.dcmrcv.StgCmtSCP;
import org.dcm4che2.tool.dcmrcv.StorageSCP;
import org.dcm4che2.util.CloseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcmRcv {
    private static final int NO_SUCH_OBJECT_INSTANCE = 274;
    static Logger LOG = LoggerFactory.getLogger(DcmRcv.class);
    private static final int KB = 1024;
    private static final String USAGE = "dcmrcv [Options] [<aet>[@<ip>]:]<port>";
    private static final String DESCRIPTION = "DICOM Server listening on specified <port> for incoming association requests. If no local IP address of the network interface is specified connections on any/all local addresses are accepted. If <aet> is specified, only requests with matching called AE title will be accepted. If <aet> and a storage directory is specified by option -dest <dir>, also Storage Commitment requests will be accepted and processed.\n Options:";
    private static final String EXAMPLE = "\nExample: dcmrcv DCMRCV:11112 -dest /tmp \n=> Starts server listening on port 11112, accepting association requests with DCMRCV as called AE title. Received objects are stored to /tmp.";
    private static String[] TLS1 = new String[]{"TLSv1"};
    private static String[] SSL3 = new String[]{"SSLv3"};
    private static String[] NO_TLS1 = new String[]{"SSLv3", "SSLv2Hello"};
    private static String[] NO_SSL2 = new String[]{"TLSv1", "SSLv3"};
    private static String[] NO_SSL3 = new String[]{"TLSv1", "SSLv2Hello"};
    private static char[] SECRET = new char[]{'s', 'e', 'c', 'r', 'e', 't'};
    private static final String[] ONLY_DEF_TS = new String[]{"1.2.840.10008.1.2"};
    private static final String[] NATIVE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2"};
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] NON_RETIRED_TS = new String[]{"1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.5", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.100"};
    private static final String[] NON_RETIRED_LE_TS = new String[]{"1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.5", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.100"};
    private static final String[] CUIDS = new String[]{"1.2.840.10008.1.9", "1.2.840.10008.5.1.1.27", "1.2.840.10008.5.1.1.29", "1.2.840.10008.5.1.1.30", "1.2.840.10008.5.1.4.1.1.1", "1.2.840.10008.5.1.4.1.1.1.1", "1.2.840.10008.5.1.4.1.1.1.1.1", "1.2.840.10008.5.1.4.1.1.1.2", "1.2.840.10008.5.1.4.1.1.1.2.1", "1.2.840.10008.5.1.4.1.1.1.3", "1.2.840.10008.5.1.4.1.1.1.3.1", "1.2.840.10008.5.1.4.1.1.10", "1.2.840.10008.5.1.4.1.1.104.1", "1.2.840.10008.5.1.4.1.1.11", "1.2.840.10008.5.1.4.1.1.11.1", "1.2.840.10008.5.1.4.1.1.11.2", "1.2.840.10008.5.1.4.1.1.11.3", "1.2.840.10008.5.1.4.1.1.11.4", "1.2.840.10008.5.1.4.1.1.12.1", "1.2.840.10008.5.1.4.1.1.12.1.1", "1.2.840.10008.5.1.4.1.1.12.2", "1.2.840.10008.5.1.4.1.1.12.2.1", "1.2.840.10008.5.1.4.1.1.12.3", "1.2.840.10008.5.1.4.1.1.128", "1.2.840.10008.5.1.4.1.1.129", "1.2.840.10008.5.1.4.1.1.2", "1.2.840.10008.5.1.4.1.1.2.1", "1.2.840.10008.5.1.4.1.1.20", "1.2.840.10008.5.1.4.1.1.3", "1.2.840.10008.5.1.4.1.1.3.1", "1.2.840.10008.5.1.4.1.1.4", "1.2.840.10008.5.1.4.1.1.4.1", "1.2.840.10008.5.1.4.1.1.4.2", "1.2.840.10008.5.1.4.1.1.481.1", "1.2.840.10008.5.1.4.1.1.481.2", "1.2.840.10008.5.1.4.1.1.481.3", "1.2.840.10008.5.1.4.1.1.481.4", "1.2.840.10008.5.1.4.1.1.481.5", "1.2.840.10008.5.1.4.1.1.481.6", "1.2.840.10008.5.1.4.1.1.481.7", "1.2.840.10008.5.1.4.1.1.5", "1.2.840.10008.5.1.4.1.1.6", "1.2.840.10008.5.1.4.1.1.6.1", "1.2.840.10008.5.1.4.1.1.66", "1.2.840.10008.5.1.4.1.1.66.1", "1.2.840.10008.5.1.4.1.1.66.2", "1.2.840.10008.5.1.4.1.1.67", "1.2.840.10008.5.1.4.1.1.7", "1.2.840.10008.5.1.4.1.1.7.1", "1.2.840.10008.5.1.4.1.1.7.2", "1.2.840.10008.5.1.4.1.1.7.3", "1.2.840.10008.5.1.4.1.1.7.4", "1.2.840.10008.5.1.4.1.1.77.1", "1.2.840.10008.5.1.4.1.1.77.1.1", "1.2.840.10008.5.1.4.1.1.77.1.1.1", "1.2.840.10008.5.1.4.1.1.77.1.2", "1.2.840.10008.5.1.4.1.1.77.1.2.1", "1.2.840.10008.5.1.4.1.1.77.1.3", "1.2.840.10008.5.1.4.1.1.77.1.4", "1.2.840.10008.5.1.4.1.1.77.1.4.1", "1.2.840.10008.5.1.4.1.1.77.1.5.1", "1.2.840.10008.5.1.4.1.1.77.1.5.2", "1.2.840.10008.5.1.4.1.1.77.1.5.3", "1.2.840.10008.5.1.4.1.1.77.2", "1.2.840.10008.5.1.4.1.1.8", "1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33", "1.2.840.10008.5.1.4.1.1.88.40", "1.2.840.10008.5.1.4.1.1.88.50", "1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.5.1.4.1.1.88.65", "1.2.840.10008.5.1.4.1.1.88.67", "1.2.840.10008.5.1.4.1.1.104.1", "1.2.840.10008.5.1.4.1.1.104.2", "1.2.840.10008.5.1.4.1.1.9", "1.2.840.10008.5.1.4.1.1.9.1.1", "1.2.840.10008.5.1.4.1.1.9.1.2", "1.2.840.10008.5.1.4.1.1.9.1.3", "1.2.840.10008.5.1.4.1.1.9.2.1", "1.2.840.10008.5.1.4.1.1.9.3.1", "1.2.840.10008.5.1.4.1.1.9.4.1", "1.2.840.10008.5.1.4.38.1", "1.3.12.2.1107.5.9.1", "1.2.40.0.13.1.3.1.2.3.1.1"};
    private final String name;
    private Executor executor;
    protected Device device;
    private final NetworkApplicationEntity ae = new NetworkApplicationEntity();
    protected NetworkConnection nc;
    private final StorageSCP storageSCP = new StorageSCP(this, CUIDS);
    private final StgCmtSCP stgcmtSCP = new StgCmtSCP(this);
    private String[] tsuids = NON_RETIRED_LE_TS;
    private FileCache cache = new FileCache();
    private File devnull;
    private Properties calling2dir;
    private Properties called2dir;
    private String callingdefdir = "OTHER";
    private String calleddefdir = "OTHER";
    private int fileBufferSize = 1024;
    private int rspdelay = 0;
    private String keyStoreURL = "resource:tls/test_sys_2.p12";
    private char[] keyStorePassword = SECRET;
    private char[] keyPassword;
    private String trustStoreURL = "resource:tls/mesa_certs.jks";
    private char[] trustStorePassword = SECRET;
    private Timer stgcmtTimer;
    private boolean stgcmtReuseFrom = false;
    private boolean stgcmtReuseTo = false;
    private int stgcmtPort = 104;
    private long stgcmtDelay = 1000L;
    private int stgcmtRetry = 0;
    private long stgcmtRetryPeriod = 60000L;
    private String stgcmtRetrieveAET;
    private String stgcmtRetrieveAETs;
    private final DimseRSPHandler nEventReportRspHandler = new DimseRSPHandler();

    public DcmRcv() {
        this("DCMRCV");
    }

    public DcmRcv(String name) {
        this(name, true);
    }

    public DcmRcv(String name, boolean init) {
        this.name = name;
        if (init) {
            this.init();
        }
    }

    protected void init() {
        this.nc = this.createNetworkConnection();
        this.device = new Device(this.name);
        this.executor = new NewThreadExecutor(this.name);
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.nc);
        this.ae.setNetworkConnection(this.nc);
        this.ae.setAssociationAcceptor(true);
        this.ae.register((DicomService)new VerificationService());
        this.ae.register((DicomService)this.storageSCP);
        this.ae.register((DicomService)this.stgcmtSCP);
    }

    protected NetworkConnection createNetworkConnection() {
        return new NetworkConnection();
    }

    public final void setAEtitle(String aet) {
        this.ae.setAETitle(aet);
    }

    public final void setHostname(String hostname) {
        this.nc.setHostname(hostname);
    }

    public final void setPort(int port) {
        this.nc.setPort(port);
    }

    public final void setTlsProtocol(String[] tlsProtocol) {
        this.nc.setTlsProtocol(tlsProtocol);
    }

    public final void setTlsWithoutEncyrption() {
        this.nc.setTlsWithoutEncyrption();
    }

    public final void setTls3DES_EDE_CBC() {
        this.nc.setTls3DES_EDE_CBC();
    }

    public final void setTlsAES_128_CBC() {
        this.nc.setTlsAES_128_CBC();
    }

    public final void setTlsNeedClientAuth(boolean needClientAuth) {
        this.nc.setTlsNeedClientAuth(needClientAuth);
    }

    public final void setKeyStoreURL(String url) {
        this.keyStoreURL = url;
    }

    public final void setKeyStorePassword(String pw) {
        this.keyStorePassword = pw.toCharArray();
    }

    public final void setKeyPassword(String pw) {
        this.keyPassword = pw.toCharArray();
    }

    public final void setTrustStorePassword(String pw) {
        this.trustStorePassword = pw.toCharArray();
    }

    public final void setTrustStoreURL(String url) {
        this.trustStoreURL = url;
    }

    public final void setConnectTimeout(int connectTimeout) {
        this.nc.setConnectTimeout(connectTimeout);
    }

    public final void setPackPDV(boolean packPDV) {
        this.ae.setPackPDV(packPDV);
    }

    public final void setAssociationReaperPeriod(int period) {
        this.device.setAssociationReaperPeriod(period);
    }

    public final void setTcpNoDelay(boolean tcpNoDelay) {
        this.nc.setTcpNoDelay(tcpNoDelay);
    }

    public final void setAcceptTimeout(int timeout) {
        this.nc.setAcceptTimeout(timeout);
    }

    public final void setRequestTimeout(int timeout) {
        this.nc.setRequestTimeout(timeout);
    }

    public final void setReleaseTimeout(int timeout) {
        this.nc.setReleaseTimeout(timeout);
    }

    public final void setSocketCloseDelay(int delay) {
        this.nc.setSocketCloseDelay(delay);
    }

    public final void setIdleTimeout(int timeout) {
        this.ae.setIdleTimeout(timeout);
    }

    public final void setDimseRspTimeout(int timeout) {
        this.ae.setDimseRspTimeout(timeout);
    }

    public final void setMaxPDULengthSend(int maxLength) {
        this.ae.setMaxPDULengthSend(maxLength);
    }

    public void setMaxPDULengthReceive(int maxLength) {
        this.ae.setMaxPDULengthReceive(maxLength);
    }

    public final void setReceiveBufferSize(int bufferSize) {
        this.nc.setReceiveBufferSize(bufferSize);
    }

    public final void setSendBufferSize(int bufferSize) {
        this.nc.setSendBufferSize(bufferSize);
    }

    public final void setDimseRspDelay(int delay) {
        this.rspdelay = delay;
    }

    public final int getDimseRspDelay() {
        return this.rspdelay;
    }

    public final void setStgCmtReuseFrom(boolean stgcmtReuseFrom) {
        this.stgcmtReuseFrom = stgcmtReuseFrom;
    }

    public final boolean isStgCmtReuseFrom() {
        return this.stgcmtReuseFrom;
    }

    public final void setStgCmtReuseTo(boolean stgcmtReuseTo) {
        this.stgcmtReuseTo = stgcmtReuseTo;
    }

    public final boolean isStgCmtReuseTo() {
        return this.stgcmtReuseTo;
    }

    public final int getStgCmtPort() {
        return this.stgcmtPort;
    }

    public final void setStgCmtPort(int stgcmtPort) {
        this.stgcmtPort = stgcmtPort;
    }

    public final void setStgCmtDelay(long delay) {
        this.stgcmtDelay = delay;
    }

    public final long getStgCmtDelay() {
        return this.stgcmtDelay;
    }

    public final int getStgCmtRetry() {
        return this.stgcmtRetry;
    }

    public final void setStgCmtRetry(int stgcmtRetry) {
        this.stgcmtRetry = stgcmtRetry;
    }

    public final long getStgCmtRetryPeriod() {
        return this.stgcmtRetryPeriod;
    }

    public final void setStgCmtRetryPeriod(long stgcmtRetryPeriod) {
        this.stgcmtRetryPeriod = stgcmtRetryPeriod;
    }

    public final String getStgCmtRetrieveAET() {
        return this.stgcmtRetrieveAET;
    }

    public final void setStgCmtRetrieveAET(String aet) {
        this.stgcmtRetrieveAET = aet;
    }

    public final String getStgCmtRetrieveAETs() {
        return this.stgcmtRetrieveAETs;
    }

    public final void setStgCmtRetrieveAETs(String aet) {
        this.stgcmtRetrieveAETs = aet;
    }

    final Executor executor() {
        return this.executor;
    }

    private static CommandLine parse(String[] args) {
        Options opts = new Options();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set device name, use DCMRCV by default");
        opts.addOption(OptionBuilder.create((String)"device"));
        OptionBuilder.withArgName((String)"NULL|3DES|AES");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"enable TLS connection without, 3DES or AES encryption");
        opts.addOption(OptionBuilder.create((String)"tls"));
        OptionGroup tlsProtocol = new OptionGroup();
        tlsProtocol.addOption(new Option("tls1", "disable the use of SSLv3 and SSLv2 for TLS connections"));
        tlsProtocol.addOption(new Option("ssl3", "disable the use of TLSv1 and SSLv2 for TLS connections"));
        tlsProtocol.addOption(new Option("no_tls1", "disable the use of TLSv1 for TLS connections"));
        tlsProtocol.addOption(new Option("no_ssl3", "disable the use of SSLv3 for TLS connections"));
        tlsProtocol.addOption(new Option("no_ssl2", "disable the use of SSLv2 for TLS connections"));
        opts.addOptionGroup(tlsProtocol);
        opts.addOption("noclientauth", false, "disable client authentification for TLS");
        OptionBuilder.withArgName((String)"file|url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"file path or URL of P12 or JKS keystore, resource:tls/test_sys_2.p12 by default");
        opts.addOption(OptionBuilder.create((String)"keystore"));
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"password for keystore file, 'secret' by default");
        opts.addOption(OptionBuilder.create((String)"keystorepw"));
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"password for accessing the key in the keystore, keystore password by default");
        opts.addOption(OptionBuilder.create((String)"keypw"));
        OptionBuilder.withArgName((String)"file|url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"file path or URL of JKS truststore, resource:tls/mesa_certs.jks by default");
        opts.addOption(OptionBuilder.create((String)"truststore"));
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"password for truststore file, 'secret' by default");
        opts.addOption(OptionBuilder.create((String)"truststorepw"));
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"store received objects into files in specified directory <dir>. Do not store received objects by default.");
        opts.addOption(OptionBuilder.create((String)"dest"));
        OptionBuilder.withArgName((String)"file|url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"file path or URL of properties for mapping Calling AETs to sub-directories of the storage directory specified by -dest, to separate the storage location dependend on Calling AETs.");
        opts.addOption(OptionBuilder.create((String)"calling2dir"));
        OptionBuilder.withArgName((String)"file|url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"file path or URL of properties for mapping Called AETs to sub-directories of the storage directory specified by -dest, to separate the storage location dependend on Called AETs.");
        opts.addOption(OptionBuilder.create((String)"called2dir"));
        OptionBuilder.withArgName((String)"sub-dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"storage sub-directory used for Calling AETs for which no  mapping is defined by properties specified by -calling2dir, 'OTHER' by default.");
        opts.addOption(OptionBuilder.create((String)"callingdefdir"));
        OptionBuilder.withArgName((String)"sub-dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"storage sub-directory used for Called AETs for which no  mapping is defined by properties specified by -called2dir, 'OTHER' by default.");
        opts.addOption(OptionBuilder.create((String)"calleddefdir"));
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"register stored objects in cache journal files in specified directory <dir>. Do not register stored objects by default.");
        opts.addOption(OptionBuilder.create((String)"journal"));
        OptionBuilder.withArgName((String)"pattern");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"cache journal file path, with 'yyyy' will be replaced by the current year, 'MM' by the current month, 'dd' by the current date, 'HH' by the current hour and 'mm' by the current minute. 'yyyy/MM/dd/HH/mm' by default.");
        opts.addOption(OptionBuilder.create((String)"journalfilepath"));
        opts.addOption("defts", false, "accept only default transfer syntax.");
        opts.addOption("bigendian", false, "accept also Explict VR Big Endian transfer syntax.");
        opts.addOption("native", false, "accept only transfer syntax with uncompressed pixel data.");
        OptionGroup scRetrieveAET = new OptionGroup();
        OptionBuilder.withArgName((String)"aet");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Retrieve AE Title included in Storage Commitment N-EVENT-REPORT in items of the Referenced SOP Sequence.");
        scRetrieveAET.addOption(OptionBuilder.create((String)"scretraets"));
        OptionBuilder.withArgName((String)"aet");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Retrieve AE Title included in Storage Commitment N-EVENT-REPORT outside of the Referenced SOP Sequence.");
        scRetrieveAET.addOption(OptionBuilder.create((String)"scretraet"));
        opts.addOptionGroup(scRetrieveAET);
        opts.addOption("screusefrom", false, "attempt to issue the Storage Commitment N-EVENT-REPORT on the same Association on which the N-ACTION operation was performed; use different Association for N-EVENT-REPORT by default.");
        opts.addOption("screuseto", false, "attempt to issue the Storage Commitment N-EVENT-REPORT on previous initiated Association to the Storage Commitment SCU; initiate new Association for N-EVENT-REPORT by default.");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"port of Storage Commitment SCU to connect to issue N-EVENT-REPORT on different Association; 104 by default.");
        opts.addOption(OptionBuilder.create((String)"scport"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delay in ms for N-EVENT-REPORT-RQ to Storage Commitment SCU, 1s by default");
        opts.addOption(OptionBuilder.create((String)"scdelay"));
        OptionBuilder.withArgName((String)"retry");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of retries to issue N-EVENT-REPORT-RQ to Storage Commitment SCU, 0 by default");
        opts.addOption(OptionBuilder.create((String)"scretry"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"interval im ms between retries to issue N-EVENT-REPORT-RQ toStorage Commitment SCU, 60s by default");
        opts.addOption(OptionBuilder.create((String)"scretryperiod"));
        OptionBuilder.withArgName((String)"maxops");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximum number of outstanding operations performed asynchronously, unlimited by default.");
        opts.addOption(OptionBuilder.create((String)"async"));
        opts.addOption("pdv1", false, "send only one PDV in one P-Data-TF PDU, pack command and data PDV in one P-DATA-TF PDU by default.");
        opts.addOption("tcpdelay", false, "set TCP_NODELAY socket option to false, true by default");
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for TCP connect, no timeout by default");
        opts.addOption(OptionBuilder.create((String)"connectTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving DIMSE-RSP, 10s by default");
        opts.addOption(OptionBuilder.create((String)"rspTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving A-ASSOCIATE-AC, 5s by default");
        opts.addOption(OptionBuilder.create((String)"acceptTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delay in ms for Socket close after sending A-ABORT, 50ms by default");
        opts.addOption(OptionBuilder.create((String)"soclosedelay"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delay in ms for DIMSE-RSP; useful for testing asynchronous mode");
        opts.addOption(OptionBuilder.create((String)"rspdelay"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving -ASSOCIATE-RQ, 5s by default");
        opts.addOption(OptionBuilder.create((String)"requestTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving A-RELEASE-RP, 5s by default");
        opts.addOption(OptionBuilder.create((String)"releaseTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"period in ms to check for outstanding DIMSE-RSP, 10s by default");
        opts.addOption(OptionBuilder.create((String)"reaper"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving DIMSE-RQ, 60s by default");
        opts.addOption(OptionBuilder.create((String)"idleTO"));
        OptionBuilder.withArgName((String)"KB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximal length in KB of received P-DATA-TF PDUs, 16KB by default");
        opts.addOption(OptionBuilder.create((String)"rcvpdulen"));
        OptionBuilder.withArgName((String)"KB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximal length in KB of sent P-DATA-TF PDUs, 16KB by default");
        opts.addOption(OptionBuilder.create((String)"sndpdulen"));
        OptionBuilder.withArgName((String)"KB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set SO_RCVBUF socket option to specified value in KB");
        opts.addOption(OptionBuilder.create((String)"sorcvbuf"));
        OptionBuilder.withArgName((String)"KB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set SO_SNDBUF socket option to specified value in KB");
        opts.addOption(OptionBuilder.create((String)"sosndbuf"));
        OptionBuilder.withArgName((String)"KB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"minimal buffer size to write received object to file, 1KB by default");
        opts.addOption(OptionBuilder.create((String)"bufsize"));
        opts.addOption("h", "help", false, "print this message");
        opts.addOption("V", "version", false, "print the version information and exit");
        CommandLine cl = null;
        try {
            cl = new GnuParser().parse(opts, args);
        }
        catch (ParseException e) {
            DcmRcv.exit("dcmrcv: " + e.getMessage());
            throw new RuntimeException("unreachable");
        }
        if (cl.hasOption("V")) {
            Package p = DcmRcv.class.getPackage();
            System.out.println("dcmrcv v" + p.getImplementationVersion());
            System.exit(0);
        }
        if (cl.hasOption("h") || cl.getArgList().size() == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(USAGE, DESCRIPTION, opts, EXAMPLE);
            System.exit(0);
        }
        return cl;
    }

    public static void main(String[] args) {
        CommandLine cl = DcmRcv.parse(args);
        DcmRcv dcmrcv = new DcmRcv(cl.hasOption("device") ? cl.getOptionValue("device") : "DCMRCV");
        List argList = cl.getArgList();
        String port = (String)argList.get(0);
        String[] aetPort = DcmRcv.split(port, ':', 1);
        dcmrcv.setPort(DcmRcv.parseInt(aetPort[1], "illegal port number", 1, 65535));
        if (aetPort[0] != null) {
            String[] aetHost = DcmRcv.split(aetPort[0], '@', 0);
            dcmrcv.setAEtitle(aetHost[0]);
            if (aetHost[1] != null) {
                dcmrcv.setHostname(aetHost[1]);
            }
        }
        if (cl.hasOption("dest")) {
            dcmrcv.setDestination(cl.getOptionValue("dest"));
        }
        if (cl.hasOption("calling2dir")) {
            dcmrcv.setCalling2Dir(DcmRcv.loadProperties(cl.getOptionValue("calling2dir")));
        }
        if (cl.hasOption("called2dir")) {
            dcmrcv.setCalled2Dir(DcmRcv.loadProperties(cl.getOptionValue("called2dir")));
        }
        if (cl.hasOption("callingdefdir")) {
            dcmrcv.setCallingDefDir(cl.getOptionValue("callingdefdir"));
        }
        if (cl.hasOption("calleddefdir")) {
            dcmrcv.setCalledDefDir(cl.getOptionValue("calleddefdir"));
        }
        if (cl.hasOption("journal")) {
            dcmrcv.setJournal(cl.getOptionValue("journal"));
        }
        if (cl.hasOption("journalfilepath")) {
            dcmrcv.setJournalFilePathFormat(cl.getOptionValue("journalfilepath"));
        }
        if (cl.hasOption("defts")) {
            dcmrcv.setTransferSyntax(ONLY_DEF_TS);
        } else if (cl.hasOption("native")) {
            dcmrcv.setTransferSyntax(cl.hasOption("bigendian") ? NATIVE_TS : NATIVE_LE_TS);
        } else if (cl.hasOption("bigendian")) {
            dcmrcv.setTransferSyntax(NON_RETIRED_TS);
        }
        if (cl.hasOption("scretraets")) {
            dcmrcv.setStgCmtRetrieveAETs(cl.getOptionValue("scretraets"));
        }
        if (cl.hasOption("scretraet")) {
            dcmrcv.setStgCmtRetrieveAET(cl.getOptionValue("scretraet"));
        }
        dcmrcv.setStgCmtReuseFrom(cl.hasOption("screusefrom"));
        dcmrcv.setStgCmtReuseTo(cl.hasOption("screuseto"));
        if (cl.hasOption("scport")) {
            dcmrcv.setStgCmtPort(DcmRcv.parseInt(cl.getOptionValue("scport"), "illegal port number", 1, 65535));
        }
        if (cl.hasOption("scdelay")) {
            dcmrcv.setStgCmtDelay(DcmRcv.parseInt(cl.getOptionValue("scdelay"), "illegal argument of option -scdelay", 0, Integer.MAX_VALUE));
        }
        if (cl.hasOption("scretry")) {
            dcmrcv.setStgCmtRetry(DcmRcv.parseInt(cl.getOptionValue("scretry"), "illegal argument of option -scretry", 0, Integer.MAX_VALUE));
        }
        if (cl.hasOption("scretryperiod")) {
            dcmrcv.setStgCmtRetryPeriod(DcmRcv.parseInt(cl.getOptionValue("scretryperiod"), "illegal argument of option -scretryperiod", 1000, Integer.MAX_VALUE));
        }
        if (cl.hasOption("connectTO")) {
            dcmrcv.setConnectTimeout(DcmRcv.parseInt(cl.getOptionValue("connectTO"), "illegal argument of option -connectTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("reaper")) {
            dcmrcv.setAssociationReaperPeriod(DcmRcv.parseInt(cl.getOptionValue("reaper"), "illegal argument of option -reaper", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("rspTO")) {
            dcmrcv.setDimseRspTimeout(DcmRcv.parseInt(cl.getOptionValue("rspTO"), "illegal argument of option -rspTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("acceptTO")) {
            dcmrcv.setAcceptTimeout(DcmRcv.parseInt(cl.getOptionValue("acceptTO"), "illegal argument of option -acceptTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("idleTO")) {
            dcmrcv.setIdleTimeout(DcmRcv.parseInt(cl.getOptionValue("idleTO"), "illegal argument of option -idleTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("requestTO")) {
            dcmrcv.setRequestTimeout(DcmRcv.parseInt(cl.getOptionValue("requestTO"), "illegal argument of option -requestTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("releaseTO")) {
            dcmrcv.setReleaseTimeout(DcmRcv.parseInt(cl.getOptionValue("releaseTO"), "illegal argument of option -releaseTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("soclosedelay")) {
            dcmrcv.setSocketCloseDelay(DcmRcv.parseInt(cl.getOptionValue("soclosedelay"), "illegal argument of option -soclosedelay", 1, 10000));
        }
        if (cl.hasOption("rspdelay")) {
            dcmrcv.setDimseRspDelay(DcmRcv.parseInt(cl.getOptionValue("rspdelay"), "illegal argument of option -rspdelay", 0, 10000));
        }
        if (cl.hasOption("rcvpdulen")) {
            dcmrcv.setMaxPDULengthReceive(DcmRcv.parseInt(cl.getOptionValue("rcvpdulen"), "illegal argument of option -rcvpdulen", 1, 10000) * 1024);
        }
        if (cl.hasOption("sndpdulen")) {
            dcmrcv.setMaxPDULengthSend(DcmRcv.parseInt(cl.getOptionValue("sndpdulen"), "illegal argument of option -sndpdulen", 1, 10000) * 1024);
        }
        if (cl.hasOption("sosndbuf")) {
            dcmrcv.setSendBufferSize(DcmRcv.parseInt(cl.getOptionValue("sosndbuf"), "illegal argument of option -sosndbuf", 1, 10000) * 1024);
        }
        if (cl.hasOption("sorcvbuf")) {
            dcmrcv.setReceiveBufferSize(DcmRcv.parseInt(cl.getOptionValue("sorcvbuf"), "illegal argument of option -sorcvbuf", 1, 10000) * 1024);
        }
        if (cl.hasOption("bufsize")) {
            dcmrcv.setFileBufferSize(DcmRcv.parseInt(cl.getOptionValue("bufsize"), "illegal argument of option -bufsize", 1, 10000) * 1024);
        }
        dcmrcv.setPackPDV(!cl.hasOption("pdv1"));
        dcmrcv.setTcpNoDelay(!cl.hasOption("tcpdelay"));
        if (cl.hasOption("async")) {
            dcmrcv.setMaxOpsPerformed(DcmRcv.parseInt(cl.getOptionValue("async"), "illegal argument of option -async", 0, 65535));
        }
        dcmrcv.initTransferCapability();
        if (cl.hasOption("tls")) {
            String cipher = cl.getOptionValue("tls");
            if ("NULL".equalsIgnoreCase(cipher)) {
                dcmrcv.setTlsWithoutEncyrption();
            } else if ("3DES".equalsIgnoreCase(cipher)) {
                dcmrcv.setTls3DES_EDE_CBC();
            } else if ("AES".equalsIgnoreCase(cipher)) {
                dcmrcv.setTlsAES_128_CBC();
            } else {
                DcmRcv.exit("Invalid parameter for option -tls: " + cipher);
            }
            if (cl.hasOption("tls1")) {
                dcmrcv.setTlsProtocol(TLS1);
            } else if (cl.hasOption("ssl3")) {
                dcmrcv.setTlsProtocol(SSL3);
            } else if (cl.hasOption("no_tls1")) {
                dcmrcv.setTlsProtocol(NO_TLS1);
            } else if (cl.hasOption("no_ssl3")) {
                dcmrcv.setTlsProtocol(NO_SSL3);
            } else if (cl.hasOption("no_ssl2")) {
                dcmrcv.setTlsProtocol(NO_SSL2);
            }
            dcmrcv.setTlsNeedClientAuth(!cl.hasOption("noclientauth"));
            if (cl.hasOption("keystore")) {
                dcmrcv.setKeyStoreURL(cl.getOptionValue("keystore"));
            }
            if (cl.hasOption("keystorepw")) {
                dcmrcv.setKeyStorePassword(cl.getOptionValue("keystorepw"));
            }
            if (cl.hasOption("keypw")) {
                dcmrcv.setKeyPassword(cl.getOptionValue("keypw"));
            }
            if (cl.hasOption("truststore")) {
                dcmrcv.setTrustStoreURL(cl.getOptionValue("truststore"));
            }
            if (cl.hasOption("truststorepw")) {
                dcmrcv.setTrustStorePassword(cl.getOptionValue("truststorepw"));
            }
            try {
                dcmrcv.initTLS();
            }
            catch (Exception e) {
                System.err.println("ERROR: Failed to initialize TLS context:" + e.getMessage());
                System.exit(2);
            }
        }
        try {
            dcmrcv.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setTransferSyntax(String[] tsuids) {
        this.tsuids = tsuids;
    }

    public void initTransferCapability() {
        TransferCapability[] tc;
        if (this.isStgcmtEnabled()) {
            tc = new TransferCapability[CUIDS.length + 2];
            tc[tc.length - 1] = new TransferCapability("1.2.840.10008.1.20.1", ONLY_DEF_TS, "SCP");
        } else {
            tc = new TransferCapability[CUIDS.length + 1];
        }
        tc[0] = new TransferCapability("1.2.840.10008.1.1", ONLY_DEF_TS, "SCP");
        for (int i = 0; i < CUIDS.length; ++i) {
            tc[i + 1] = new TransferCapability(CUIDS[i], this.tsuids, "SCP");
        }
        this.ae.setTransferCapability(tc);
    }

    public void setFileBufferSize(int size) {
        this.fileBufferSize = size;
    }

    public void setMaxOpsPerformed(int maxOps) {
        this.ae.setMaxOpsPerformed(maxOps);
    }

    public void setDestination(String filePath) {
        File f = new File(filePath);
        if ("/dev/null".equals(filePath)) {
            this.devnull = f;
            this.cache.setCacheRootDir(null);
        } else {
            this.devnull = null;
            this.cache.setCacheRootDir(f);
        }
    }

    public void setCalling2Dir(Properties calling2dir) {
        this.calling2dir = calling2dir;
    }

    public void setCalled2Dir(Properties called2dir) {
        this.called2dir = called2dir;
    }

    private static Properties loadProperties(String url) {
        Properties props = new Properties();
        try (InputStream inStream = DcmRcv.openFileOrURL(url);){
            props.load(inStream);
        }
        catch (Exception e) {
            DcmRcv.exit("Failed to load properties from " + url);
        }
        return props;
    }

    public void setCallingDefDir(String callingdefdir) {
        this.callingdefdir = callingdefdir;
    }

    public void setCalledDefDir(String calleddefdir) {
        this.calleddefdir = calleddefdir;
    }

    public void setJournal(String journalRootDir) {
        this.cache.setJournalRootDir(new File(journalRootDir));
        this.cache.setJournalFileName("DcmRcv." + this.cache.getJournalFileName());
    }

    public void setJournalFilePathFormat(String format) {
        this.cache.setJournalFilePathFormat(format);
    }

    public void initTLS() throws GeneralSecurityException, IOException {
        KeyStore keyStore = DcmRcv.loadKeyStore(this.keyStoreURL, this.keyStorePassword);
        KeyStore trustStore = DcmRcv.loadKeyStore(this.trustStoreURL, this.trustStorePassword);
        this.device.initTLS(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword, trustStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String url, char[] password) throws GeneralSecurityException, IOException {
        KeyStore key = KeyStore.getInstance(DcmRcv.toKeyStoreType(url));
        try (InputStream in = DcmRcv.openFileOrURL(url);){
            key.load(in, password);
        }
        return key;
    }

    private static InputStream openFileOrURL(String url) throws IOException {
        if (url.startsWith("resource:")) {
            return DcmRcv.class.getClassLoader().getResourceAsStream(url.substring(9));
        }
        try {
            return new URL(url).openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(url);
        }
    }

    private static String toKeyStoreType(String fname) {
        return fname.endsWith(".p12") || fname.endsWith(".P12") ? "PKCS12" : "JKS";
    }

    public void start() throws IOException {
        this.device.startListening(this.executor);
        System.out.println("Start Server listening on port " + this.nc.getPort());
    }

    public void stop() {
        if (this.device != null) {
            this.device.stopListening();
        }
        if (this.nc != null) {
            System.out.println("Stop Server listening on port " + this.nc.getPort());
        } else {
            System.out.println("Stop Server");
        }
    }

    private static String[] split(String s, char delim, int defPos) {
        String[] s2 = new String[2];
        s2[defPos] = s;
        int pos = s.indexOf(delim);
        if (pos != -1) {
            s2[0] = s.substring(0, pos);
            s2[1] = s.substring(pos + 1);
        }
        return s2;
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.err.println("Try 'dcmrcv -h' for more information.");
        System.exit(1);
    }

    private static int parseInt(String s, String errPrompt, int min, int max) {
        try {
            int i = Integer.parseInt(s);
            if (i >= min && i <= max) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DcmRcv.exit(errPrompt);
        throw new RuntimeException();
    }

    boolean isStoreFile() {
        return this.devnull != null || this.cache.getCacheRootDir() != null;
    }

    private boolean isStgcmtEnabled() {
        return this.ae.getAETitle() != null && this.cache.getCacheRootDir() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCStoreRQ(Association as, int pcid, DicomObject rq, PDVInputStream dataStream, String tsuid, DicomObject rsp) throws IOException {
        String cuid = rq.getString(2);
        String iuid = rq.getString(4096);
        File file = this.devnull != null ? this.devnull : new File(this.mkDir(as), FilenameUtils.normalize((String)(iuid + ".part")));
        LOG.info("M-WRITE {}", (Object)file);
        try {
            DicomOutputStream dos = new DicomOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file), this.fileBufferSize));
            try {
                BasicDicomObject fmi = new BasicDicomObject();
                fmi.initFileMetaInformation(cuid, iuid, tsuid);
                dos.writeFileMetaInformation((DicomObject)fmi);
                dataStream.copyTo((OutputStream)dos);
            }
            finally {
                CloseUtils.safeClose((Closeable)dos);
            }
        }
        catch (IOException e) {
            if (this.devnull == null && file != null && file.delete()) {
                LOG.info("M-DELETE {}", (Object)file);
            }
            throw new DicomServiceException(rq, 272, e.getMessage());
        }
        if (this.devnull == null && file != null) {
            File rename = new File(file.getParent(), FilenameUtils.normalize((String)iuid));
            LOG.info("M-RENAME {} to {}", (Object)file, (Object)rename);
            file.renameTo(rename);
            if (this.cache.getJournalRootDir() != null) {
                this.cache.record(rename);
            }
        }
    }

    private File getDir(Association as) {
        File dir = this.cache.getCacheRootDir();
        if (this.called2dir != null) {
            dir = new File(dir, this.called2dir.getProperty(as.getCalledAET(), this.calleddefdir));
        }
        if (this.calling2dir != null) {
            dir = new File(dir, this.calling2dir.getProperty(as.getCallingAET(), this.callingdefdir));
        }
        return dir;
    }

    private File mkDir(Association as) {
        File dir = this.getDir(as);
        if (dir.mkdirs()) {
            LOG.info("M-WRITE {}", (Object)dir);
        }
        return dir;
    }

    public void onNActionRQ(Association as, DicomObject rq, DicomObject info) {
        this.stgcmtTimer().schedule((TimerTask)new SendStgCmtResult(this, this.mkStgCmtAE(as), this.mkStgCmtResult(as, info)), this.stgcmtDelay, this.stgcmtRetryPeriod);
    }

    private NetworkApplicationEntity mkStgCmtAE(Association as) {
        NetworkApplicationEntity stgcmtAE = new NetworkApplicationEntity();
        NetworkConnection stgcmtNC = new NetworkConnection();
        stgcmtNC.setHostname(as.getSocket().getInetAddress().getHostAddress());
        stgcmtNC.setPort(this.stgcmtPort);
        stgcmtNC.setTlsCipherSuite(this.nc.getTlsCipherSuite());
        stgcmtAE.setNetworkConnection(stgcmtNC);
        stgcmtAE.setAETitle(as.getRemoteAET());
        stgcmtAE.setTransferCapability(new TransferCapability[]{new TransferCapability("1.2.840.10008.1.20.1", ONLY_DEF_TS, "SCU")});
        return stgcmtAE;
    }

    private DicomObject mkStgCmtResult(Association as, DicomObject rqdata) {
        BasicDicomObject result = new BasicDicomObject();
        result.putString(528789, VR.UI, rqdata.getString(528789));
        DicomElement rqsq = rqdata.get(528793);
        DicomElement resultsq = result.putSequence(528793);
        if (this.stgcmtRetrieveAET != null) {
            result.putString(524372, VR.AE, this.stgcmtRetrieveAET);
        }
        DicomElement failedsq = null;
        File dir = this.getDir(as);
        int n = rqsq.countItems();
        for (int i = 0; i < n; ++i) {
            File f;
            DicomObject rqItem = rqsq.getDicomObject(i);
            String uid = rqItem.getString(528725);
            BasicDicomObject resultItem = new BasicDicomObject();
            rqItem.copyTo((DicomObject)resultItem);
            if (this.stgcmtRetrieveAETs != null) {
                resultItem.putString(524372, VR.AE, this.stgcmtRetrieveAETs);
            }
            if ((f = new File(dir, FilenameUtils.normalize((String)uid))).isFile()) {
                resultsq.addDicomObject((DicomObject)resultItem);
                continue;
            }
            resultItem.putInt(528791, VR.US, 274);
            if (failedsq == null) {
                failedsq = result.putSequence(528792);
            }
            failedsq.addDicomObject((DicomObject)resultItem);
        }
        return result;
    }

    private synchronized Timer stgcmtTimer() {
        if (this.stgcmtTimer == null) {
            this.stgcmtTimer = new Timer("SendStgCmtResult", true);
        }
        return this.stgcmtTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendStgCmtResult(NetworkApplicationEntity stgcmtAE, DicomObject result) throws Exception {
        NetworkApplicationEntity networkApplicationEntity = this.ae;
        synchronized (networkApplicationEntity) {
            String[] stringArray;
            String[] stringArray2;
            if (this.stgcmtReuseFrom) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = stgcmtAE.getAETitle();
            } else {
                stringArray2 = new String[]{};
            }
            this.ae.setReuseAssocationFromAETitle(stringArray2);
            if (this.stgcmtReuseTo) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = stgcmtAE.getAETitle();
            } else {
                stringArray = new String[]{};
            }
            this.ae.setReuseAssocationToAETitle(stringArray);
            Association as = this.ae.connect(stgcmtAE, this.executor);
            as.nevent("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", DcmRcv.eventTypeIdOf(result), result, "1.2.840.10008.1.2", this.nEventReportRspHandler);
            if (!this.stgcmtReuseFrom && !this.stgcmtReuseTo) {
                as.release(true);
            }
        }
    }

    private static int eventTypeIdOf(DicomObject result) {
        return result.contains(524376) ? 2 : 1;
    }
}

