/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.css;

import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.rsta.ac.css.CssCellRenderer;
import org.fife.rsta.ac.css.CssCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class CssLanguageSupport
extends AbstractLanguageSupport {
    private CssCompletionProvider provider;

    public CssLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setAutoActivationDelay(500);
        this.setParameterAssistanceEnabled(true);
    }

    protected ListCellRenderer createDefaultCompletionCellRenderer() {
        return new CssCellRenderer();
    }

    private CssCompletionProvider getProvider() {
        if (this.provider == null) {
            this.provider = new CssCompletionProvider();
        }
        return this.provider;
    }

    public void install(RSyntaxTextArea textArea) {
        CssCompletionProvider provider = this.getProvider();
        AutoCompletion ac = this.createAutoCompletion((CompletionProvider)provider);
        ac.install((JTextComponent)textArea);
        this.installImpl(textArea, ac);
        textArea.setToolTipSupplier((ToolTipSupplier)provider);
    }

    public void uninstall(RSyntaxTextArea textArea) {
        this.uninstallImpl(textArea);
        textArea.setToolTipSupplier(null);
    }
}

