/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.concurrent;

import ca.uhn.hl7v2.concurrent.BlockingMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class BlockingHashMap<K, V>
implements BlockingMap<K, V> {
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();
    private final ConcurrentMap<K, CountDownLatch> latches = new ConcurrentHashMap<K, CountDownLatch>();
    private final ExecutorService executor;

    public BlockingHashMap() {
        this(Executors.newCachedThreadPool());
    }

    public BlockingHashMap(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        V result = this.map.put(key, value);
        this.latchFor(key).countDown();
        return result;
    }

    @Override
    public synchronized boolean give(K key, V value) {
        if (!this.latches.containsKey(key)) {
            return false;
        }
        this.put(key, value);
        return true;
    }

    @Override
    public V take(K key) throws InterruptedException {
        this.latchFor(key).await();
        this.latches.remove(key);
        return this.map.remove(key);
    }

    @Override
    public Future<V> asyncTake(final K key) throws InterruptedException {
        this.latchFor(key);
        return this.executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return BlockingHashMap.this.take(key);
            }
        });
    }

    @Override
    public V poll(K key, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.latchFor(key).await(timeout, unit)) {
            this.latches.remove(key);
            return this.map.remove(key);
        }
        return null;
    }

    @Override
    public Future<V> asyncPoll(final K key, final long timeout, final TimeUnit unit) {
        this.latchFor(key);
        return this.executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return BlockingHashMap.this.poll(key, timeout, unit);
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public synchronized V remove(Object key) {
        Object result = this.map.remove(key);
        CountDownLatch latch = (CountDownLatch)this.latches.remove(key);
        if (latch != null) {
            latch.countDown();
        }
        return result;
    }

    @Override
    public void clear() {
        for (Object key : this.latches.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    private synchronized CountDownLatch latchFor(K key) {
        CountDownLatch latch = (CountDownLatch)this.latches.get(key);
        if (latch == null) {
            latch = new CountDownLatch(1);
            this.latches.put(key, latch);
        }
        return latch;
    }
}

