/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.engine;

public class ZipCryptoEngine {
    private final int[] keys = new int[3];
    private static final int[] CRC_TABLE = new int[256];

    public void initKeys(char[] cArray) {
        this.keys[0] = 305419896;
        this.keys[1] = 591751049;
        this.keys[2] = 878082192;
        for (int i = 0; i < cArray.length; ++i) {
            this.updateKeys((byte)(cArray[i] & 0xFF));
        }
    }

    public void updateKeys(byte by) {
        this.keys[0] = this.crc32(this.keys[0], by);
        this.keys[1] = this.keys[1] + (this.keys[0] & 0xFF);
        this.keys[1] = this.keys[1] * 134775813 + 1;
        this.keys[2] = this.crc32(this.keys[2], (byte)(this.keys[1] >> 24));
    }

    private int crc32(int n, byte by) {
        return n >>> 8 ^ CRC_TABLE[(n ^ by) & 0xFF];
    }

    public byte decryptByte() {
        int n = this.keys[2] | 2;
        return (byte)(n * (n ^ 1) >>> 8);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) == 1) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            ZipCryptoEngine.CRC_TABLE[i] = n;
        }
    }
}

