/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lingala.zip4j.io.PartInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public class InflaterInputStream
extends PartInputStream {
    private Inflater inflater;
    private byte[] buff;
    private byte[] oneByteBuff = new byte[1];
    private UnzipEngine unzipEngine;
    private long bytesWritten;
    private long uncompressedSize;

    public InflaterInputStream(RandomAccessFile randomAccessFile, long l, long l2, UnzipEngine unzipEngine) {
        super(randomAccessFile, l, l2, unzipEngine);
        this.inflater = new Inflater(true);
        this.buff = new byte[4096];
        this.unzipEngine = unzipEngine;
        this.bytesWritten = 0L;
        this.uncompressedSize = unzipEngine.getFileHeader().getUncompressedSize();
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByteBuff, 0, 1) == -1 ? -1 : this.oneByteBuff[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("input buffer is null");
        }
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("input buffer is null");
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3;
            if (this.bytesWritten >= this.uncompressedSize) {
                this.finishInflating();
                return -1;
            }
            while ((n3 = this.inflater.inflate(byArray, n, n2)) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    this.finishInflating();
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fill();
            }
            this.bytesWritten += (long)n3;
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            String string = "Invalid ZLIB data format";
            if (dataFormatException.getMessage() != null) {
                string = dataFormatException.getMessage();
            }
            if (this.unzipEngine != null && this.unzipEngine.getLocalFileHeader().isEncrypted() && this.unzipEngine.getLocalFileHeader().getEncryptionMethod() == 0) {
                string = string + " - Wrong Password?";
            }
            throw new IOException(string);
        }
    }

    private void finishInflating() throws IOException {
        byte[] byArray = new byte[1024];
        while (super.read(byArray, 0, 1024) != -1) {
        }
        this.checkAndReadAESMacBytes();
    }

    private void fill() throws IOException {
        int n = super.read(this.buff, 0, this.buff.length);
        if (n == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inflater.setInput(this.buff, 0, n);
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        int n2;
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        int n3 = (int)Math.min(l, Integer.MAX_VALUE);
        byte[] byArray = new byte[512];
        for (n = 0; n < n3; n += n2) {
            n2 = n3 - n;
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            if ((n2 = this.read(byArray, 0, n2)) == -1) break;
        }
        return n;
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(l);
    }

    @Override
    public int available() {
        return this.inflater.finished() ? 0 : 1;
    }

    @Override
    public void close() throws IOException {
        this.inflater.end();
        super.close();
    }

    @Override
    public UnzipEngine getUnzipEngine() {
        return super.getUnzipEngine();
    }
}

