/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import net.lingala.zip4j.core.HeaderReader;
import net.lingala.zip4j.core.HeaderWriter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class ArchiveMaintainer {
    public HashMap removeZipFile(final ZipModel zipModel, final FileHeader fileHeader, final ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (bl) {
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ArchiveMaintainer.this.initRemoveZipFile(zipModel, fileHeader, progressMonitor);
                        progressMonitor.endProgressMonitorSuccess();
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            return null;
        }
        HashMap hashMap = this.initRemoveZipFile(zipModel, fileHeader, progressMonitor);
        progressMonitor.endProgressMonitorSuccess();
        return hashMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap initRemoveZipFile(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        long l;
        long l2;
        int n;
        HashMap<String, String> hashMap;
        String string;
        boolean bl;
        RandomAccessFile randomAccessFile;
        File file;
        OutputStream outputStream;
        block42: {
            FileHeader fileHeader2;
            ArrayList arrayList;
            if (fileHeader == null) throw new ZipException("input parameters is null in maintain zip file, cannot remove file from archive");
            if (zipModel == null) {
                throw new ZipException("input parameters is null in maintain zip file, cannot remove file from archive");
            }
            outputStream = null;
            file = null;
            randomAccessFile = null;
            bl = false;
            string = null;
            hashMap = new HashMap<String, String>();
            n = Zip4jUtil.getIndexOfFileHeader(zipModel, fileHeader);
            if (n < 0) {
                throw new ZipException("file header not found in zip model, cannot remove file");
            }
            if (zipModel.isSplitArchive()) {
                throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
            }
            long l3 = System.currentTimeMillis();
            string = zipModel.getZipFile() + l3 % 1000L;
            File file2 = new File(string);
            while (file2.exists()) {
                l3 = System.currentTimeMillis();
                string = zipModel.getZipFile() + l3 % 1000L;
                file2 = new File(string);
            }
            try {
                outputStream = new SplitOutputStream(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ZipException(fileNotFoundException);
            }
            file = new File(zipModel.getZipFile());
            randomAccessFile = this.createFileHandler(zipModel, "r");
            HeaderReader headerReader = new HeaderReader(randomAccessFile);
            LocalFileHeader localFileHeader = headerReader.readLocalFileHeader(fileHeader);
            if (localFileHeader == null) {
                throw new ZipException("invalid local file header, cannot remove file from archive");
            }
            l2 = fileHeader.getOffsetLocalHeader();
            if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                l2 = fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader();
            }
            l = -1L;
            long l4 = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
            if (zipModel.isZip64Format() && zipModel.getZip64EndCentralDirRecord() != null) {
                l4 = zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo();
            }
            if (n == (arrayList = zipModel.getCentralDirectory().getFileHeaders()).size() - 1) {
                l = l4 - 1L;
            } else {
                fileHeader2 = (FileHeader)arrayList.get(n + 1);
                if (fileHeader2 != null) {
                    l = fileHeader2.getOffsetLocalHeader() - 1L;
                    if (fileHeader2.getZip64ExtendedInfo() != null && fileHeader2.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                        l = fileHeader2.getZip64ExtendedInfo().getOffsetLocalHeader() - 1L;
                    }
                }
            }
            if (l2 < 0L) throw new ZipException("invalid offset for start and end of local file, cannot remove file");
            if (l < 0L) {
                throw new ZipException("invalid offset for start and end of local file, cannot remove file");
            }
            if (n == 0) {
                if (zipModel.getCentralDirectory().getFileHeaders().size() > 1) {
                    this.copyFile(randomAccessFile, outputStream, l + 1L, l4, progressMonitor);
                }
            } else if (n == arrayList.size() - 1) {
                this.copyFile(randomAccessFile, outputStream, 0L, l2, progressMonitor);
            } else {
                this.copyFile(randomAccessFile, outputStream, 0L, l2, progressMonitor);
                this.copyFile(randomAccessFile, outputStream, l + 1L, l4, progressMonitor);
            }
            if (!progressMonitor.isCancelAllTasks()) break block42;
            progressMonitor.setResult(3);
            progressMonitor.setState(0);
            fileHeader2 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
            }
            if (bl) {
                this.restoreFileName(file, string);
                return fileHeader2;
            }
            File file3 = new File(string);
            file3.delete();
            return fileHeader2;
        }
        zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(((SplitOutputStream)outputStream).getFilePointer());
        zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir() - 1);
        zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDirOnThisDisk() - 1);
        zipModel.getCentralDirectory().getFileHeaders().remove(n);
        for (int i = n; i < zipModel.getCentralDirectory().getFileHeaders().size(); ++i) {
            long l5 = ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getOffsetLocalHeader();
            if (((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getZip64ExtendedInfo() != null && ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                l5 = ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getZip64ExtendedInfo().getOffsetLocalHeader();
            }
            ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).setOffsetLocalHeader(l5 - (l - l2) - 1L);
        }
        HeaderWriter headerWriter = new HeaderWriter();
        headerWriter.finalizeZipFile(zipModel, outputStream);
        bl = true;
        hashMap.put("offsetCentralDir", Long.toString(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir()));
        try {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
        }
        if (bl) {
            this.restoreFileName(file, string);
            return hashMap;
        }
        File file4 = new File(string);
        file4.delete();
        return hashMap;
        catch (ZipException zipException) {
            try {
                progressMonitor.endProgressMonitorError(zipException);
                throw zipException;
                catch (Exception exception) {
                    progressMonitor.endProgressMonitorError(exception);
                    throw new ZipException(exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
                }
                if (bl) {
                    this.restoreFileName(file, string);
                    throw throwable;
                }
                File file5 = new File(string);
                file5.delete();
                throw throwable;
            }
        }
    }

    private void restoreFileName(File file, String string) throws ZipException {
        if (file.delete()) {
            File file2 = new File(string);
            if (!file2.renameTo(file)) {
                throw new ZipException("cannot rename modified zip file");
            }
        } else {
            throw new ZipException("cannot delete old zip file");
        }
    }

    private void copyFile(RandomAccessFile randomAccessFile, OutputStream outputStream, long l, long l2, ProgressMonitor progressMonitor) throws ZipException {
        if (randomAccessFile == null || outputStream == null) {
            throw new ZipException("input or output stream is null, cannot copy file");
        }
        if (l < 0L) {
            throw new ZipException("starting offset is negative, cannot copy file");
        }
        if (l2 < 0L) {
            throw new ZipException("end offset is negative, cannot copy file");
        }
        if (l > l2) {
            throw new ZipException("start offset is greater than end offset, cannot copy file");
        }
        if (l == l2) {
            return;
        }
        if (progressMonitor.isCancelAllTasks()) {
            progressMonitor.setResult(3);
            progressMonitor.setState(0);
            return;
        }
        try {
            randomAccessFile.seek(l);
            int n = -2;
            long l3 = 0L;
            long l4 = l2 - l;
            byte[] byArray = l2 - l < 4096L ? new byte[(int)(l2 - l)] : new byte[4096];
            while ((n = randomAccessFile.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                progressMonitor.updateWorkCompleted(n);
                if (progressMonitor.isCancelAllTasks()) {
                    progressMonitor.setResult(3);
                    return;
                }
                if ((l3 += (long)n) != l4) {
                    if (l3 + (long)byArray.length <= l4) continue;
                    byArray = new byte[(int)(l4 - l3)];
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private RandomAccessFile createFileHandler(ZipModel zipModel, String string) throws ZipException {
        if (zipModel == null || !Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getZipFile())) {
            throw new ZipException("input parameter is null in getFilePointer, cannot create file handler to remove file");
        }
        try {
            return new RandomAccessFile(new File(zipModel.getZipFile()), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
    }

    public void mergeSplitZipFiles(final ZipModel zipModel, final File file, final ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (bl) {
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ArchiveMaintainer.this.initMergeSplitZipFile(zipModel, file, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.initMergeSplitZipFile(zipModel, file, progressMonitor);
        }
    }

    private void initMergeSplitZipFile(ZipModel zipModel, File file, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null) {
            ZipException zipException = new ZipException("one of the input parameters is null, cannot merge split zip file");
            progressMonitor.endProgressMonitorError(zipException);
            throw zipException;
        }
        if (!zipModel.isSplitArchive()) {
            ZipException zipException = new ZipException("archive not a split zip file");
            progressMonitor.endProgressMonitorError(zipException);
            throw zipException;
        }
        OutputStream outputStream = null;
        RandomAccessFile randomAccessFile = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l = 0L;
        boolean bl = false;
        try {
            int n = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
            if (n <= 0) {
                throw new ZipException("corrupt zip model, archive not a split zip file");
            }
            outputStream = this.prepareOutputStreamForMerge(file);
            for (int i = 0; i <= n; ++i) {
                randomAccessFile = this.createSplitZipFileHandler(zipModel, i);
                int n2 = 0;
                Long l2 = new Long(randomAccessFile.length());
                if (i == 0 && zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
                    byte[] byArray = new byte[4];
                    randomAccessFile.seek(0L);
                    randomAccessFile.read(byArray);
                    if ((long)Raw.readIntLittleEndian(byArray, 0) == 134695760L) {
                        n2 = 4;
                        bl = true;
                    }
                }
                if (i == n) {
                    l2 = new Long(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                }
                this.copyFile(randomAccessFile, outputStream, n2, l2, progressMonitor);
                l += l2 - (long)n2;
                if (progressMonitor.isCancelAllTasks()) {
                    progressMonitor.setResult(3);
                    progressMonitor.setState(0);
                    return;
                }
                arrayList.add(l2);
                try {
                    randomAccessFile.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ZipModel zipModel2 = (ZipModel)zipModel.clone();
            zipModel2.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(l);
            this.updateSplitZipModel(zipModel2, arrayList, bl);
            HeaderWriter headerWriter = new HeaderWriter();
            headerWriter.finalizeZipFileWithoutValidations(zipModel2, outputStream);
            progressMonitor.endProgressMonitorSuccess();
        }
        catch (IOException iOException) {
            progressMonitor.endProgressMonitorError(iOException);
            throw new ZipException(iOException);
        }
        catch (Exception exception) {
            progressMonitor.endProgressMonitorError(exception);
            throw new ZipException(exception);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private RandomAccessFile createSplitZipFileHandler(ZipModel zipModel, int n) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot create split file handler");
        }
        if (n < 0) {
            throw new ZipException("invlaid part number, cannot create split file handler");
        }
        try {
            String string = zipModel.getZipFile();
            String string2 = null;
            string2 = n == zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? zipModel.getZipFile() : (n >= 9 ? string.substring(0, string.lastIndexOf(".")) + ".z" + (n + 1) : string.substring(0, string.lastIndexOf(".")) + ".z0" + (n + 1));
            File file = new File(string2);
            if (!Zip4jUtil.checkFileExists(file)) {
                throw new ZipException("split file does not exist: " + string2);
            }
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private OutputStream prepareOutputStreamForMerge(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("outFile is null, cannot create outputstream");
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void updateSplitZipModel(ZipModel zipModel, ArrayList arrayList, boolean bl) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split zip model");
        }
        zipModel.setSplitArchive(false);
        this.updateSplitFileHeader(zipModel, arrayList, bl);
        this.updateSplitEndCentralDirectory(zipModel);
        if (zipModel.isZip64Format()) {
            this.updateSplitZip64EndCentralDirLocator(zipModel, arrayList);
            this.updateSplitZip64EndCentralDirRec(zipModel, arrayList);
        }
    }

    private void updateSplitFileHeader(ZipModel zipModel, ArrayList arrayList, boolean bl) throws ZipException {
        try {
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            int n = zipModel.getCentralDirectory().getFileHeaders().size();
            int n2 = 0;
            if (bl) {
                n2 = 4;
            }
            for (int i = 0; i < n; ++i) {
                long l = 0L;
                for (int j = 0; j < ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getDiskNumberStart(); ++j) {
                    l += ((Long)arrayList.get(j)).longValue();
                }
                ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).setOffsetLocalHeader(((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getOffsetLocalHeader() + l - (long)n2);
                ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).setDiskNumberStart(0);
            }
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void updateSplitEndCentralDirectory(ZipModel zipModel) throws ZipException {
        try {
            if (zipModel == null) {
                throw new ZipException("zip model is null - cannot update end of central directory for split zip model");
            }
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            zipModel.getEndCentralDirRecord().setNoOfThisDisk(0);
            zipModel.getEndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
            zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(zipModel.getCentralDirectory().getFileHeaders().size());
            zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getCentralDirectory().getFileHeaders().size());
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void updateSplitZip64EndCentralDirLocator(ZipModel zipModel, ArrayList arrayList) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory locator");
        }
        if (zipModel.getZip64EndCentralDirLocator() == null) {
            return;
        }
        zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(0);
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            l += ((Long)arrayList.get(i)).longValue();
        }
        zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec() + l);
        zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(1);
    }

    private void updateSplitZip64EndCentralDirRec(ZipModel zipModel, ArrayList arrayList) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory record");
        }
        if (zipModel.getZip64EndCentralDirRecord() == null) {
            return;
        }
        zipModel.getZip64EndCentralDirRecord().setNoOfThisDisk(0);
        zipModel.getZip64EndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
        zipModel.getZip64EndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir());
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            l += ((Long)arrayList.get(i)).longValue();
        }
        zipModel.getZip64EndCentralDirRecord().setOffsetStartCenDirWRTStartDiskNo(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo() + l);
    }

    public void setComment(ZipModel zipModel, String string) throws ZipException {
        if (string == null) {
            throw new ZipException("comment is null, cannot update Zip file with comment");
        }
        if (zipModel == null) {
            throw new ZipException("zipModel is null, cannot update Zip file with comment");
        }
        String string2 = string;
        byte[] byArray = string.getBytes();
        int n = string.length();
        if (Zip4jUtil.isSupportedCharset("windows-1254")) {
            try {
                string2 = new String(string.getBytes("windows-1254"), "windows-1254");
                byArray = string2.getBytes("windows-1254");
                n = string2.length();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string;
                byArray = string.getBytes();
                n = string.length();
            }
        }
        if (n > 65535) {
            throw new ZipException("comment length exceeds maximum length");
        }
        zipModel.getEndCentralDirRecord().setComment(string2);
        zipModel.getEndCentralDirRecord().setCommentBytes(byArray);
        zipModel.getEndCentralDirRecord().setCommentLength(n);
        SplitOutputStream splitOutputStream = null;
        try {
            HeaderWriter headerWriter = new HeaderWriter();
            splitOutputStream = new SplitOutputStream(zipModel.getZipFile());
            if (zipModel.isZip64Format()) {
                splitOutputStream.seek(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo());
            } else {
                splitOutputStream.seek(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
            }
            headerWriter.finalizeZipFileWithoutValidations(zipModel, splitOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        finally {
            if (splitOutputStream != null) {
                try {
                    splitOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void initProgressMonitorForRemoveOp(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null || fileHeader == null || progressMonitor == null) {
            throw new ZipException("one of the input parameters is null, cannot calculate total work");
        }
        progressMonitor.setCurrentOperation(2);
        progressMonitor.setFileName(fileHeader.getFileName());
        progressMonitor.setTotalWork(this.calculateTotalWorkForRemoveOp(zipModel, fileHeader));
        progressMonitor.setState(1);
    }

    private long calculateTotalWorkForRemoveOp(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        return Zip4jUtil.getFileLengh(new File(zipModel.getZipFile())) - fileHeader.getCompressedSize();
    }

    public void initProgressMonitorForMergeOp(ZipModel zipModel, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot calculate total work for merge op");
        }
        progressMonitor.setCurrentOperation(4);
        progressMonitor.setFileName(zipModel.getZipFile());
        progressMonitor.setTotalWork(this.calculateTotalWorkForMergeOp(zipModel));
        progressMonitor.setState(1);
    }

    private long calculateTotalWorkForMergeOp(ZipModel zipModel) throws ZipException {
        long l = 0L;
        if (zipModel.isSplitArchive()) {
            int n = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
            String string = null;
            String string2 = zipModel.getZipFile();
            int n2 = 0;
            for (int i = 0; i <= n; ++i) {
                string = n2 == zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? zipModel.getZipFile() : (n2 >= 9 ? string2.substring(0, string2.lastIndexOf(".")) + ".z" + (n2 + 1) : string2.substring(0, string2.lastIndexOf(".")) + ".z0" + (n2 + 1));
                l += Zip4jUtil.getFileLengh(new File(string));
            }
        }
        return l;
    }
}

