/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.Zip4jUtil;

public class CRCUtil {
    private static final int BUF_SIZE = 16384;

    public static long computeFileCRC(String string) throws ZipException {
        return CRCUtil.computeFileCRC(string, null);
    }

    public static long computeFileCRC(String string, ProgressMonitor progressMonitor) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input file is null or empty, cannot calculate CRC for the file");
        }
        InputStream inputStream = null;
        try {
            Zip4jUtil.checkFileReadAccess(string);
            inputStream = new FileInputStream(new File(string));
            byte[] byArray = new byte[16384];
            int n = -2;
            CRC32 cRC32 = new CRC32();
            while ((n = inputStream.read(byArray)) != -1) {
                cRC32.update(byArray, 0, n);
                if (progressMonitor == null) continue;
                progressMonitor.updateWorkCompleted(n);
                if (!progressMonitor.isCancelAllTasks()) continue;
                progressMonitor.setResult(3);
                progressMonitor.setState(0);
                long l = 0L;
                return l;
            }
            long l = cRC32.getValue();
            return l;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new ZipException("error while closing the file after calculating crc");
                }
            }
        }
    }
}

