/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.message;

import com.mirth.connect.donkey.model.message.Status;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="response")
public class Response
implements Serializable {
    private static final long serialVersionUID = 99766081218628503L;
    private Status status;
    private String message = new String();
    private String error = new String();
    private String statusMessage = new String();
    private transient boolean validate = false;

    public Response() {
        this(new String());
    }

    public Response(Response response) {
        this(response.getStatus(), response.getMessage(), response.getStatusMessage(), response.getError(), response.isValidate());
    }

    public Response(String message) {
        this(null, message);
    }

    public Response(Status status, String message) {
        this(status, message, new String());
    }

    public Response(Status status, String message, String statusMessage) {
        this(status, message, statusMessage, new String());
    }

    public Response(Status status, String message, String statusMessage, String error) {
        this(status, message, statusMessage, error, false);
    }

    public Response(Status status, String message, String statusMessage, String error, boolean validate) {
        this.status = status;
        this.setMessage(message);
        this.setStatusMessage(statusMessage);
        this.setError(error);
        this.setValidate(validate);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean equals(Object other) {
        Response otherResponse;
        return other instanceof Response && this.status == (otherResponse = (Response)other).getStatus() && this.message.equals(otherResponse.getMessage()) && this.statusMessage.equals(otherResponse.getStatusMessage()) && this.error.equals(otherResponse.getError());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.status);
        if (StringUtils.isNotEmpty((CharSequence)this.statusMessage)) {
            builder.append(": ");
            builder.append(this.statusMessage);
        }
        return builder.toString();
    }

    public String fixStatus(boolean queueEnabled) {
        Status status = this.getStatus();
        if (status != Status.ERROR && status != Status.SENT && status != Status.QUEUED) {
            this.setStatus(Status.ERROR);
            return "Invalid response status: " + String.valueOf((Object)status) + ". Status updated to ERROR.";
        }
        if (!queueEnabled && status == Status.QUEUED) {
            this.setStatus(Status.ERROR);
            return "Invalid response status. Cannot set status to QUEUED while queuing is disabled. Status updated to ERROR.";
        }
        return null;
    }
}

