/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.util.Date;
import java.util.Iterator;
import org.dcm4che2.data.AbstractDicomObject;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomElementCombineIterator;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.TagUtils;

public class CombineDicomObject
extends AbstractDicomObject {
    private static final long serialVersionUID = 532952440455021487L;
    DicomObject ds1;
    DicomObject ds2;

    public CombineDicomObject(DicomObject ds1, DicomObject ds2) {
        this.ds1 = ds1;
        this.ds2 = ds2;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomObject getRoot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomObject getParent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParent(DicomObject parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpecificCharacterSet getSpecificCharacterSet() {
        if (this.ds1.contains(524293)) {
            return this.ds1.getSpecificCharacterSet();
        }
        return this.ds2.getSpecificCharacterSet();
    }

    @Override
    public Iterator<DicomElement> iterator() {
        return this.iterator(0, -1);
    }

    @Override
    public Iterator<DicomElement> iterator(int fromTag, int toTag) {
        Iterator<DicomElement> it1 = this.ds1.iterator(fromTag, toTag);
        Iterator<DicomElement> it2 = this.ds2.iterator(fromTag, toTag);
        return new DicomElementCombineIterator(it1, it2);
    }

    @Override
    public int getItemPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setItemPosition(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getItemOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setItemOffset(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VR vrOf(int tag) {
        if (this.ds1.contains(tag)) {
            return this.ds1.vrOf(tag);
        }
        return this.ds2.vrOf(this.resolveTagForDS2(tag));
    }

    @Override
    public String nameOf(int tag) {
        if (this.ds1.contains(tag)) {
            return this.ds1.nameOf(tag);
        }
        return this.ds2.nameOf(this.resolveTagForDS2(tag));
    }

    @Override
    public int resolveTag(int tag, String privateCreator) {
        return this.ds1.resolveTag(tag, privateCreator);
    }

    @Override
    public int resolveTag(int tag, String privateCreator, boolean reserve) {
        return this.ds1.resolveTag(tag, privateCreator, reserve);
    }

    @Override
    public String getPrivateCreator(int tag) {
        if (this.ds1.contains(tag)) {
            return this.ds1.getPrivateCreator(tag);
        }
        return this.ds2.getPrivateCreator(tag);
    }

    @Override
    public boolean contains(int tag) {
        return this.ds1.contains(tag) || this.ds2.contains(this.resolveTagForDS2(tag));
    }

    @Override
    public DicomObject subSet(DicomObject filter) {
        return new CombineDicomObject(this.ds1.subSet(filter), this.ds2.subSet(filter));
    }

    @Override
    public DicomObject subSet(int fromTag, int toTag) {
        return new CombineDicomObject(this.ds1.subSet(fromTag, toTag), this.ds2.subSet(fromTag, toTag));
    }

    @Override
    public DicomObject subSet(int[] tags) {
        return new CombineDicomObject(this.ds1.subSet(tags), this.ds2.subSet(tags));
    }

    @Override
    public boolean accept(DicomObject.Visitor visitor) {
        Iterator<DicomElement> it = this.iterator();
        while (it.hasNext()) {
            DicomElement de = it.next();
            if (visitor.visit(de)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(DicomElement attr) {
        this.ds1.add(attr);
    }

    @Override
    public DicomElement remove(int tag) {
        return this.ds1.remove(tag);
    }

    private int resolveTagForDS2(int tag) {
        if (TagUtils.isPrivateDataElement(tag) && !TagUtils.isPrivateCreatorDataElement(tag)) {
            String creatorName = this.ds1.getPrivateCreator(tag);
            tag = this.ds2.resolveTag(tag, creatorName, false);
        }
        return tag;
    }

    @Override
    public DicomElement get(int tag) {
        DicomElement element;
        if (this.ds1.contains(tag)) {
            element = this.ds1.get(tag);
        } else {
            tag = this.resolveTagForDS2(tag);
            element = this.ds2.get(tag);
        }
        return element;
    }

    @Override
    public DicomElement putNull(int tag, VR vr) {
        return this.ds1.putNull(tag, vr);
    }

    @Override
    public DicomElement putBytes(int tag, VR vr, byte[] val, boolean bigEndian) {
        return this.ds1.putBytes(tag, vr, val, bigEndian);
    }

    @Override
    public DicomElement putNestedDicomObject(int tag, DicomObject item) {
        return this.putNestedDicomObject(tag, item);
    }

    @Override
    public DicomElement putInt(int tag, VR vr, int val) {
        return this.ds1.putInt(tag, vr, val);
    }

    @Override
    public DicomElement putInts(int tag, VR vr, int[] val) {
        return this.ds1.putInts(tag, vr, val);
    }

    @Override
    public DicomElement putShorts(int tag, VR vr, short[] val) {
        return this.ds1.putShorts(tag, vr, val);
    }

    @Override
    public DicomElement putFloat(int tag, VR vr, float val) {
        return this.ds1.putFloat(tag, vr, val);
    }

    @Override
    public DicomElement putFloats(int tag, VR vr, float[] val) {
        return this.ds1.putFloats(tag, vr, val);
    }

    @Override
    public DicomElement putDouble(int tag, VR vr, double val) {
        return this.ds1.putDouble(tag, vr, val);
    }

    @Override
    public DicomElement putDoubles(int tag, VR vr, double[] val) {
        return this.ds1.putDoubles(tag, vr, val);
    }

    @Override
    public DicomElement putString(int tag, VR vr, String val) {
        return this.ds1.putString(tag, vr, val);
    }

    @Override
    public DicomElement putStrings(int tag, VR vr, String[] val) {
        return this.ds1.putStrings(tag, vr, val);
    }

    @Override
    public DicomElement putDate(int tag, VR vr, Date val) {
        return this.ds1.putDate(tag, vr, val);
    }

    @Override
    public DicomElement putDates(int tag, VR vr, Date[] val) {
        return this.ds1.putDates(tag, vr, val);
    }

    @Override
    public DicomElement putDateRange(int tag, VR vr, DateRange val) {
        return this.ds1.putDateRange(tag, vr, val);
    }

    @Override
    public DicomElement putSequence(int tag) {
        return this.ds1.putSequence(tag);
    }

    @Override
    public DicomElement putSequence(int tag, int capacity) {
        return this.ds1.putSequence(tag, capacity);
    }

    @Override
    public DicomElement putFragments(int tag, VR vr, boolean bigEndian) {
        return this.ds1.putFragments(tag, vr, bigEndian);
    }

    @Override
    public DicomElement putFragments(int tag, VR vr, boolean bigEndian, int capacity) {
        return this.ds1.putFragments(tag, vr, bigEndian, capacity);
    }

    @Override
    public void shareElements() {
    }

    @Override
    public boolean cacheGet() {
        return false;
    }

    @Override
    public void cacheGet(boolean cacheGet) {
    }

    @Override
    public boolean cachePut() {
        return false;
    }

    @Override
    public void cachePut(boolean cachePut) {
    }

    @Override
    public boolean bigEndian() {
        return this.ds1.bigEndian();
    }

    @Override
    public void bigEndian(boolean bigEndian) {
        this.ds1.bigEndian(bigEndian);
    }

    @Override
    public void initFileMetaInformation(String tsuid) {
        this.ds1.initFileMetaInformation(tsuid);
    }

    @Override
    public void initFileMetaInformation(String cuid, String iuid, String tsuid) {
        this.ds1.initFileMetaInformation(cuid, iuid, tsuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DicomObject)) {
            return false;
        }
        DicomObject other = (DicomObject)o;
        Iterator<DicomElement> it = this.iterator();
        Iterator<DicomElement> otherIt = other.iterator();
        while (it.hasNext() && otherIt.hasNext()) {
            if (it.next().equals(otherIt.next())) continue;
            return false;
        }
        return !it.hasNext() && !otherIt.hasNext();
    }
}

