/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dcm4che2.data.AbstractDicomObject;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.TagUtils;

abstract class FilteredDicomObject
extends AbstractDicomObject {
    private static final long serialVersionUID = -3541514478162843135L;
    protected final DicomObject attrs;

    public FilteredDicomObject(DicomObject attrs) {
        this.attrs = attrs;
    }

    protected abstract boolean filter(int var1);

    @Override
    public int getItemPosition() {
        return this.attrs.getItemPosition();
    }

    @Override
    public void setItemPosition(int pos) {
        this.attrs.setItemPosition(pos);
    }

    @Override
    public long getItemOffset() {
        return this.attrs.getItemOffset();
    }

    @Override
    public void setItemOffset(long offset) {
    }

    @Override
    public boolean accept(final DicomObject.Visitor visitor) {
        return this.attrs.accept(new DicomObject.Visitor(){

            @Override
            public boolean visit(DicomElement attr) {
                return !FilteredDicomObject.this.filter(attr.tag()) || visitor.visit(attr);
            }
        });
    }

    @Override
    public Iterator<DicomElement> iterator() {
        return new Itr(this.attrs.iterator());
    }

    @Override
    public Iterator<DicomElement> iterator(int fromTag, int toTag) {
        return new Itr(this.attrs.iterator(fromTag, toTag));
    }

    @Override
    public boolean contains(int tag) {
        return this.filter(tag) && this.attrs.contains(tag);
    }

    @Override
    public DicomElement get(int tag) {
        return this.filter(tag) ? this.attrs.get(tag) : null;
    }

    @Override
    public DicomElement get(int tag, VR vr) {
        return this.filter(tag) ? this.attrs.get(tag, vr) : null;
    }

    @Override
    public DicomObject getParent() {
        return this.attrs.getParent();
    }

    @Override
    public void setParent(DicomObject parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrivateCreator(int privateTag) {
        return this.filter(privateTag) ? this.attrs.getPrivateCreator(privateTag) : null;
    }

    @Override
    public DicomObject getRoot() {
        return this.attrs.getRoot();
    }

    @Override
    public SpecificCharacterSet getSpecificCharacterSet() {
        return this.attrs.getSpecificCharacterSet();
    }

    @Override
    public boolean cacheGet() {
        return this.attrs.cacheGet();
    }

    @Override
    public boolean cachePut() {
        return this.attrs.cachePut();
    }

    @Override
    public boolean bigEndian() {
        return this.attrs.bigEndian();
    }

    @Override
    public void add(DicomElement attr) {
        if (!this.filter(attr.tag())) {
            throw new IllegalArgumentException();
        }
        this.attrs.add(attr);
    }

    @Override
    public DicomElement putBytes(int tag, VR vr, byte[] val, boolean bigEndian) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putBytes(tag, vr, val, bigEndian);
    }

    @Override
    public DicomElement putDouble(int tag, VR vr, double val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putDouble(tag, vr, val);
    }

    @Override
    public DicomElement putDoubles(int tag, VR vr, double[] val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putDoubles(tag, vr, val);
    }

    @Override
    public DicomElement putNull(int tag, VR vr) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putNull(tag, vr);
    }

    @Override
    public DicomElement putFloat(int tag, VR vr, float val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putFloat(tag, vr, val);
    }

    @Override
    public DicomElement putFloats(int tag, VR vr, float[] val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putFloats(tag, vr, val);
    }

    @Override
    public DicomElement putInt(int tag, VR vr, int val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putInt(tag, vr, val);
    }

    @Override
    public DicomElement putInts(int tag, VR vr, int[] val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putInts(tag, vr, val);
    }

    @Override
    public DicomElement putShorts(int tag, VR vr, short[] val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putShorts(tag, vr, val);
    }

    @Override
    public DicomElement putNestedDicomObject(int tag, DicomObject item) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putNestedDicomObject(tag, item);
    }

    @Override
    public DicomElement putString(int tag, VR vr, String val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putString(tag, vr, val);
    }

    @Override
    public DicomElement putStrings(int tag, VR vr, String[] val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putStrings(tag, vr, val);
    }

    @Override
    public DicomElement putDate(int tag, VR vr, Date val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putDate(tag, vr, val);
    }

    @Override
    public DicomElement putDates(int tag, VR vr, Date[] val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putDates(tag, vr, val);
    }

    @Override
    public DicomElement putDateRange(int tag, VR vr, DateRange val) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putDateRange(tag, vr, val);
    }

    @Override
    public void clear() {
        final int[] toRemove = new int[this.size()];
        this.accept(new DicomObject.Visitor(){
            int i = 0;

            @Override
            public boolean visit(DicomElement attr) {
                toRemove[this.i++] = attr.tag();
                return true;
            }
        });
        for (int i = 0; i < toRemove.length; ++i) {
            this.attrs.remove(toRemove[i]);
        }
    }

    @Override
    public DicomElement remove(int tag) {
        return this.filter(tag) ? this.attrs.remove(tag) : null;
    }

    @Override
    public int resolveTag(int privateTag, String privateCreator) {
        return this.attrs.resolveTag(privateTag, privateCreator);
    }

    @Override
    public int resolveTag(int privateTag, String privateCreator, boolean reserve) {
        return this.attrs.resolveTag(privateTag, privateCreator, false);
    }

    @Override
    public void cacheGet(boolean cached) {
        this.attrs.cacheGet(cached);
    }

    @Override
    public void cachePut(boolean cached) {
        this.attrs.cachePut(cached);
    }

    @Override
    public void bigEndian(boolean bigEndian) {
        this.attrs.bigEndian(bigEndian);
    }

    @Override
    public void shareElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VR vrOf(int tag) {
        return this.attrs.vrOf(tag);
    }

    @Override
    public String nameOf(int tag) {
        return this.attrs.nameOf(tag);
    }

    @Override
    public DicomElement putFragments(int tag, VR vr, boolean bigEndian, int capacity) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putFragments(tag, vr, bigEndian, capacity);
    }

    @Override
    public DicomElement putFragments(int tag, VR vr, boolean bigEndian) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putFragments(tag, vr, bigEndian);
    }

    @Override
    public DicomElement putSequence(int tag, int capacity) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putSequence(tag, capacity);
    }

    @Override
    public DicomElement putSequence(int tag) {
        if (!this.filter(tag)) {
            throw new UnsupportedOperationException();
        }
        return this.attrs.putSequence(tag);
    }

    @Override
    public void initFileMetaInformation(String tsuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initFileMetaInformation(String cuid, String iuid, String tsuid) {
        throw new UnsupportedOperationException();
    }

    protected class Itr
    implements Iterator<DicomElement> {
        final Iterator<DicomElement> itr;
        DicomElement next;

        public Itr(Iterator<DicomElement> itr) {
            this.itr = itr;
            this.findNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DicomElement next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            DicomElement tmp = this.next;
            this.findNext();
            return tmp;
        }

        private void findNext() {
            while (this.itr.hasNext()) {
                this.next = this.itr.next();
                if (!FilteredDicomObject.this.filter(this.next.tag())) continue;
                return;
            }
            this.next = null;
        }
    }

    static final class FilterSet
    extends FilteredDicomObject {
        private static final long serialVersionUID = 1L;
        final DicomObject filter;

        public FilterSet(DicomObject attrs, DicomObject filter) {
            super(attrs);
            this.filter = filter;
        }

        @Override
        protected boolean filter(int tag) {
            return this.filter.contains(tag);
        }

        @Override
        public DicomObject getNestedDicomObject(int tag) {
            DicomObject item = super.getNestedDicomObject(tag);
            if (item == null) {
                return null;
            }
            return item.subSet(this.filter.getNestedDicomObject(tag));
        }

        @Override
        public Iterator<DicomElement> iterator() {
            return new FilterItr(this.attrs.iterator());
        }

        @Override
        public Iterator<DicomElement> iterator(int fromTag, int toTag) {
            return new FilterItr(this.attrs.iterator(fromTag, toTag));
        }

        @Override
        public void clear() {
            this.filter.accept(new DicomObject.Visitor(){

                @Override
                public boolean visit(DicomElement e) {
                    FilterSet.this.attrs.remove(e.tag());
                    return true;
                }
            });
        }

        final class FilterItr
        extends Itr {
            public FilterItr(Iterator<DicomElement> itr) {
                super(itr);
            }

            @Override
            public DicomElement next() {
                DicomElement attr = super.next();
                if (attr.vr() == VR.SQ && attr.hasItems()) {
                    return attr.filterItems(FilterSet.this.filter.getNestedDicomObject(attr.tag()));
                }
                return attr;
            }
        }
    }

    static final class ExcludePrivate
    extends FilteredDicomObject {
        private static final long serialVersionUID = 1L;

        public ExcludePrivate(DicomObject attrs) {
            super(attrs);
        }

        @Override
        protected boolean filter(int tag) {
            return !TagUtils.isPrivateDataElement(tag);
        }
    }

    static final class Range
    extends FilteredDicomObject {
        private static final long serialVersionUID = 1L;
        final long fromTag;
        final long toTag;

        public Range(DicomObject attrs, int fromTag, int toTag) {
            super(attrs);
            if (((long)fromTag & 0xFFFFFFFFL) > ((long)toTag & 0xFFFFFFFFL)) {
                throw new IllegalArgumentException("fromTag:" + TagUtils.toString(fromTag) + " > toTag:" + TagUtils.toString(toTag));
            }
            this.fromTag = (long)fromTag & 0xFFFFFFFFL;
            this.toTag = (long)toTag & 0xFFFFFFFFL;
            if (this.fromTag > this.toTag) {
                throw new IllegalArgumentException("fromTag:" + TagUtils.toString(fromTag) + " > toTag:" + TagUtils.toString(toTag));
            }
        }

        @Override
        protected boolean filter(int tag) {
            long ltag = (long)tag & 0xFFFFFFFFL;
            return this.fromTag <= ltag && ltag <= this.toTag;
        }

        @Override
        public Iterator<DicomElement> iterator() {
            return new Itr(this.attrs.iterator((int)this.fromTag, (int)this.toTag));
        }

        @Override
        public Iterator<DicomElement> iterator(int fromTag, int toTag) {
            long maxFromTag = Math.max((long)(fromTag & 0xFFFFFFFF), this.fromTag);
            long minToTag = Math.min((long)(toTag & 0xFFFFFFFF), this.toTag);
            return new Itr(this.attrs.iterator((int)maxFromTag, (int)minToTag));
        }
    }

    static final class Exclude
    extends FilteredDicomObject {
        private static final long serialVersionUID = 1L;
        final int[] tags;

        public Exclude(DicomObject attrs, int[] tags) {
            super(attrs);
            this.tags = (int[])tags.clone();
            Arrays.sort(this.tags);
        }

        @Override
        protected boolean filter(int tag) {
            return Arrays.binarySearch(this.tags, tag) < 0;
        }
    }

    static final class Include
    extends FilteredDicomObject {
        private static final long serialVersionUID = 1L;
        final int[] tags;

        public Include(DicomObject attrs, int[] tags) {
            super(attrs);
            this.tags = (int[])tags.clone();
            Arrays.sort(this.tags);
        }

        @Override
        protected boolean filter(int tag) {
            return Arrays.binarySearch(this.tags, tag) >= 0;
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.tags.length; ++i) {
                this.attrs.remove(this.tags[i]);
            }
        }
    }
}

