/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import org.dcm4che2.util.StringUtils;

public class TagUtils {
    public static boolean hasVR(int tag) {
        return tag != -73728 && tag != -73715 && tag != -73507;
    }

    public static boolean isCommandElement(int tag) {
        return (tag & 0xFFFF0000) == 0;
    }

    public static boolean isFileMetaInfoElement(int tag) {
        return (tag & 0xFFFF0000) == 131072;
    }

    public static boolean isGroupLengthElement(int tag) {
        return (tag & 0xFFFF) == 0;
    }

    public static boolean isPrivateDataElement(int tag) {
        return (tag & 0x10000) != 0;
    }

    public static boolean isPrivateCreatorDataElement(int tag) {
        return (tag & 0x10000) != 0 && (tag & 0xFF00) == 0;
    }

    public static StringBuffer toStringBuffer(int tag, StringBuffer sb) {
        sb.append('(');
        StringUtils.shortToHex(tag >> 16, sb);
        sb.append(',');
        StringUtils.shortToHex(tag, sb);
        sb.append(')');
        return sb;
    }

    public static String toString(int tag) {
        return TagUtils.toStringBuffer(tag, new StringBuffer(11)).toString();
    }
}

