/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;

public class HttpStaticResource
implements Serializable {
    private String contextPath;
    private ResourceType resourceType;
    private String value;
    private String contentType;
    private Map<String, List<String>> queryParameters;

    public HttpStaticResource(String contextPath, ResourceType resourceType, String value, String contentType) {
        this(contextPath, resourceType, value, contentType, null);
    }

    public HttpStaticResource(String contextPath, ResourceType resourceType, String value, String contentType, Map<String, List<String>> queryParameters) {
        this.contextPath = contextPath;
        this.resourceType = resourceType;
        this.value = value;
        this.contentType = contentType;
        this.queryParameters = queryParameters;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, List<String>> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public static enum ResourceType {
        FILE,
        DIRECTORY,
        CUSTOM;


        public String toString() {
            return WordUtils.capitalizeFully((String)super.toString());
        }

        public static ResourceType fromString(String value) {
            for (ResourceType resourceType : ResourceType.values()) {
                if (!resourceType.toString().equals(value)) continue;
                return resourceType;
            }
            return null;
        }

        public static String[] stringValues() {
            ResourceType[] values = ResourceType.values();
            String[] stringValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                stringValues[i] = values[i].toString();
            }
            return stringValues;
        }
    }
}

