/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth;

import com.mirth.connect.userutil.MessageHeaders;
import com.mirth.connect.userutil.MessageParameters;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class RequestInfo {
    private String remoteAddress;
    private int remotePort;
    private String localAddress;
    private int localPort;
    private String protocol;
    private String method;
    private String requestURI;
    private Map<String, List<String>> headers = new CaseInsensitiveMap();
    private Map<String, List<String>> queryParameters = new CaseInsensitiveMap();
    private EntityProvider entityProvider;
    private Map<String, Object> extraProperties = new HashMap<String, Object>();

    public RequestInfo(String remoteAddress, int remotePort, String localAddress, int localPort, String protocol, String method, String requestURI, Map<String, List<String>> headers, Map<String, List<String>> queryParameters, EntityProvider entityProvider) {
        this(remoteAddress, remotePort, localAddress, localPort, protocol, method, requestURI, headers, queryParameters, entityProvider, null);
    }

    public RequestInfo(String remoteAddress, int remotePort, String localAddress, int localPort, String protocol, String method, String requestURI, Map<String, List<String>> headers, Map<String, List<String>> queryParameters, EntityProvider entityProvider, Map<String, Object> extraProperties) {
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
        this.localAddress = localAddress;
        this.localPort = localPort;
        this.protocol = protocol;
        this.method = method;
        this.requestURI = requestURI;
        this.setHeaders(headers);
        this.setQueryParameters(queryParameters);
        this.entityProvider = entityProvider;
        this.extraProperties = extraProperties;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public Map<String, List<String>> getHeaders() {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            headers.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(headers);
    }

    private void setHeaders(Map<String, List<String>> headers) {
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
        }
        this.headers = new CaseInsensitiveMap(headers);
    }

    public Map<String, List<String>> getQueryParameters() {
        CaseInsensitiveMap queryParameters = new CaseInsensitiveMap();
        for (Map.Entry<String, List<String>> entry : this.queryParameters.entrySet()) {
            queryParameters.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(queryParameters);
    }

    private void setQueryParameters(Map<String, List<String>> queryParameters) {
        if (queryParameters == null) {
            queryParameters = new HashMap<String, List<String>>();
        }
        this.queryParameters = new CaseInsensitiveMap(queryParameters);
    }

    public EntityProvider getEntityProvider() {
        return this.entityProvider;
    }

    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties = extraProperties;
    }

    public void populateMap(Map<String, Object> map) {
        map.put("remoteAddress", this.remoteAddress);
        map.put("remotePort", this.remotePort);
        map.put("localAddress", this.localAddress);
        map.put("localPort", this.localPort);
        map.put("protocol", this.protocol);
        map.put("method", this.method);
        map.put("uri", this.requestURI);
        map.put("headers", new MessageHeaders(this.headers));
        map.put("parameters", new MessageParameters(this.queryParameters));
        if (MapUtils.isNotEmpty(this.extraProperties)) {
            map.putAll(this.extraProperties);
        }
    }

    public static interface EntityProvider {
        public static final String ATTRIBUTE_NAME = "Cached Entity";

        public byte[] getEntity() throws IOException;
    }
}

