/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.FileConnectorException;
import com.mirth.connect.connectors.file.FileDispatcherProperties;
import com.mirth.connect.connectors.file.FileReceiverProperties;
import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnectionFactory;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileConnector {
    private Logger logger = LogManager.getLogger(this.getClass());
    private Map<String, ObjectPool<FileSystemConnection>> pools = new HashMap<String, ObjectPool<FileSystemConnection>>();
    private FileOutputStream outputStream = null;
    private Set<FileSystemConnection> connections = new HashSet<FileSystemConnection>();
    private String channelId;
    private FileScheme scheme;
    private String timeout;
    private boolean passive;
    private boolean secure;
    private boolean validateConnection;
    private int maxTotalConnections = 8;
    private boolean keepConnectionOpen = false;
    private String maxIdleTime;

    public FileConnector(String channelId, ConnectorProperties connectorProperties, Connector connector) {
        this.channelId = channelId;
        if (connectorProperties instanceof FileReceiverProperties) {
            FileReceiverProperties fileReceiverProperties = (FileReceiverProperties)connectorProperties;
            this.scheme = fileReceiverProperties.getScheme();
            this.timeout = fileReceiverProperties.getTimeout();
            this.passive = fileReceiverProperties.isPassive();
            this.secure = fileReceiverProperties.isSecure();
            this.validateConnection = fileReceiverProperties.isValidateConnection();
        } else if (connectorProperties instanceof FileDispatcherProperties) {
            FileDispatcherProperties fileDispatcherProperties = (FileDispatcherProperties)connectorProperties;
            this.scheme = fileDispatcherProperties.getScheme();
            this.timeout = fileDispatcherProperties.getTimeout();
            this.passive = fileDispatcherProperties.isPassive();
            this.secure = fileDispatcherProperties.isSecure();
            this.validateConnection = fileDispatcherProperties.isValidateConnection();
            this.keepConnectionOpen = fileDispatcherProperties.isKeepConnectionOpen();
            this.maxIdleTime = fileDispatcherProperties.getMaxIdleTime();
        }
        if (connector instanceof DestinationConnector) {
            this.maxTotalConnections = Math.max(8, ((DestinationConnector)connector).getPotentialThreadCount());
        }
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public FileScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(FileScheme scheme) {
        this.scheme = scheme;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    protected String getPathPart(URI uri) {
        if (this.scheme == FileScheme.FILE) {
            return uri.getSchemeSpecificPart().substring(2);
        }
        return uri.getPath();
    }

    protected synchronized void doStop() throws FileConnectorException {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close file output stream on stop: " + String.valueOf(e));
            }
        }
        try {
            for (ObjectPool<FileSystemConnection> pool : this.pools.values()) {
                pool.close();
            }
            this.pools.clear();
        }
        catch (Exception e) {
            throw new FileConnectorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystemConnection getConnection(FileSystemConnectionOptions fileSystemOptions) throws Exception {
        ObjectPool<FileSystemConnection> pool = this.getConnectionPool(fileSystemOptions);
        FileSystemConnection con = (FileSystemConnection)pool.borrowObject();
        if (!con.isConnected() || !con.isValid()) {
            this.destroyConnection(con, fileSystemOptions);
            con = (FileSystemConnection)pool.borrowObject();
        }
        Set<FileSystemConnection> set = this.connections;
        synchronized (set) {
            this.connections.add(con);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection(FileSystemConnection connection, FileSystemConnectionOptions fileSystemOptions) throws Exception {
        Set<FileSystemConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(connection);
        }
        if (connection != null) {
            ObjectPool<FileSystemConnection> pool = this.getConnectionPool(fileSystemOptions);
            pool.returnObject((Object)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        Set<FileSystemConnection> set = this.connections;
        synchronized (set) {
            for (FileSystemConnection connection : this.connections) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyConnection(FileSystemConnection connection, FileSystemConnectionOptions fileSystemOptions) throws Exception {
        if (connection != null) {
            ObjectPool<FileSystemConnection> pool = this.getConnectionPool(fileSystemOptions);
            pool.invalidateObject((Object)connection);
            Set<FileSystemConnection> set = this.connections;
            synchronized (set) {
                this.connections.remove(connection);
            }
        }
    }

    private synchronized ObjectPool<FileSystemConnection> getConnectionPool(FileSystemConnectionOptions fileSystemOptions) throws Exception {
        FileSystemConnectionFactory fileSystemConnectionFactory = this.getFileSystemConnectionFactory(fileSystemOptions);
        String key = fileSystemConnectionFactory.getPoolKey();
        GenericObjectPool pool = this.pools.get(key);
        if (pool == null) {
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setMaxTotal(this.maxTotalConnections);
            config.setMinIdle(0);
            config.setTimeBetweenEvictionRunsMillis(1000L);
            if (this.keepConnectionOpen) {
                int connectionMaxIdleTime = NumberUtils.toInt((String)this.maxIdleTime);
                if (connectionMaxIdleTime == 0) {
                    config.setTimeBetweenEvictionRunsMillis(0L);
                } else {
                    config.setMinEvictableIdleTimeMillis((long)connectionMaxIdleTime);
                }
            } else {
                config.setMinEvictableIdleTimeMillis(1L);
            }
            if (this.isValidateConnection()) {
                config.setTestOnBorrow(true);
                config.setTestOnReturn(true);
            }
            pool = new GenericObjectPool((PooledObjectFactory)fileSystemConnectionFactory, config);
            this.pools.put(key, (ObjectPool<FileSystemConnection>)pool);
        }
        return pool;
    }

    protected FileSystemConnectionFactory getFileSystemConnectionFactory(FileSystemConnectionOptions fileSystemOptions) throws Exception {
        return new FileSystemConnectionFactory(this.getScheme(), fileSystemOptions, fileSystemOptions.getUri().getHost(), fileSystemOptions.getUri().getPort(), this.isPassive(), this.isSecure(), NumberUtils.toInt((String)this.getTimeout()));
    }

    public FileOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(FileOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public URI getEndpointURI(String host, FileScheme scheme, SchemeProperties schemeProperties, boolean isSecure) throws URISyntaxException {
        StringBuilder sspBuilder = new StringBuilder();
        sspBuilder.append("//");
        if (scheme == FileScheme.FILE && StringUtils.isNotBlank((CharSequence)host) && host.length() >= 3 && host.substring(1, 3).equals(":/")) {
            sspBuilder.append("/");
        }
        if (scheme == FileScheme.S3) {
            sspBuilder.append(((S3SchemeProperties)schemeProperties).getRegion()).append('/');
        }
        sspBuilder.append(host);
        String schemeName = scheme == FileScheme.WEBDAV ? (isSecure ? "https" : "http") : (scheme == FileScheme.S3 ? "s3" : scheme.getDisplayName());
        return new URI(schemeName, sspBuilder.toString(), null);
    }
}

