/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filesystems;

import com.mirth.connect.connectors.file.FileConnectorException;
import com.mirth.connect.connectors.file.filesystems.FileIgnoring;
import com.mirth.connect.connectors.file.filesystems.FileInfo;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filters.RegexFilenameFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileConnection
implements FileSystemConnection,
FileIgnoring {
    private static final String IGNORE = ".ignore";

    @Override
    public List<FileInfo> listFiles(String fromDir, String filenamePattern, boolean isRegex, boolean ignoreDot) throws Exception {
        RegexFilenameFilter filenameFilter = isRegex ? new RegexFilenameFilter(filenamePattern) : new WildcardFileFilter(filenamePattern.trim().split("\\s*,\\s*"));
        File readDirectory = this.getReadDirectory(fromDir);
        try {
            File[] todoFiles = readDirectory.listFiles(filenameFilter);
            if (todoFiles == null) {
                return new ArrayList<FileInfo>();
            }
            ArrayList<FileInfo> result = new ArrayList<FileInfo>(todoFiles.length);
            for (File f : todoFiles) {
                if (!f.isFile() || f.getName().endsWith(IGNORE) || this.isFileIgnored(f) || ignoreDot && f.getName().startsWith(".")) continue;
                result.add(new FileFileInfo(f));
            }
            return result;
        }
        catch (Exception e) {
            throw new FileConnectorException("Error listing files from [" + fromDir + "] for pattern [" + filenamePattern + "]", e);
        }
    }

    @Override
    public List<String> listDirectories(String fromDir) throws Exception {
        ArrayList<String> directories = new ArrayList<String>();
        for (File directory : this.getReadDirectory(fromDir).listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
            directories.add(directory.getCanonicalPath());
        }
        return directories;
    }

    private File getReadDirectory(String fromDir) throws Exception {
        try {
            return new File(fromDir);
        }
        catch (Exception e) {
            throw new FileConnectorException("Read directory does not exist: " + fromDir, e);
        }
    }

    @Override
    public boolean exists(String file, String path) {
        File src = new File(path, file);
        return src.exists();
    }

    @Override
    public boolean canRead(String readDir) {
        File readDirectory = new File(readDir);
        return readDirectory.isDirectory() && readDirectory.canRead();
    }

    @Override
    public boolean canWrite(String writeDir) {
        File writeDirectory = new File(writeDir);
        return writeDirectory.isDirectory() && writeDirectory.canWrite();
    }

    @Override
    public InputStream readFile(String file, String fromDir, Map<String, Object> sourceMap) throws FileConnectorException {
        try {
            File src = new File(fromDir, file);
            return new FileInputStream(src);
        }
        catch (Exception e) {
            throw new FileConnectorException("Error reading file [" + file + "] from dir [" + fromDir + "]", e);
        }
    }

    @Override
    public void closeReadFile() throws Exception {
    }

    @Override
    public boolean canAppend() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(String file, String toDir, boolean append, InputStream is, long contentLength, Map<String, Object> connectorMap) throws Exception {
        FileOutputStream os = null;
        File dstDir = new File(toDir);
        if (!dstDir.exists()) {
            dstDir.mkdirs();
        }
        File dst = new File(dstDir, file);
        try {
            os = new FileOutputStream(dst, append);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }

    @Override
    public void delete(String file, String fromDir, boolean mayNotExist) throws FileConnectorException {
        File src = new File(fromDir, file);
        if (!src.delete() && !mayNotExist) {
            throw new FileConnectorException("File should not exist after deleting: " + src.getAbsolutePath());
        }
    }

    @Override
    public void move(String fromName, String fromDir, String toName, String toDir) throws FileConnectorException {
        File src = new File(fromDir, fromName);
        File dst = new File(toDir, toName);
        dst.delete();
        if (!src.renameTo(dst)) {
            try {
                FileUtils.copyFile((File)src, (File)dst);
                if (!FileUtils.deleteQuietly((File)src)) {
                    this.ignoreFile(src);
                }
            }
            catch (IOException e) {
                throw new FileConnectorException("Error from file from [" + src.getAbsolutePath() + "] to [" + dst.getAbsolutePath() + "]", e);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isFileIgnored(File file) {
        File f = new File(file.getAbsolutePath() + IGNORE);
        return f.exists();
    }

    @Override
    public void ignoreFile(File file) {
        try {
            File f = new File(file.getAbsolutePath() + IGNORE);
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class FileFileInfo
    implements FileInfo {
        private File theFile;

        public FileFileInfo(File theFile) {
            this.theFile = theFile;
        }

        @Override
        public String getName() {
            return this.theFile.getName();
        }

        @Override
        public String getAbsolutePath() {
            return this.theFile.getAbsolutePath();
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return this.theFile.getCanonicalPath();
        }

        @Override
        public String getParent() {
            return this.theFile.getParent();
        }

        @Override
        public long getSize() {
            return this.theFile.length();
        }

        @Override
        public long getLastModified() {
            return this.theFile.lastModified();
        }

        @Override
        public boolean isDirectory() {
            return this.theFile.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.theFile.isFile();
        }

        @Override
        public boolean isReadable() {
            return this.theFile.canRead();
        }

        @Override
        public void populateSourceMap(Map<String, Object> sourceMap) {
        }
    }
}

