/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filesystems;

import com.mirth.connect.connectors.file.FileConnectorException;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileInfo;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filters.RegexFilenameFilter;
import com.mirth.connect.userutil.MessageHeaders;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsGetSessionTokenCredentialsProvider;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;

public class S3Connection
implements FileSystemConnection {
    static final String DELIMITER = "/";
    private Logger logger = LogManager.getLogger(this.getClass());
    FileSystemConnectionOptions fileSystemOptions;
    S3SchemeProperties schemeProps;
    S3ClientBuilder clientBuilder;
    S3Client client;
    StsClient sts;
    int stsDuration;

    public S3Connection(FileSystemConnectionOptions fileSystemOptions, int timeout) throws Exception {
        this.fileSystemOptions = fileSystemOptions;
        this.schemeProps = (S3SchemeProperties)fileSystemOptions.getSchemeProperties();
        this.clientBuilder = S3Client.builder();
        this.clientBuilder.httpClientBuilder(this.createClientConfiguration(timeout));
        if (this.isSTSEnabled()) {
            StsClientBuilder stsClientBuilder = StsClient.builder();
            stsClientBuilder.httpClientBuilder(this.createClientConfiguration(timeout));
            stsClientBuilder.credentialsProvider(this.createCredentialsProvider(fileSystemOptions));
            stsClientBuilder.region(Region.of((String)this.schemeProps.getRegion()));
            this.sts = (StsClient)stsClientBuilder.build();
            this.stsDuration = this.schemeProps.getDuration();
            if (this.stsDuration < 900) {
                this.stsDuration = 900;
            } else if (this.stsDuration > 129600) {
                this.stsDuration = 129600;
            }
        } else {
            this.clientBuilder.credentialsProvider(this.createCredentialsProvider(fileSystemOptions));
            this.clientBuilder.region(Region.of((String)this.schemeProps.getRegion()));
            this.client = (S3Client)this.clientBuilder.build();
        }
    }

    boolean isSTSEnabled() {
        return this.schemeProps.isUseTemporaryCredentials() && !this.fileSystemOptions.isAnonymous();
    }

    SdkHttpClient.Builder<ApacheHttpClient.Builder> createClientConfiguration(int timeout) {
        Duration timeoutDuration = Duration.ofMillis(timeout);
        return ApacheHttpClient.builder().connectionTimeout(timeoutDuration).socketTimeout(timeoutDuration);
    }

    AwsCredentialsProvider createCredentialsProvider(FileSystemConnectionOptions fileSystemOptions) {
        S3SchemeProperties schemeProps = (S3SchemeProperties)fileSystemOptions.getSchemeProperties();
        if (fileSystemOptions.isAnonymous()) {
            return AnonymousCredentialsProvider.create();
        }
        if (schemeProps.isUseDefaultCredentialProviderChain() && StringUtils.isBlank((CharSequence)fileSystemOptions.getUsername()) && StringUtils.isBlank((CharSequence)fileSystemOptions.getPassword())) {
            return DefaultCredentialsProvider.create();
        }
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)fileSystemOptions.getUsername(), (String)fileSystemOptions.getPassword()));
    }

    S3Client getClient() {
        if (this.isSTSEnabled() && this.client == null) {
            GetSessionTokenRequest getSessionTokenRequest = (GetSessionTokenRequest)GetSessionTokenRequest.builder().durationSeconds(Integer.valueOf(this.stsDuration)).build();
            this.clientBuilder.credentialsProvider((AwsCredentialsProvider)((StsGetSessionTokenCredentialsProvider.Builder)StsGetSessionTokenCredentialsProvider.builder().stsClient(this.sts)).refreshRequest(getSessionTokenRequest).build());
            this.clientBuilder.region(Region.of((String)this.schemeProps.getRegion()));
            this.client = (S3Client)this.clientBuilder.build();
        }
        return this.client;
    }

    Pair<String, String> getBucketNameAndPrefix(String fromDir) {
        String bucketName = null;
        String prefix = null;
        if (StringUtils.isNotBlank((CharSequence)fromDir)) {
            while (StringUtils.startsWith((CharSequence)fromDir, (CharSequence)DELIMITER)) {
                fromDir = StringUtils.substring((String)fromDir, (int)1);
            }
            int index = StringUtils.indexOf((CharSequence)fromDir, (CharSequence)DELIMITER);
            if (index > 0) {
                bucketName = StringUtils.substring((String)fromDir, (int)0, (int)index);
                prefix = StringUtils.trimToNull((String)StringUtils.substring((String)fromDir, (int)(index + 1)));
            } else {
                bucketName = fromDir;
            }
        }
        return new ImmutablePair(bucketName, prefix);
    }

    String normalizeKey(String key, boolean leadingDelimiter, boolean trailingDelimiter) {
        if (key != null) {
            if (leadingDelimiter) {
                if (!StringUtils.startsWith((CharSequence)key, (CharSequence)DELIMITER)) {
                    key = DELIMITER + (String)key;
                }
            } else {
                while (StringUtils.startsWith((CharSequence)key, (CharSequence)DELIMITER)) {
                    key = StringUtils.substring((String)key, (int)1);
                }
            }
            if (trailingDelimiter) {
                if (!StringUtils.endsWith((CharSequence)key, (CharSequence)DELIMITER)) {
                    key = (String)key + DELIMITER;
                }
            } else {
                while (StringUtils.endsWith((CharSequence)key, (CharSequence)DELIMITER)) {
                    key = StringUtils.substring((String)key, (int)0, (int)(((String)key).length() - 1));
                }
            }
        }
        return key;
    }

    ListObjectsV2Request.Builder createListRequest(String bucketName, String prefix) {
        return ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix).delimiter(DELIMITER);
    }

    Map<String, String> getCustomHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (MapUtils.isNotEmpty((Map)this.schemeProps.getCustomHeaders())) {
            for (Map.Entry entry : this.schemeProps.getCustomHeaders().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    headers.put((String)entry.getKey(), value);
                }
            }
        }
        return headers;
    }

    void addMetadataIfNotNull(Map<String, Object> map, String key, Object value) {
        if (map != null && value != null) {
            map.put(key, value);
        }
    }

    void populateObjectMetadata(Map<String, Object> map, Map<String, List<String>> objectMetadata) {
        if (map != null) {
            map.put("s3Metadata", new MessageHeaders(objectMetadata));
        }
    }

    private String unquote(String str) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)str, (String)"\""), (String)"\"");
    }

    @Override
    public List<FileInfo> listFiles(String fromDir, String filenamePattern, boolean isRegex, boolean ignoreDot) throws Exception {
        try {
            return this.doListFiles(fromDir, filenamePattern, isRegex, ignoreDot);
        }
        catch (AwsServiceException e) {
            this.handleException(e);
            return this.doListFiles(fromDir, filenamePattern, isRegex, ignoreDot);
        }
    }

    List<FileInfo> doListFiles(String fromDir, String filenamePattern, boolean isRegex, boolean ignoreDot) throws Exception {
        ListObjectsV2Response result;
        RegexFilenameFilter filenameFilter;
        String filePrefix = null;
        if (isRegex) {
            filenameFilter = new RegexFilenameFilter(filenamePattern);
        } else {
            String[] wildcards = filenamePattern.trim().split("\\s*,\\s*");
            if (wildcards.length == 1 && StringUtils.length((CharSequence)wildcards[0]) > 1 && StringUtils.indexOf((CharSequence)wildcards[0], (CharSequence)"*") == wildcards[0].length() - 1) {
                filePrefix = wildcards[0].substring(0, wildcards[0].length() - 1);
            }
            filenameFilter = new WildcardFileFilter(wildcards);
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        S3Client client = this.getClient();
        Pair<String, String> bucketNameAndPrefix = this.getBucketNameAndPrefix(fromDir);
        String bucketName = (String)bucketNameAndPrefix.getLeft();
        String dirPrefix = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, true);
        ListObjectsV2Request.Builder requestBuilder = this.createListRequest(bucketName, dirPrefix);
        if (StringUtils.isNotBlank(filePrefix)) {
            requestBuilder.prefix(StringUtils.trimToEmpty((String)dirPrefix) + filePrefix);
        }
        do {
            result = client.listObjectsV2((ListObjectsV2Request)requestBuilder.build());
            for (S3Object s3Object : result.contents()) {
                if (StringUtils.equals((CharSequence)s3Object.key(), (CharSequence)dirPrefix)) continue;
                S3FileInfo fileInfo = new S3FileInfo(bucketName, s3Object);
                if (filenameFilter != null && !filenameFilter.accept(null, fileInfo.getName()) || ignoreDot && StringUtils.startsWith((CharSequence)fileInfo.getName(), (CharSequence)".")) continue;
                fileInfoList.add(fileInfo);
            }
            requestBuilder.continuationToken(result.nextContinuationToken());
        } while (result.isTruncated().booleanValue());
        return fileInfoList;
    }

    @Override
    public List<String> listDirectories(String fromDir) throws Exception {
        try {
            return this.doListDirectories(fromDir);
        }
        catch (AwsServiceException e) {
            this.handleException(e);
            return this.doListDirectories(fromDir);
        }
    }

    List<String> doListDirectories(String fromDir) throws Exception {
        ListObjectsV2Response result;
        ArrayList<String> directories = new ArrayList<String>();
        S3Client client = this.getClient();
        Pair<String, String> bucketNameAndPrefix = this.getBucketNameAndPrefix(fromDir);
        String bucketName = (String)bucketNameAndPrefix.getLeft();
        String prefix = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, true);
        ListObjectsV2Request.Builder requestBuilder = this.createListRequest(bucketName, prefix);
        do {
            result = client.listObjectsV2((ListObjectsV2Request)requestBuilder.build());
            for (CommonPrefix commonPrefix : result.commonPrefixes()) {
                directories.add(bucketName + DELIMITER + commonPrefix.prefix());
            }
            requestBuilder.continuationToken(result.nextContinuationToken());
        } while (result.isTruncated().booleanValue());
        return directories;
    }

    @Override
    public boolean exists(String file, String path) throws Exception {
        try {
            return this.doExists(file, path);
        }
        catch (AwsServiceException e) {
            this.handleException(e);
            return this.doExists(file, path);
        }
    }

    boolean doExists(String file, String path) throws Exception {
        S3Client client = this.getClient();
        Pair<String, String> bucketNameAndPrefix = this.getBucketNameAndPrefix(path);
        String bucketName = (String)bucketNameAndPrefix.getLeft();
        String prefix = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, true);
        Object key = file;
        if (StringUtils.isNotBlank((CharSequence)prefix) && !StringUtils.equals((CharSequence)prefix, (CharSequence)DELIMITER)) {
            key = prefix + (String)key;
        }
        try {
            HeadObjectResponse response = client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key((String)key).build());
            return response != null && (response.deleteMarker() == null || response.deleteMarker() == false);
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    @Override
    public InputStream readFile(String file, String fromDir, Map<String, Object> sourceMap) throws Exception {
        try {
            return this.doReadFile(file, fromDir, sourceMap);
        }
        catch (AwsServiceException e) {
            this.handleException(e);
            return this.doReadFile(file, fromDir, sourceMap);
        }
    }

    InputStream doReadFile(String file, String fromDir, Map<String, Object> sourceMap) throws Exception {
        S3Client client = this.getClient();
        Pair<String, String> bucketNameAndPrefix = this.getBucketNameAndPrefix(fromDir);
        String bucketName = (String)bucketNameAndPrefix.getLeft();
        String prefix = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, true);
        Object key = file;
        if (StringUtils.isNotBlank((CharSequence)prefix) && !StringUtils.equals((CharSequence)prefix, (CharSequence)DELIMITER)) {
            key = prefix + (String)key;
        }
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key((String)key).build();
        CustomS3Response response = (CustomS3Response)client.getObject(request, new CustomResponseTransformer());
        this.populateObjectMetadata(sourceMap, ((GetObjectResponse)response.getResponse()).sdkHttpResponse().headers());
        return response.getData();
    }

    @Override
    public void closeReadFile() throws Exception {
    }

    @Override
    public boolean canAppend() {
        return false;
    }

    @Override
    public void writeFile(String file, String toDir, boolean append, InputStream message, long contentLength, Map<String, Object> connectorMap) throws Exception {
        try {
            this.doWriteFile(file, toDir, append, message, contentLength, connectorMap);
        }
        catch (AwsServiceException e) {
            this.handleException(e);
            this.doWriteFile(file, toDir, append, message, contentLength, connectorMap);
        }
    }

    void doWriteFile(String file, String toDir, boolean append, InputStream message, long contentLength, Map<String, Object> connectorMap) throws Exception {
        S3Client client = this.getClient();
        Pair<String, String> bucketNameAndPrefix = this.getBucketNameAndPrefix(toDir);
        String bucketName = (String)bucketNameAndPrefix.getLeft();
        String prefix = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, true);
        Object key = file;
        if (StringUtils.isNotBlank((CharSequence)prefix) && !StringUtils.equals((CharSequence)prefix, (CharSequence)DELIMITER)) {
            key = prefix + (String)key;
        }
        PutObjectRequest putRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key((String)key).metadata(this.getCustomHeaders()).build();
        PutObjectResponse result = client.putObject(putRequest, RequestBody.fromInputStream((InputStream)message, (long)contentLength));
        if (connectorMap != null) {
            this.addMetadataIfNotNull(connectorMap, "s3ETag", this.unquote(result.eTag()));
            this.addMetadataIfNotNull(connectorMap, "s3ExpirationTime", result.expiration());
            this.addMetadataIfNotNull(connectorMap, "s3SSEAlgorithm", result.serverSideEncryptionAsString());
            this.addMetadataIfNotNull(connectorMap, "s3SSECustomerAlgorithm", result.sseCustomerAlgorithm());
            this.addMetadataIfNotNull(connectorMap, "s3SSECustomerKeyMd5", result.sseCustomerKeyMD5());
            this.addMetadataIfNotNull(connectorMap, "s3VersionId", result.versionId());
        }
    }

    @Override
    public void delete(String file, String fromDir, boolean mayNotExist) throws Exception {
        try {
            this.doDelete(file, fromDir, mayNotExist);
        }
        catch (AwsServiceException e) {
            this.handleException(e);
            this.doDelete(file, fromDir, mayNotExist);
        }
    }

    void doDelete(String file, String fromDir, boolean mayNotExist) throws Exception {
        S3Client client = this.getClient();
        Pair<String, String> bucketNameAndPrefix = this.getBucketNameAndPrefix(fromDir);
        String bucketName = (String)bucketNameAndPrefix.getLeft();
        String prefix = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, true);
        Object key = file;
        if (StringUtils.isNotBlank((CharSequence)prefix) && !StringUtils.equals((CharSequence)prefix, (CharSequence)DELIMITER)) {
            key = prefix + (String)key;
        }
        DeleteObjectRequest deleteRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucketName).key((String)key).build();
        client.deleteObject(deleteRequest);
        if (mayNotExist && this.exists(file, fromDir)) {
            throw new FileConnectorException("File should not exist after deleting, bucket: " + fromDir + ", file: " + file);
        }
    }

    @Override
    public void move(String fromName, String fromDir, String toName, String toDir) throws Exception {
        try {
            this.doMove(fromName, fromDir, toName, toDir);
        }
        catch (AwsServiceException e) {
            this.handleException(e);
            this.doMove(fromName, fromDir, toName, toDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMove(String fromName, String fromDir, String toName, String toDir) throws Exception {
        S3Client client = this.getClient();
        Pair<String, String> fromBucketNameAndPrefix = this.getBucketNameAndPrefix(fromDir);
        String fromBucketName = (String)fromBucketNameAndPrefix.getLeft();
        String fromPrefix = this.normalizeKey((String)fromBucketNameAndPrefix.getRight(), false, true);
        Object fromKey = fromName;
        if (StringUtils.isNotBlank((CharSequence)fromPrefix) && !StringUtils.equals((CharSequence)fromPrefix, (CharSequence)DELIMITER)) {
            fromKey = fromPrefix + (String)fromKey;
        }
        Pair<String, String> toBucketNameAndPrefix = this.getBucketNameAndPrefix(toDir);
        String toBucketName = (String)toBucketNameAndPrefix.getLeft();
        String toPrefix = this.normalizeKey((String)toBucketNameAndPrefix.getRight(), false, true);
        Object toKey = toName;
        if (StringUtils.isNotBlank((CharSequence)toPrefix) && !StringUtils.equals((CharSequence)toPrefix, (CharSequence)DELIMITER)) {
            toKey = toPrefix + (String)toKey;
        }
        try {
            if (this.fileSystemOptions.isAnonymous()) {
                GetObjectRequest getRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(fromBucketName).key((String)fromKey).build();
                CustomS3Response response = (CustomS3Response)client.getObject(getRequest, new CustomResponseTransformer());
                try {
                    PutObjectRequest putRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(toBucketName).key((String)toKey).metadata(this.getCustomHeaders()).build();
                    client.putObject(putRequest, RequestBody.fromInputStream((InputStream)new BufferedInputStream(response.getData()), (long)((GetObjectResponse)response.getResponse()).contentLength()));
                }
                finally {
                    IOUtils.closeQuietly((Closeable)response.getData());
                }
            } else {
                String fromUrl = URLEncoder.encode(fromBucketName + DELIMITER + (String)fromKey, StandardCharsets.UTF_8.toString());
                client.copyObject((CopyObjectRequest)CopyObjectRequest.builder().copySource(fromUrl).bucket(toBucketName).key((String)toKey).build());
            }
            this.delete(fromName, fromDir, false);
        }
        catch (Exception e) {
            throw new FileConnectorException("Error moving file from [bucket: " + fromBucketName + ", key: " + (String)fromKey + "] to [bucket: " + toBucketName + ", key: " + (String)toKey + "]", e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.isValid();
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
    }

    @Override
    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.sts != null) {
            this.sts.close();
        }
    }

    @Override
    public boolean isValid() {
        return this.client != null || this.sts != null;
    }

    @Override
    public boolean canRead(String readDir) {
        try {
            ListObjectsV2Response result;
            S3Client client = this.getClient();
            Pair<String, String> bucketNameAndPrefix = this.getBucketNameAndPrefix(readDir);
            String bucketName = (String)bucketNameAndPrefix.getLeft();
            String prefix = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, false);
            String prefixWithTrailingDelimiter = this.normalizeKey((String)bucketNameAndPrefix.getRight(), false, true);
            CommonPrefix commonPrefixWithTrailingDelimiter = (CommonPrefix)CommonPrefix.builder().prefix(prefixWithTrailingDelimiter).build();
            ListObjectsV2Request.Builder requestBuilder = this.createListRequest(bucketName, prefix);
            do {
                result = client.listObjectsV2((ListObjectsV2Request)requestBuilder.build());
                if (StringUtils.isBlank((CharSequence)prefixWithTrailingDelimiter) || result.commonPrefixes().contains(commonPrefixWithTrailingDelimiter)) {
                    return true;
                }
                requestBuilder.continuationToken(result.nextContinuationToken());
            } while (result.isTruncated().booleanValue());
        }
        catch (Exception e) {
            this.logger.debug("Exception while attempting to read from S3 location \"" + readDir + "\".", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean canWrite(String writeDir) {
        return this.canRead(writeDir);
    }

    void handleException(AwsServiceException e) throws AwsServiceException {
        if (this.isSTSEnabled() && e.awsErrorDetails() != null && StringUtils.equals((CharSequence)e.awsErrorDetails().errorCode(), (CharSequence)"ExpiredToken")) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        } else {
            throw e;
        }
    }

    public class S3FileInfo
    implements FileInfo {
        private String bucketName;
        private S3Object s3Object;
        private String parent;
        private String name;

        public S3FileInfo(String bucketName, S3Object s3Object) {
            this.bucketName = bucketName;
            this.s3Object = s3Object;
            this.parent = bucketName;
            this.name = s3Object.key();
            if (StringUtils.contains((CharSequence)s3Object.key(), (CharSequence)S3Connection.DELIMITER)) {
                int index = s3Object.key().lastIndexOf(S3Connection.DELIMITER);
                this.parent = this.parent + S3Connection.DELIMITER + s3Object.key().substring(0, index);
                this.name = s3Object.key().substring(index + S3Connection.DELIMITER.length());
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAbsolutePath() {
            return this.bucketName + S3Connection.DELIMITER + this.s3Object.key();
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return this.getAbsolutePath();
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        @Override
        public long getSize() {
            return this.s3Object.size();
        }

        @Override
        public long getLastModified() {
            return this.s3Object.lastModified().toEpochMilli();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public void populateSourceMap(Map<String, Object> sourceMap) {
            S3Connection.this.addMetadataIfNotNull(sourceMap, "s3BucketName", this.bucketName);
            S3Connection.this.addMetadataIfNotNull(sourceMap, "s3ETag", S3Connection.this.unquote(this.s3Object.eTag()));
            S3Connection.this.addMetadataIfNotNull(sourceMap, "s3Key", this.s3Object.key());
            S3Connection.this.addMetadataIfNotNull(sourceMap, "s3Owner", this.s3Object.owner());
            S3Connection.this.addMetadataIfNotNull(sourceMap, "s3StorageClass", this.s3Object.storageClassAsString());
        }
    }

    private class CustomResponseTransformer<T extends S3Response>
    implements ResponseTransformer<T, CustomS3Response<T>> {
        private CustomResponseTransformer() {
        }

        public CustomS3Response<T> transform(T response, AbortableInputStream inputStream) throws Exception {
            return new CustomS3Response(S3Connection.this, response, (InputStream)inputStream);
        }

        public boolean needsConnectionLeftOpen() {
            return true;
        }
    }

    private static class CustomS3Response<T extends S3Response> {
        private T response;
        private InputStream data;
        final /* synthetic */ S3Connection this$0;

        public CustomS3Response(T response, InputStream data) {
            this.this$0 = var1_1;
            this.response = response;
            this.data = data;
        }

        public T getResponse() {
            return this.response;
        }

        public InputStream getData() {
            return this.data;
        }
    }
}

