/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filesystems;

import com.mirth.connect.connectors.file.FileConnectorException;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.SmbSchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileInfo;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filters.SmbFilenameWildcardFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.SmbResource;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbFilenameFilter;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmbFileConnection
implements FileSystemConnection {
    private Logger logger = LogManager.getLogger(this.getClass());
    private NtlmPasswordAuthenticator auth = null;
    private SmbFile share = null;
    private int timeout;

    public SmbFileConnection(String share, FileSystemConnectionOptions fileSystemOptions, int timeout) throws Exception {
        String domainAndUser = fileSystemOptions.getUsername();
        String password = fileSystemOptions.getPassword();
        String[] params = Pattern.compile("[\\\\|/|@|:|;]").split(domainAndUser);
        String domain = null;
        String username = null;
        if (params.length > 1) {
            domain = params[0];
            username = params[1];
        } else {
            username = params[0];
        }
        if (username != null && password != null) {
            this.auth = new NtlmPasswordAuthenticator(domain, username, password);
        }
        String minVersion = ((SmbSchemeProperties)fileSystemOptions.getSchemeProperties()).getSmbMinVersion();
        String maxVersion = ((SmbSchemeProperties)fileSystemOptions.getSchemeProperties()).getSmbMaxVersion();
        Properties jcifsProperties = new Properties();
        jcifsProperties.setProperty("jcifs.smb.client.minVersion", minVersion);
        jcifsProperties.setProperty("jcifs.smb.client.maxVersion", maxVersion);
        jcifsProperties.setProperty("jcifs.smb.client.useExtendedSecurity", "true");
        jcifsProperties.setProperty("jcifs.smb.lmCompatibility", "3");
        CIFSContext baseContext = new BaseContext((Configuration)new PropertyConfiguration(jcifsProperties)).withCredentials((Credentials)this.auth);
        this.share = new SmbFile("smb://" + share, baseContext);
        this.share.setConnectTimeout(timeout);
        this.timeout = timeout;
    }

    protected SmbFile getShare() {
        return this.share;
    }

    protected void setShare(SmbFile share) {
        this.share = share;
    }

    protected String getPath(String dir, String name) {
        if (dir == null) {
            dir = "";
        }
        if (((String)dir).endsWith("/")) {
            dir = ((String)dir).substring(0, ((String)dir).length() - 1);
        }
        if (!((String)dir).startsWith("smb://")) {
            dir = ((String)dir).length() < 1 ? this.share.getURL().toString() : (((String)dir).startsWith("/") ? this.share.getURL().toString() + (String)dir : this.share.getURL().toString() + "/" + (String)dir);
        }
        if (name != null) {
            if (name.startsWith("/")) {
                name = name.substring(1, name.length());
            }
            return (String)dir + "/" + name;
        }
        return (String)dir + "/";
    }

    protected SmbFile getSmbFile(SmbFile share, String name) throws Exception {
        CIFSContext context = share.getContext();
        SmbFile smbFile = new SmbFile(name, context);
        smbFile.setConnectTimeout(this.timeout);
        return smbFile;
    }

    @Override
    public List<FileInfo> listFiles(String dir, String filenamePattern, boolean isRegex, boolean ignoreDot) throws Exception {
        SmbFile readDirectory = null;
        SmbFilenameWildcardFilter filenameFilter = new SmbFilenameWildcardFilter(filenamePattern, isRegex);
        try {
            readDirectory = this.getSmbFile(this.share, this.getPath(dir, null));
        }
        catch (Exception e) {
            throw new FileConnectorException("Directory does not exist: " + dir, e);
        }
        try {
            SmbFile[] todoFiles = readDirectory.listFiles((SmbFilenameFilter)filenameFilter);
            if (todoFiles == null) {
                return new ArrayList<FileInfo>();
            }
            ArrayList<FileInfo> result = new ArrayList<FileInfo>(todoFiles.length);
            for (SmbFile f : todoFiles) {
                if (!f.isFile() || ignoreDot && f.getName().startsWith(".")) continue;
                result.add(new SmbFileFileInfo(f));
            }
            return result;
        }
        catch (Exception e) {
            throw new FileConnectorException("Error listing files in dir [" + dir + "] for pattern [" + filenamePattern + "]", e);
        }
    }

    @Override
    public List<String> listDirectories(String fromDir) throws Exception {
        ArrayList<String> directories = new ArrayList<String>();
        SmbFile readDirectory = null;
        try {
            readDirectory = this.getSmbFile(this.share, this.getPath(fromDir, null));
        }
        catch (Exception e) {
            throw new FileConnectorException("Directory does not exist: " + fromDir, e);
        }
        SmbFileFilter fileFilter = new SmbFileFilter(){

            public boolean accept(SmbFile file) throws SmbException {
                return file.isDirectory();
            }
        };
        for (SmbFile directory : readDirectory.listFiles(fileFilter)) {
            directories.add(directory.getCanonicalPath());
        }
        return directories;
    }

    @Override
    public boolean exists(String file, String path) {
        try {
            return this.getSmbFile(this.share, this.getPath(path, file)).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canRead(String readDir) {
        try {
            return this.getSmbFile(this.share, this.getPath(readDir, null)).canRead();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canWrite(String writeDir) {
        boolean bl;
        SmbFile dst;
        SmbFileOutputStream os;
        block13: {
            os = null;
            dst = null;
            try {
                dst = this.getSmbFile(this.share, this.getPath(writeDir, UUID.randomUUID().toString()));
                os = new SmbFileOutputStream(dst, false);
                bl = true;
                if (os == null) break block13;
            }
            catch (Exception e) {
                boolean bl2 = false;
                return bl2;
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        try {
            if (!dst.exists()) return bl;
            dst.delete();
            return bl;
        }
        catch (Exception e) {
            this.logger.warn("Failed to delete test write file.", (Throwable)e);
        }
        return bl;
        finally {
            if (os != null) {
                IOUtils.closeQuietly(os);
            }
            try {
                if (dst.exists()) {
                    dst.delete();
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to delete test write file.", (Throwable)e);
            }
        }
    }

    @Override
    public InputStream readFile(String name, String dir, Map<String, Object> sourceMap) throws FileConnectorException {
        SmbFile src = null;
        try {
            src = this.getSmbFile(this.share, this.getPath(dir, name));
            return new SmbFileInputStream(src);
        }
        catch (Exception e) {
            throw new FileConnectorException("Error reading file: " + src.getPath(), e);
        }
    }

    @Override
    public void closeReadFile() throws Exception {
    }

    @Override
    public boolean canAppend() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(String name, String dir, boolean append, InputStream is, long contentLength, Map<String, Object> connectorMap) throws Exception {
        OutputStream os = null;
        SmbFile dst = null;
        SmbFile dstDir = null;
        try {
            dstDir = this.getSmbFile(this.share, this.getPath(dir, null));
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            dst = this.getSmbFile(this.share, this.getPath(dir, name));
            os = new SmbFileOutputStream(dst, append);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    @Override
    public void delete(String name, String dir, boolean mayNotExist) throws FileConnectorException {
        SmbFile src = null;
        try {
            src = this.getSmbFile(this.share, this.getPath(dir, name));
            src.delete();
            if (src.exists() && !mayNotExist) {
                throw new FileConnectorException("Source file was deleted, should not exist: " + src.getPath());
            }
        }
        catch (Exception e) {
            throw new FileConnectorException("Error deleting file: " + src.getPath(), e);
        }
    }

    @Override
    public void move(String fromName, String fromDir, String toName, String toDir) throws FileConnectorException {
        SmbFile src = null;
        SmbFile dst = null;
        SmbFile dstDir = null;
        try {
            src = this.getSmbFile(this.share, this.getPath(fromDir, fromName));
            dstDir = this.getSmbFile(this.share, this.getPath(toDir, null));
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            dst = this.getSmbFile(this.share, this.getPath(toDir, toName));
            try {
                dst.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            src.renameTo((SmbResource)dst);
        }
        catch (Exception e) {
            throw new FileConnectorException("Error moving file from [" + src.getPath() + "] to [" + dst.getPath() + "]", e);
        }
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
    }

    @Override
    public void destroy() {
        try {
            this.share.getContext().close();
        }
        catch (CIFSException e) {
            this.logger.error("Error attempting to close SMB file context.", (Throwable)e);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public class SmbFileFileInfo
    implements FileInfo {
        private SmbFile theFile;

        public SmbFileFileInfo(SmbFile theFile) {
            this.theFile = theFile;
        }

        @Override
        public String getName() {
            return this.theFile.getName();
        }

        @Override
        public String getAbsolutePath() {
            return this.theFile.getPath();
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return this.theFile.getCanonicalPath();
        }

        @Override
        public String getParent() {
            return this.theFile.getParent();
        }

        @Override
        public long getSize() {
            try {
                return this.theFile.length();
            }
            catch (SmbException e) {
                return 0L;
            }
        }

        @Override
        public long getLastModified() {
            return this.theFile.getLastModified();
        }

        @Override
        public boolean isDirectory() {
            try {
                return this.theFile.isDirectory();
            }
            catch (SmbException e) {
                return false;
            }
        }

        @Override
        public boolean isFile() {
            try {
                return this.theFile.isFile();
            }
            catch (SmbException e) {
                return false;
            }
        }

        @Override
        public boolean isReadable() {
            try {
                return this.theFile.canRead();
            }
            catch (SmbException e) {
                return false;
            }
        }

        @Override
        public void populateSourceMap(Map<String, Object> sourceMap) {
        }
    }
}

