/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.jaxb;

import de.odysseus.staxon.json.JsonXMLConfig;
import de.odysseus.staxon.json.JsonXMLConfigBuilder;
import de.odysseus.staxon.json.JsonXMLInputFactory;
import de.odysseus.staxon.json.JsonXMLOutputFactory;
import de.odysseus.staxon.json.jaxb.JsonXML;
import de.odysseus.staxon.json.jaxb.JsonXMLRootProvider;
import de.odysseus.staxon.json.util.XMLMultipleStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class JsonXMLBinder {
    private final JsonXMLRootProvider rootProvider;
    private final boolean writeDocumentArray;

    public JsonXMLBinder() {
        this(true);
    }

    protected JsonXMLBinder(boolean writeDocumentArray) {
        this(new JsonXMLRootProvider(), writeDocumentArray);
    }

    protected JsonXMLBinder(JsonXMLRootProvider rootProvider, boolean writeDocumentArray) {
        this.rootProvider = rootProvider;
        this.writeDocumentArray = writeDocumentArray;
    }

    private Map<String, String> namespaceMappings(String[] names) {
        if (names == null || names.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : names) {
            QName qName = QName.valueOf(name);
            map.put(qName.getLocalPart(), qName.getNamespaceURI());
        }
        return map;
    }

    private JsonXMLConfig toJsonXMLConfig(Class<?> type, JsonXML config) throws JAXBException {
        return new JsonXMLConfigBuilder().autoArray(config.autoArray()).autoPrimitive(config.autoPrimitive()).multiplePI(true).namespaceDeclarations(config.namespaceDeclarations()).namespaceSeparator(config.namespaceSeparator()).prettyPrint(config.prettyPrint()).virtualRoot(config.virtualRoot() ? this.rootProvider.getName(type) : null).namespaceMappings(this.namespaceMappings(config.namespaceMappings())).build();
    }

    protected JsonXMLInputFactory createInputFactory(Class<?> type, JsonXML config) throws JAXBException {
        return new JsonXMLInputFactory(this.toJsonXMLConfig(type, config));
    }

    protected XMLStreamReader createXMLStreamReader(Class<?> type, JsonXML config, Reader stream) throws XMLStreamException, JAXBException {
        return this.createInputFactory(type, config).createXMLStreamReader(stream);
    }

    protected JsonXMLOutputFactory createOutputFactory(Class<?> type, JsonXML config) throws JAXBException {
        return new JsonXMLOutputFactory(this.toJsonXMLConfig(type, config));
    }

    protected XMLStreamWriter createXMLStreamWriter(Class<?> type, JsonXML config, Writer stream) throws XMLStreamException, JAXBException {
        XMLStreamWriter writer = this.createOutputFactory(type, config).createXMLStreamWriter(stream);
        if (config.multiplePaths().length > 0) {
            writer = new XMLMultipleStreamWriter(writer, !config.virtualRoot(), config.multiplePaths());
        }
        return writer;
    }

    public boolean isBindable(Class<?> type) {
        return type.isAnnotationPresent(XmlRootElement.class) || type.isAnnotationPresent(XmlType.class);
    }

    private void checkBindable(Class<?> type) throws JAXBException {
        if (!this.isBindable(type)) {
            throw new JAXBException("Cannot bind type: " + type.getName());
        }
    }

    protected <T> T unmarshal(Class<? extends T> type, JsonXML config, Unmarshaller unmarshaller, XMLStreamReader reader) throws JAXBException, XMLStreamException {
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            return type.cast(unmarshaller.unmarshal(reader));
        }
        if (type.isAnnotationPresent(XmlType.class)) {
            return (T)unmarshaller.unmarshal(reader, type).getValue();
        }
        return type.cast(unmarshaller.unmarshal(reader, type));
    }

    protected void marshal(Class<?> type, JsonXML config, Marshaller marshaller, XMLStreamWriter writer, Object value) throws JAXBException, XMLStreamException {
        JAXBElement<?> element = null;
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            element = value;
        } else if (type.isAnnotationPresent(XmlType.class)) {
            element = this.rootProvider.createElement(type, value);
            if (element == null) {
                throw new JAXBException("Cannot create JAXBElement");
            }
        } else {
            element = value;
        }
        marshaller.marshal((Object)element, writer);
    }

    public <T> T readObject(Class<? extends T> type, JsonXML config, JAXBContext context, Reader stream) throws XMLStreamException, JAXBException {
        T result;
        this.checkBindable(type);
        XMLStreamReader reader = this.createXMLStreamReader(type, config, stream);
        if (reader.isCharacters() && reader.getText() == null) {
            result = null;
        } else {
            reader.require(7, null, null);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            result = this.unmarshal(type, config, unmarshaller, reader);
            reader.require(8, null, null);
        }
        reader.close();
        return result;
    }

    public void writeObject(Class<?> type, JsonXML config, JAXBContext context, Writer stream, Object value) throws XMLStreamException, JAXBException {
        this.checkBindable(type);
        XMLStreamWriter writer = this.createXMLStreamWriter(type, config, stream);
        if (value == null) {
            writer.writeCharacters(null);
        } else {
            Marshaller marshaller = context.createMarshaller();
            this.marshal(type, config, marshaller, writer, value);
        }
        writer.close();
    }

    public <T> List<T> readArray(Class<? extends T> type, JsonXML config, JAXBContext context, Reader stream) throws XMLStreamException, JAXBException {
        ArrayList<T> result;
        this.checkBindable(type);
        XMLStreamReader reader = this.createXMLStreamReader(type, config, stream);
        if (reader.isCharacters() && reader.getText() == null) {
            result = null;
        } else {
            boolean documentArray = "xml-multiple".equals(reader.getPITarget());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            while (reader.hasNext() && !reader.isStartElement() && !reader.isCharacters()) {
                reader.next();
            }
            result = new ArrayList<T>();
            while (reader.hasNext() || reader.isCharacters() && reader.getText() == null) {
                if (reader.isCharacters() && reader.getText() == null) {
                    result.add(null);
                    if (!reader.hasNext()) break;
                    reader.next();
                    continue;
                }
                result.add(this.unmarshal(type, config, unmarshaller, reader));
                if (!documentArray || !reader.hasNext()) continue;
                reader.next();
            }
        }
        reader.close();
        return result;
    }

    public void writeArray(Class<?> type, JsonXML config, JAXBContext context, Writer stream, Collection<?> collection) throws XMLStreamException, JAXBException {
        this.checkBindable(type);
        XMLStreamWriter writer = this.createXMLStreamWriter(type, config, stream);
        if (collection == null) {
            writer.writeCharacters(null);
        } else {
            Marshaller marshaller = context.createMarshaller();
            if (!this.writeDocumentArray) {
                writer.writeStartDocument();
                marshaller.setProperty("jaxb.fragment", (Object)true);
            }
            writer.writeProcessingInstruction("xml-multiple");
            for (Object value : collection) {
                if (value == null) {
                    writer.writeCharacters(null);
                    continue;
                }
                this.marshal(type, config, marshaller, writer, value);
            }
            if (!this.writeDocumentArray) {
                writer.writeEndDocument();
            }
        }
        writer.close();
    }
}

