/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.BatchGetValuesRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.ImportValuesRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.LookupGroupRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.LookupValueRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.LookupValueResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LookupModelMapper {
    public static LookupGroup fromGroupDto(LookupGroupRequest lookupGroupRequest) {
        LookupGroup lookupGroup = new LookupGroup();
        lookupGroup.setName(lookupGroupRequest.getName());
        lookupGroup.setDescription(lookupGroupRequest.getDescription());
        lookupGroup.setVersion(lookupGroupRequest.getVersion());
        lookupGroup.setCacheSize(lookupGroupRequest.getCacheSize());
        lookupGroup.setCachePolicy(lookupGroupRequest.getCachePolicy());
        lookupGroup.setCreatedDate(new Date());
        lookupGroup.setUpdatedDate(new Date());
        lookupGroup.setValueType(lookupGroupRequest.getValueType());
        if (lookupGroupRequest.getStatisticsEnabled() != null) {
            lookupGroup.setStatisticsEnabled(lookupGroupRequest.getStatisticsEnabled());
        }
        lookupGroup.setExtra(LookupModelMapper.cloneExtra(lookupGroupRequest.getExtra()));
        return lookupGroup;
    }

    public static LookupGroupExtra cloneExtra(LookupGroupExtra lookupGroupExtra) {
        if (lookupGroupExtra == null) {
            return null;
        }
        try {
            ObjectMapper objectMapper = JsonUtils.getMapper();
            String string = objectMapper.writeValueAsString((Object)lookupGroupExtra);
            return (LookupGroupExtra)objectMapper.readValue(string, LookupGroupExtra.class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to clone LookupGroupExtra", exception);
        }
    }

    public static LookupValue fromValueDto(LookupValueRequest lookupValueRequest) {
        LookupValue lookupValue = new LookupValue();
        lookupValue.setValueData(lookupValueRequest.getValue());
        lookupValue.setCreatedDate(new Date());
        lookupValue.setCreatedDate(new Date());
        return lookupValue;
    }

    public static Map<String, String> fromImportValuesDto(ImportValuesRequest importValuesRequest) {
        if (importValuesRequest == null || importValuesRequest.getValues() == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<String, String>(importValuesRequest.getValues());
    }

    public static List<String> fromBatchGetValues(BatchGetValuesRequest batchGetValuesRequest) {
        if (batchGetValuesRequest == null || batchGetValuesRequest.getKeys() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(batchGetValuesRequest.getKeys());
    }

    public static LookupValueResponse toValueResponse(LookupValue lookupValue, Integer n) {
        return LookupValueResponse.from(lookupValue, n, true);
    }

    public static LookupValueResponse toValueResponse(LookupValue lookupValue, Integer n, boolean bl) {
        return LookupValueResponse.from(lookupValue, n, bl);
    }
}

