/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.dto.request;

import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import java.util.Map;

public class ImportLookupGroupRequest {
    private LookupGroup group;
    private Map<String, String> values;

    public LookupGroup getGroup() {
        return this.group;
    }

    public void setGroup(LookupGroup lookupGroup) {
        this.group = lookupGroup;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setValues(Map<String, String> map) {
        this.values = map;
    }

    public void validate() {
        if (this.group == null) {
            throw new IllegalArgumentException("Group metadata is required.");
        }
        if (this.group.getName() == null || this.group.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Group name is required.");
        }
        if (this.group.getVersion() == null || this.group.getVersion().trim().isEmpty()) {
            throw new IllegalArgumentException("Group version is required.");
        }
        if (this.group.getCachePolicy() == null || this.group.getCachePolicy().trim().isEmpty()) {
            throw new IllegalArgumentException("Cache policy is required.");
        }
        String string = this.group.getCachePolicy().toUpperCase();
        if (!string.equals("LRU") && !string.equals("FIFO")) {
            throw new IllegalArgumentException("Cache policy must be either 'LRU' or 'FIFO'.");
        }
        if (this.group.getCacheSize() <= 0) {
            throw new IllegalArgumentException("Cache size must be greater than zero.");
        }
        if (this.values != null && this.values.size() > 100000) {
            throw new IllegalArgumentException("Too many values in import request. Limit is 100,000.");
        }
    }
}

